/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.clangtidy.outsourced_analysis;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.teamscale.index.findings.CppIncludeHandler;
import com.teamscale.index.findings.clangtidy.ClangTidySynchronizer;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.ClangTidyOutsourcedAnalysisRequestParameters;
import eu.cqse.check.framework.scanner.ELanguage;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.NonNull;

public final class ClangTidyOutsourcedAnalysisHashUtils {
    private static final String CLANG_TIDY_VERSION = ClangTidySynchronizer.loadExpectedClangTidyVersion();

    public static @NonNull Map<String, HashCode> computeInputHashCodesForSubjectFiles(@NonNull ClangTidyOutsourcedAnalysisRequestParameters parameters) {
        HashCode clangTidyOptionsHashCode = ClangTidyOutsourcedAnalysisHashUtils.hashStringMap(parameters.clangTidyOptions());
        HashCode globalCompilerArgumentsHashCode = ClangTidyOutsourcedAnalysisHashUtils.hashStringList(parameters.globalCompilerArguments());
        Map selectedChecksHashesPerLanguage = CollectionUtils.map(parameters.selectedChecksPerLanguage(), Function.identity(), ClangTidyOutsourcedAnalysisHashUtils::hashString);
        HashMap<String, HashCode> inputHashes = new HashMap<String, HashCode>();
        for (ClangTidyOutsourcedAnalysisRequestParameters.AnalysisSubjectInformation subjectInfo : parameters.analysisSubjectInfos()) {
            HashCode inputHashForAnalysisSubject = ClangTidyOutsourcedAnalysisHashUtils.computeInputHashForAnalysisSubject(parameters, subjectInfo, selectedChecksHashesPerLanguage, clangTidyOptionsHashCode, globalCompilerArgumentsHashCode);
            inputHashes.put(subjectInfo.uniformPath(), inputHashForAnalysisSubject);
        }
        return inputHashes;
    }

    private static @NonNull HashCode computeInputHashForAnalysisSubject(@NonNull ClangTidyOutsourcedAnalysisRequestParameters parameters, @NonNull ClangTidyOutsourcedAnalysisRequestParameters.AnalysisSubjectInformation subjectInfo, @NonNull Map<ELanguage, HashCode> selectedChecksHashesPerLanguage, @NonNull HashCode clangTidyOptionsHashCode, @NonNull HashCode globalCompilerArgumentsHashCode) {
        Hasher subjectHasher = Hashing.murmur3_128().newHasher();
        subjectHasher.putBytes(CLANG_TIDY_VERSION.getBytes(StandardCharsets.UTF_8));
        subjectHasher.putBytes(subjectInfo.uniformPath().getBytes(StandardCharsets.UTF_8));
        String subjectContentHash = parameters.fileContentHashes().get(subjectInfo.uniformPath());
        subjectHasher.putBytes(subjectContentHash.getBytes(StandardCharsets.UTF_8));
        ELanguage language = subjectInfo.language();
        subjectHasher.putInt(language.ordinal());
        HashCode selectedChecksHash = selectedChecksHashesPerLanguage.get(language);
        if (selectedChecksHash == null) {
            LogManager.getLogger().warn("No checks selected for language " + String.valueOf(language) + " of file " + subjectInfo.uniformPath());
        }
        subjectHasher.putBytes(ClangTidyOutsourcedAnalysisHashUtils.ensureNonNull(selectedChecksHash));
        for (CppIncludeHandler.IncludeFile includedFileUniformPath : CollectionUtils.sort(subjectInfo.includedPaths(), Comparator.comparing(CppIncludeHandler.IncludeFile::uniformPath))) {
            subjectHasher.putBytes(includedFileUniformPath.uniformPath().getBytes(StandardCharsets.UTF_8));
            subjectHasher.putBytes(ClangTidyOutsourcedAnalysisHashUtils.ensureNonNull(includedFileUniformPath.requiredIncludePathForHeuristicInclude()).getBytes(StandardCharsets.UTF_8));
            String contentHash = parameters.fileContentHashes().get(includedFileUniformPath.uniformPath());
            subjectHasher.putBytes(ClangTidyOutsourcedAnalysisHashUtils.ensureNonNull(contentHash).getBytes(StandardCharsets.UTF_8));
        }
        subjectHasher.putBytes(clangTidyOptionsHashCode.asBytes());
        subjectHasher.putBytes(globalCompilerArgumentsHashCode.asBytes());
        return subjectHasher.hash();
    }

    private static String ensureNonNull(String str) {
        if (str == null) {
            return "0";
        }
        return str;
    }

    private static byte[] ensureNonNull(HashCode hashCode) {
        if (hashCode == null) {
            return new byte[]{0};
        }
        return hashCode.asBytes();
    }

    private static HashCode hashString(String str) {
        return Hashing.murmur3_128().hashBytes(StringUtils.stringToBytes((String)str));
    }

    private static HashCode hashStringList(List<String> list) {
        Hasher hasher = Hashing.murmur3_128().newHasher();
        for (String entry : list) {
            hasher.putBytes(StringUtils.stringToBytes((String)entry));
        }
        return hasher.hash();
    }

    private static HashCode hashStringMap(Map<String, String> map) {
        Hasher hasher = Hashing.murmur3_128().newHasher();
        for (Map.Entry entry : map.entrySet().stream().sorted(Map.Entry.comparingByKey()).toList()) {
            hasher.putBytes(StringUtils.stringToBytes((String)((String)entry.getKey())));
            hasher.putBytes(StringUtils.stringToBytes((String)((String)entry.getValue())));
        }
        return hasher.hash();
    }

    public static String generateClangTidyFileContentHash(BasicTokenElementInfo basicTokenElementInfo) {
        String uniformPath = basicTokenElementInfo.getUniformPath();
        String textContent = basicTokenElementInfo.getText();
        return ClangTidyOutsourcedAnalysisHashUtils.generateClangTidyFileContentHash(uniformPath, textContent);
    }

    public static @NonNull String generateClangTidyFileContentHash(String uniformPath, String textContent) {
        return Hashing.murmur3_128().hashBytes(StringUtils.stringToBytes((String)(uniformPath + textContent))).toString();
    }

    private ClangTidyOutsourcedAnalysisHashUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

