/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.code_inspector;

import com.teamscale.index.configuration.tools.CodeInspectorConfiguration;
import com.teamscale.index.findings.IntegratedToolUpdateUtils;
import eu.cqse.check.framework.core.option.CheckMappingAndCheckOptionTSVUtils;
import eu.cqse.check.framework.core.registry.CheckMapping;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.resources.ResourceUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class CheckMappingsUpdater {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String TOOLS_FOLDER = "server/com.teamscale.index/src/main/resources/com/teamscale/index/configuration/tools/";
    private static final String CODE_INSPECTOR_MAPPINGS_TSV = "server/com.teamscale.index/src/main/resources/com/teamscale/index/configuration/tools/code-inspector/check-mappings.tsv";
    private static final Pattern CODE_INSPECTOR_MESSAGE_FILES_PATTERN = Pattern.compile(".*/code-inspector/sci_messages.*\\.csv");

    public static void main(String[] args) throws IOException, URISyntaxException {
        CheckMappingsUpdater.saveCheckMappings(new File(CODE_INSPECTOR_MAPPINGS_TSV), true);
    }

    @VisibleForTesting
    static void saveCheckMappings(File outputCheckMappingsFile, boolean printReadableNameDifferences) throws IOException, URISyntaxException {
        List<Resource> rulesResources = ResourceUtils.listResources(CodeInspectorConfiguration.class, (String)"code-inspector").stream().filter(r -> {
            String absolutePath = FileSystemUtils.normalizeSeparators((String)r.getAbsolutePath());
            return CODE_INSPECTOR_MESSAGE_FILES_PATTERN.matcher(absolutePath).matches();
        }).toList();
        if (rulesResources.isEmpty()) {
            LOGGER.error("No sci_messages*.csv files found in {}", (Object)"server/com.teamscale.index/src/main/resources/com/teamscale/index/configuration/tools/code-inspector");
            return;
        }
        Resource checkMappingsResource = Resource.of(CodeInspectorConfiguration.class, (String)"code-inspector/check-mappings.tsv");
        Map checkMappings = CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv((Resource)checkMappingsResource, (boolean)true, (boolean)true);
        for (Resource ruleResource : rulesResources) {
            try {
                CheckMappingsUpdater.parseRulesAndPutInRulesMap(ruleResource, checkMappings, printReadableNameDifferences);
            }
            catch (IOException e) {
                LOGGER.error("Could not parse sci_messages*.csv file paths. {}", (Object)e.getMessage());
            }
        }
        CheckMappingAndCheckOptionTSVUtils.writeCheckMappingsToFile((File)outputCheckMappingsFile, checkMappings.values());
    }

    private static void parseRulesAndPutInRulesMap(Resource ruleResource, Map<String, CheckMapping> checkMappings, boolean printReadableNameDifferences) throws IOException {
        String[] lines = StringUtils.splitLines((String)ruleResource.getContent());
        for (int i = 1; i < lines.length; ++i) {
            String line = lines[i];
            String[] columns = line.split(";");
            String ruleId = CheckMappingsUpdater.unquote(columns[9]);
            Object readableName = CheckMappingsUpdater.unquote(columns[10]);
            if (!((String)readableName).isBlank()) {
                readableName = (String)readableName + " ";
            }
            readableName = (String)readableName + "(" + ruleId + ")";
            readableName = ((String)readableName).replaceAll(" +", " ");
            readableName = IntegratedToolUpdateUtils.makeMarkdownUnambiguous((String)readableName);
            if (checkMappings.containsKey(ruleId)) {
                CheckMapping oldCheckMapping = checkMappings.get(ruleId);
                if (oldCheckMapping.getReadableCheckName().equals(readableName) || !printReadableNameDifferences) continue;
                System.out.println("Readable name difference for rule " + ruleId + ":\n\t" + oldCheckMapping.getReadableCheckName() + "\n\t" + (String)readableName);
                continue;
            }
            CheckMapping newCheckMapping = new CheckMapping(ruleId, (String)readableName, "TODO", "TODO", null, null, null, false);
            checkMappings.put(ruleId, newCheckMapping);
        }
    }

    private static String unquote(String s) {
        return StringUtils.stripSuffix((String)StringUtils.stripPrefix((String)s, (String)"\""), (String)"\"").replaceAll("\"\"", "\"");
    }
}

