/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.cross_file_analysis;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.index.findings.FindingsSynchronizingAnalyzingStepBase;
import com.teamscale.index.findings.cross_file_analysis.CrossFileAnalysisFindingsIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class CrossFileFindingsSynchronizer
extends FindingsSynchronizingAnalyzingStepBase {
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    protected CrossFileAnalysisFindingsIndex crossFileFindingsIndex;
    @DeltaSource(value=CrossFileAnalysisFindingsIndex.class, indexName="cross-file-analysis-findings")
    protected KeyDelta crossFileDelta;

    public void execute() throws Exception {
        if (this.crossFileDelta.isEmpty()) {
            return;
        }
        HashSet<String> deletedPaths = new HashSet<String>(this.contentDelta.getDeletedKeysAsStrings());
        SetMap<String, String> locationPathsWithChangedFindings = this.determineChangedFindingLocationsByPartitionsFromChangedKeys(this.crossFileDelta.getAddedOrChangedKeysAsBytes(), deletedPaths);
        List<CrossFileAnalysisFindingsIndex.KeyComponents> pathsCombinationsWithoutFindings = this.crossFileFindingsIndex.filterAndDecodePathToFindingForwardIndexKeys(this.crossFileDelta.getDeletedKeysAsBytes());
        HashSet<PartitionAndPath> deletedPathsAndPartitions = new HashSet<PartitionAndPath>();
        for (CrossFileAnalysisFindingsIndex.KeyComponents keyComponents : pathsCombinationsWithoutFindings) {
            if (deletedPaths.contains(keyComponents.findingLocationPath())) {
                deletedPathsAndPartitions.add(new PartitionAndPath(keyComponents.findingIndexPartition(), keyComponents.findingLocationPath()));
                continue;
            }
            locationPathsWithChangedFindings.add((Object)keyComponents.findingIndexPartition(), (Object)keyComponents.findingLocationPath());
        }
        this.findingsIndex.removeFindingsForPartitionsAndPaths(deletedPathsAndPartitions);
        Map<String, CodeScopeAware<SetMap<String, IndexFinding>>> findings = this.crossFileFindingsIndex.loadFindingsForLocationPaths(locationPathsWithChangedFindings);
        UnmodifiableSet changedPartitions = locationPathsWithChangedFindings.getKeys();
        for (String findingIndexPartition : changedPartitions) {
            CodeScopeAware<ListMap<String, IndexFinding>> findingsForPartition = CrossFileFindingsSynchronizer.convertToListMap(findings.get(findingIndexPartition));
            Set locationPathsForPartition = (Set)locationPathsWithChangedFindings.getCollectionOrElse((Object)findingIndexPartition, new HashSet());
            this.synchronizeFindings(findingsForPartition, findingIndexPartition, locationPathsForPartition);
        }
    }

    private SetMap<String, String> determineChangedFindingLocationsByPartitionsFromChangedKeys(List<byte[]> addedOrChangedKeysAsBytes, Set<String> deletedPaths) throws StorageException {
        SetMap locationPathsWithChangedFindings = new SetMap();
        List<CrossFileAnalysisFindingsIndex.KeyComponents> pathsCombinationsWithChangedFindings = this.crossFileFindingsIndex.filterAndDecodePathToFindingForwardIndexKeys(addedOrChangedKeysAsBytes);
        for (CrossFileAnalysisFindingsIndex.KeyComponents keyComponents : pathsCombinationsWithChangedFindings) {
            if (deletedPaths.contains(keyComponents.findingLocationPath())) continue;
            locationPathsWithChangedFindings.add((Object)keyComponents.findingIndexPartition(), (Object)keyComponents.findingLocationPath());
        }
        return locationPathsWithChangedFindings;
    }

    private static CodeScopeAware<ListMap<String, IndexFinding>> convertToListMap(CodeScopeAware<SetMap<String, IndexFinding>> entries) {
        if (entries == null) {
            return CodeScopeAware.empty();
        }
        PairList result = new PairList();
        for (CodeScopeName codeScopeName : entries.getCodeScopeNames()) {
            result.add((Object)codeScopeName, CrossFileFindingsSynchronizer.convertToListMap((SetMap<String, IndexFinding>)((SetMap)entries.getValue(codeScopeName))));
        }
        return CodeScopeAware.fromPairList((PairList)result);
    }

    private static ListMap<String, IndexFinding> convertToListMap(SetMap<String, IndexFinding> entries) {
        if (entries == null) {
            return new ListMap();
        }
        ListMap result = new ListMap();
        for (Map.Entry entry : entries) {
            result.addAll((Object)((String)entry.getKey()), new ArrayList((Collection)entry.getValue()));
        }
        return result;
    }
}

