/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.flake8;

import com.teamscale.index.configuration.tools.Flake8Configuration;
import com.teamscale.index.findings.flake8.Flake8Runner;
import com.teamscale.index.findings.flake8.Flake8VersionInfo;
import eu.cqse.check.framework.core.option.CheckMappingAndCheckOptionTSVUtils;
import eu.cqse.check.framework.core.registry.CheckMapping;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.error.FormatException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.SimpleNLPUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.version.Version;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NonNull;

class Flake8Updater {
    private static final Pattern RST_TABLE_ROW_SEPARATOR = Pattern.compile("\\+(([-]{3,}\\+[-]{3,})|([=]{3,}\\+[=]{3,}))\\+");
    private static final Pattern RST_TABLE_START_MARKER = Pattern.compile("\\+[-]{3,}\\+[-]{3,}\\+");
    private static final Pattern RST_TABLE_HEADER_END_MARKER = Pattern.compile("\\+[=]{3,}\\+[=]{3,}\\+");
    private static final Pattern RST_TABLE_ROW_DATA_PATTERN = Pattern.compile("\\|\\s*(.*?)\\s*\\|\\s*(.*?)\\s*\\|");
    private static final String CHECK_MAPPING_NAME = "check-mappings.tsv";
    private static final Path CONFIG_RESOURCE_DIRECTORY = Path.of("server/com.teamscale.index/src/main/resources/com/teamscale/index/configuration/tools/flake8/", new String[0]);
    private static final Path DESCRIPTION_DIRECTORY = Path.of("server/com.teamscale.index/check-descriptions/flake8", new String[0]);
    private static final Path TEMP_DIR = CONFIG_RESOURCE_DIRECTORY.resolve("temp");
    private static final String FLAKE8_RULES_URL_FOR = "https://raw.githubusercontent.com/grantmcconnaughey/Flake8Rules/master/_rules/%s.md";
    private static final List<PluginUpdater> UPDATERS = List.of(new PyflakesPluginUpdater(new Version(6, 1, 0), TEMP_DIR), new MccabePluginUpdater(new Version(6, 1, 0), TEMP_DIR), new PycodestylePluginUpdater(new Version(2, 11, 1), TEMP_DIR), new BugbearPluginUpdater(new Version(23, 11, 26), TEMP_DIR));
    private static final PrintStream OUT = System.out;
    private static final PrintStream ERR = System.out;

    Flake8Updater() {
    }

    private static OptionalInt findFirstMatchFromIndex(String input, int index, Pattern regex) {
        Matcher matcher = regex.matcher(input);
        if (matcher.find(index)) {
            return OptionalInt.of(matcher.start());
        }
        return OptionalInt.empty();
    }

    private static OptionalInt findFirstMatchFromIndexAfter(String input, int index, Pattern regex) {
        Matcher matcher = regex.matcher(input);
        if (matcher.find(index)) {
            return OptionalInt.of(matcher.end());
        }
        return OptionalInt.empty();
    }

    public static void main(String[] args) throws IOException, FormatException {
        OUT.printf("Start: using %s as target directory%n", CONFIG_RESOURCE_DIRECTORY);
        Files.createDirectories(TEMP_DIR, new FileAttribute[0]);
        OUT.printf("Using %s as temp directory%n", TEMP_DIR);
        OUT.printf("Going to update %d Flake8 plugins%n", UPDATERS.size());
        int updateCount = 0;
        for (PluginUpdater updater : UPDATERS) {
            if (updater.performUpdate()) {
                ++updateCount;
            }
            OUT.println();
        }
        OUT.printf("Updated %d plugins%n", updateCount);
        OUT.println("  -> Check the manual steps that are needed!");
        OUT.println("    + create/update check-options.tsv files. Make sure that all readable option names are globally unique by adding '(plugin-name, CheckID)'");
        OUT.println("    + check/add/update the LICENSE file in each plugin subdirectory");
        OUT.println();
        OUT.println("Checking local Flake8 version...");
        String installedVersionRaw = Flake8Runner.executeVersionInfoRaw();
        OUT.printf("Locally installed version is:   %s%n", installedVersionRaw);
        File versionFile = CONFIG_RESOURCE_DIRECTORY.resolve("version.txt").toFile();
        if (versionFile.isFile()) {
            String oldVersionRaw = FileSystemUtils.readFileUTF8((File)versionFile);
            OUT.printf("Checked-in expected version is: %s%n", oldVersionRaw);
            Flake8VersionInfo installedVersion = Flake8VersionInfo.parse(installedVersionRaw);
            Flake8VersionInfo oldVersion = Flake8VersionInfo.parse(oldVersionRaw);
            if (oldVersion.isCompatible(installedVersion)) {
                OUT.println("Note: The old checked-in version is COMPATIBLE with the one installed on the system.");
            } else {
                OUT.println("Note: The old checked-in version was IN-COMPATIBLE with the one installed on the system.");
            }
        } else {
            OUT.println("Note: No expected version was checked in!");
        }
        OUT.printf("Writing new version file: %s%n", versionFile.getPath());
        FileSystemUtils.writeFileUTF8((File)versionFile, (String)installedVersionRaw);
        OUT.println("Finished!");
    }

    private static abstract class PluginUpdater {
        private final String pluginName;
        private final Version pluginVersion;
        private final String downloadSource;
        private final Path tempWorkDir;
        private final Path pluginDestDir;
        private final Path descriptionDestDir;
        private final boolean useOnlineDescriptionFromFlake8Rules;
        private List<String> removedChecks = new ArrayList<String>();

        private PluginUpdater(String pluginName, Version pluginVersion, String downloadSource, Path tempWorkDir, Path pluginDestDir, Path descriptionDestDir, boolean useOnlineDescriptionFromFlake8Rules) {
            this.pluginName = pluginName;
            this.pluginVersion = pluginVersion;
            this.downloadSource = downloadSource;
            this.tempWorkDir = tempWorkDir;
            this.pluginDestDir = pluginDestDir;
            this.descriptionDestDir = descriptionDestDir;
            this.useOnlineDescriptionFromFlake8Rules = useOnlineDescriptionFromFlake8Rules;
        }

        private PluginUpdater(String pluginName, Version pluginVersion, String downloadSource, Path tempWorkDir, boolean useOnlineDescriptionFromFlake8Rules) {
            this(pluginName, pluginVersion, downloadSource, tempWorkDir, CONFIG_RESOURCE_DIRECTORY.resolve(pluginName), DESCRIPTION_DIRECTORY.resolve(pluginName), useOnlineDescriptionFromFlake8Rules);
        }

        private static void downloadFile(String fileUrl, Path destination) throws IOException, InterruptedException {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(fileUrl)).build();
            OUT.printf("Downloading %s to %s%n", fileUrl, destination);
            HttpResponse<Path> response = client.send(request, HttpResponse.BodyHandlers.ofFile(destination));
            if (response.statusCode() != 200) {
                throw new IOException("Could not download file, response was " + response.statusCode());
            }
        }

        private Path getVersionFilePath() {
            return this.pluginDestDir.resolve("version.txt");
        }

        private Path getCheckMappingsFilePath() {
            return this.pluginDestDir.resolve(Flake8Updater.CHECK_MAPPING_NAME);
        }

        protected Optional<Resource> getCheckMappingsResource() {
            return Resource.asOptional(Flake8Configuration.class, (String)("flake8/" + this.pluginName + "/check-mappings.tsv"));
        }

        private Optional<Version> readVersionFile() throws IOException, FormatException {
            Path versionFilePath = this.getVersionFilePath();
            if (Files.notExists(versionFilePath, new LinkOption[0])) {
                return Optional.empty();
            }
            String versionString = Files.readString(versionFilePath);
            return Optional.of(Version.parseVersion((String)versionString));
        }

        private void writeVersionFile(Version version) throws IOException {
            Path filePath = this.getVersionFilePath();
            OUT.printf("Writing new version to %s%n", filePath);
            Files.writeString(filePath, (CharSequence)version.toString(), new OpenOption[0]);
        }

        private Path getDownloadDest() {
            return this.tempWorkDir.resolve(this.pluginName + ".download");
        }

        private boolean shouldUpdate(Version oldVersion) {
            return this.pluginVersion.compareTo(oldVersion) > 0;
        }

        protected List<List<String>> cleanupTableData(List<List<String>> tableData) {
            return (List)tableData.stream().map(row -> (ArrayList)row.stream().map(s -> s.replace("``", "`")).collect(CollectionUtils.toArrayList())).collect(CollectionUtils.toArrayList());
        }

        private void processDownload() throws IOException {
            OUT.println("Processing downloaded file");
            List<List<String>> tableData = this.extractCheckTable(Files.readString(this.getDownloadDest()));
            OUT.printf("Extracted %d check table rows%n", tableData.size());
            tableData = this.cleanupTableData(tableData);
            OUT.printf("%d table rows left after cleanup%n", tableData.size());
            this.generateAndWriteCheckMappings(tableData);
            this.generateAndWriteDescriptions(tableData);
            this.deleteDescriptionsForRemovedChecks();
        }

        protected int skipToCheckTable(String fileContent) {
            return 0;
        }

        protected List<List<String>> extractCheckTable(String fileContent) {
            int index = this.skipToCheckTable(fileContent);
            index = Flake8Updater.findFirstMatchFromIndex(fileContent, index, RST_TABLE_START_MARKER).orElseThrow();
            index = Flake8Updater.findFirstMatchFromIndex(fileContent, index, RST_TABLE_HEADER_END_MARKER).orElseThrow();
            TableParser tableParser = new TableParser(fileContent, index, 2, RST_TABLE_ROW_SEPARATOR, RST_TABLE_ROW_DATA_PATTERN);
            List<List<String>> tableData = tableParser.parse();
            return this.extractCheckTablePost(fileContent, tableData);
        }

        protected List<List<String>> extractCheckTablePost(String fileContent, List<List<String>> tableData) {
            return tableData;
        }

        private Map<String, CheckMapping> loadCheckMappings() {
            Optional<Resource> resource = this.getCheckMappingsResource();
            return resource.map(r -> CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv((Resource)r, (boolean)true, (boolean)true)).orElseGet(CollectionUtils::emptyMap);
        }

        protected String postprocessReadableName(String checkId, String checkDescription) {
            return checkDescription;
        }

        private String appendPluginAndCheckId(String checkId, String checkName) {
            return checkName + " (" + this.pluginName + ", " + checkId + ")";
        }

        protected String generateDescription(String checkId, String tableCheckDescription) {
            String downloadedDescription;
            if (!this.useOnlineDescriptionFromFlake8Rules) {
                return tableCheckDescription;
            }
            Path downloadLocation = this.tempWorkDir.resolve("description-" + checkId);
            try {
                PluginUpdater.downloadFile(Flake8Updater.FLAKE8_RULES_URL_FOR.formatted(checkId), downloadLocation);
                downloadedDescription = Files.readString(downloadLocation);
            }
            catch (IOException | InterruptedException e) {
                ERR.printf("ERROR: Could not download check description from flake8rules repo for check: %s%n", checkId);
                ERR.println("  -> using description from table");
                return tableCheckDescription;
            }
            Pattern bodyContentsPattern = Pattern.compile("---\n(?<header>.+?)---\n+(?<description>.+)", 32);
            Matcher matcher = bodyContentsPattern.matcher(downloadedDescription);
            if (!matcher.find() || StringUtils.isEmpty((String)matcher.group("description"))) {
                ERR.printf("ERROR: Unexpected description format from flake8rules repo for check: %s%n", checkId);
                ERR.println("  -> using description from table");
                ERR.printf("  -> please manually check '%s' to see what is wrong%n", downloadLocation);
                return tableCheckDescription;
            }
            return matcher.group("description");
        }

        private List<CheckMapping> generateCheckMappings(List<List<String>> newChecksTable) {
            Map<String, CheckMapping> oldMappings = this.loadCheckMappings();
            Map<String, String> newChecks = newChecksTable.stream().collect(Collectors.toMap(checkRow -> PluginUpdater.expandCheckId((String)checkRow.get(0)), checkRow -> (String)checkRow.get(1)));
            ArrayList<CheckMapping> newMappings = new ArrayList<CheckMapping>();
            oldMappings.keySet().stream().filter(newChecks::containsKey).map(oldMappings::get).forEach(newMappings::add);
            OUT.printf("Reusing %d out of %d old mappings%n", newMappings.size(), oldMappings.size());
            if (oldMappings.size() != newMappings.size()) {
                this.removedChecks = CollectionUtils.differenceSet(oldMappings.keySet(), (Collection[])new Collection[]{newMappings.stream().map(e -> e.checkId).collect(Collectors.toSet())}).stream().sorted().toList();
                ERR.printf("WARNING: %d check mappings removed:%n%s", this.removedChecks.size(), this.removedChecks.stream().map(e -> "  " + e + "\n").collect(Collectors.joining()));
            }
            for (Map.Entry<String, String> entry : newChecks.entrySet()) {
                if (oldMappings.containsKey(entry.getKey())) continue;
                String readableName = this.postprocessReadableName(entry.getKey(), entry.getValue());
                CheckMapping mapping = new CheckMapping(entry.getKey(), this.appendPluginAndCheckId(PluginUpdater.unexpandCheckId(entry.getKey()), readableName), "TODO", "TODO", null);
                newMappings.add(mapping);
            }
            newMappings.sort(Comparator.comparing(e -> e.checkId));
            return newMappings;
        }

        private void generateAndWriteCheckMappings(List<List<String>> tableData) throws IOException {
            Path mappingsPath = this.getCheckMappingsFilePath();
            OUT.printf("Generating new check mappings in %s%n", mappingsPath);
            List<CheckMapping> mappings = this.generateCheckMappings(tableData);
            CheckMappingAndCheckOptionTSVUtils.writeCheckMappingsToFile((File)mappingsPath.toFile(), mappings);
        }

        private void generateAndWriteDescriptions(List<List<String>> tableData) throws IOException {
            OUT.printf("Generating descriptions in %s%n", this.descriptionDestDir);
            Files.createDirectories(this.descriptionDestDir, new FileAttribute[0]);
            for (List<String> row : tableData) {
                String checkId = row.get(0);
                String expandedCheckId = PluginUpdater.expandCheckId(checkId);
                Path descriptionPath = this.descriptionDestDir.resolve(expandedCheckId + ".md");
                if (Files.exists(descriptionPath, new LinkOption[0])) {
                    Files.move(descriptionPath, descriptionPath.resolveSibling(String.valueOf(descriptionPath.getFileName()) + ".bak"), new CopyOption[0]);
                }
                String rawDescription = this.generateDescription(checkId, row.get(1));
                Files.writeString(descriptionPath, (CharSequence)rawDescription, new OpenOption[0]);
            }
        }

        private void deleteDescriptionsForRemovedChecks() throws IOException {
            if (!CollectionUtils.isNullOrEmpty(this.removedChecks)) {
                OUT.printf("Deleting %d descriptions for removed checks in %s%n", this.removedChecks.size(), this.descriptionDestDir);
                for (String checkId : this.removedChecks) {
                    Path descriptionPath = this.descriptionDestDir.resolve(checkId + ".md");
                    Files.deleteIfExists(descriptionPath);
                }
            }
        }

        @Contract(pure=true)
        private static @NonNull String expandCheckId(@NonNull String ruleId) {
            return Flake8Configuration.addCheckIdPrefix(ruleId);
        }

        @Contract(pure=true)
        private static @NonNull String unexpandCheckId(@NonNull String ruleId) {
            return Flake8Configuration.stripCheckIdPrefix(ruleId);
        }

        private boolean performUpdate() {
            OUT.printf("Updating %s to version %s%n", this.pluginName, this.pluginVersion);
            try {
                Optional<Version> currentVersion = this.readVersionFile();
                String currentVersionStr = currentVersion.map(Version::toFullString).orElse("-UNKNOWN-");
                OUT.printf("Current version is %s%n", currentVersionStr);
                if (!currentVersion.stream().allMatch(this::shouldUpdate)) {
                    ERR.printf("Canceling update for %s. Current version is not newer: %s vs. %s%n  -> remove the corresponding version.txt file to force the update%n", this.pluginName, currentVersionStr, this.pluginVersion.toFullString());
                    return false;
                }
                PluginUpdater.downloadFile(this.downloadSource, this.getDownloadDest());
                this.processDownload();
                this.writeVersionFile(this.pluginVersion);
            }
            catch (IOException | InterruptedException | FormatException e) {
                throw new RuntimeException("Error during update attempt of " + this.pluginName, e);
            }
            OUT.printf("Finished update of %s to version %s%n", this.pluginName, this.pluginVersion);
            return true;
        }
    }

    private static class PyflakesPluginUpdater
    extends PluginUpdater {
        private static final String PLUGIN_NAME = "pyflakes";
        private static final String DOWNLOAD_URL_FOR_VERSION = "https://raw.githubusercontent.com/PyCQA/flake8/%s/docs/source/user/error-codes.rst";

        private PyflakesPluginUpdater(Version pluginVersion, Path tempWorkDir) {
            super(PLUGIN_NAME, pluginVersion, DOWNLOAD_URL_FOR_VERSION.formatted(pluginVersion.toFullString()), tempWorkDir, true);
        }
    }

    private static class MccabePluginUpdater
    extends PluginUpdater {
        private static final String PLUGIN_NAME = "mccabe";
        private static final String DOWNLOAD_URL_FOR_VERSION = "https://raw.githubusercontent.com/PyCQA/flake8/%s/docs/source/user/error-codes.rst";
        private static final Pattern MCCABE_MARKER = Pattern.compile("``mccabe`` only ever reports one :term:`violation` - ``C901``");

        private MccabePluginUpdater(Version pluginVersion, Path tempWorkDir) {
            super(PLUGIN_NAME, pluginVersion, DOWNLOAD_URL_FOR_VERSION.formatted(pluginVersion.toFullString()), tempWorkDir, true);
        }

        @Override
        protected List<List<String>> extractCheckTablePost(String fileContent, List<List<String>> tableData) {
            if (MCCABE_MARKER.matcher(fileContent).find()) {
                tableData.clear();
                tableData.add(List.of("C901", "too high McCabe complexity"));
            } else {
                ERR.println("ERROR: could not find McCabe complexity check marker\n  -> check if code must be adjusted");
            }
            return tableData;
        }
    }

    private static class PycodestylePluginUpdater
    extends PluginUpdater {
        private static final String PLUGIN_NAME = "pycodestyle";
        private static final String DOWNLOAD_URL_FOR_VERSION = "https://raw.githubusercontent.com/PyCQA/pycodestyle/%s/docs/intro.rst";
        private static final Pattern SKIP_TO_TABLE_MARKER = Pattern.compile("This is the current list of error and warning codes:");
        private static final Pattern INTABLE_FIRST_COLUMN_HEADING_PATTERN = Pattern.compile("\\*\\*(.*?)\\*\\*");
        private static final Pattern VALID_CHECK_ID_PATTERN = Pattern.compile("^[0-9A-Z]+");

        private PycodestylePluginUpdater(Version pluginVersion, Path tempWorkDir) {
            super(PLUGIN_NAME, pluginVersion, DOWNLOAD_URL_FOR_VERSION.formatted(pluginVersion.toFullString()), tempWorkDir, true);
        }

        @Override
        protected int skipToCheckTable(String fileContent) {
            return Flake8Updater.findFirstMatchFromIndex(fileContent, 0, SKIP_TO_TABLE_MARKER).orElseThrow();
        }

        @Override
        protected List<List<String>> cleanupTableData(List<List<String>> tableData) {
            tableData = super.cleanupTableData(tableData);
            List<List<String>> withoutHeaders = tableData.stream().filter(row -> !INTABLE_FIRST_COLUMN_HEADING_PATTERN.matcher((CharSequence)row.get(0)).matches()).toList();
            for (List list : withoutHeaders) {
                String checkId = (String)list.get(0);
                Matcher matcher = VALID_CHECK_ID_PATTERN.matcher(checkId);
                if (matcher.matches()) continue;
                if (matcher.find()) {
                    list.set(0, checkId.substring(0, matcher.end()));
                    continue;
                }
                ERR.printf("Invalid check ID '%s' with description '%s'%n  -> manual intervention or code changes required!%n", checkId, list.get(1));
            }
            return this.fixWeirdCheckDescriptionsInTable(withoutHeaders);
        }

        @Contract(value="_ -> param1")
        private @NonNull List<List<String>> fixWeirdCheckDescriptionsInTable(@NonNull List<List<String>> tableData) {
            for (List<String> row : tableData) {
                String checkId = row.get(0);
                if (checkId.equals("E501")) {
                    row.set(1, "line too long");
                    continue;
                }
                if (!checkId.equals("W505")) continue;
                row.set(1, "doc line too long");
            }
            return tableData;
        }
    }

    private static class BugbearPluginUpdater
    extends PluginUpdater {
        private static final String PLUGIN_NAME = "bugbear";
        private static final String DOWNLOAD_URL_FOR_VERSION = "https://raw.githubusercontent.com/PyCQA/flake8-bugbear/%s/README.rst";
        private static final Pattern LIST_OF_WARNINGS_MARKER = Pattern.compile("^List of warnings\n[-]+?\n", 8);
        private static final Pattern LIST_OF_OPINIONATED_WARNINGS_MARKER = Pattern.compile("^Opinionated warnings\n[~]+?\n", 8);
        private static final Pattern LIST_OF_OPINIONATED_WARNINGS_END_MARKER = Pattern.compile("^How to enable opinionated warnings\n[~]+?\n", 8);
        private static final Pattern CHECK_ID_PATTERN = Pattern.compile("^\\*\\*([0-9A-Z]+?)\\*\\*:", 8);
        private static final Pattern UNICODE_NEWLINE = Pattern.compile("\\R");

        private BugbearPluginUpdater(Version pluginVersion, Path tempWorkDir) {
            super(PLUGIN_NAME, pluginVersion, DOWNLOAD_URL_FOR_VERSION.formatted(pluginVersion.toFullString()), tempWorkDir, false);
        }

        @Override
        protected List<List<String>> extractCheckTable(String fileContent) {
            int warningStartIndex = Flake8Updater.findFirstMatchFromIndexAfter(fileContent, 0, LIST_OF_WARNINGS_MARKER).orElseThrow();
            int opinionStartIndexBefore = Flake8Updater.findFirstMatchFromIndex(fileContent, warningStartIndex, LIST_OF_OPINIONATED_WARNINGS_MARKER).orElseThrow();
            int opinionStartIndex = Flake8Updater.findFirstMatchFromIndexAfter(fileContent, opinionStartIndexBefore, LIST_OF_OPINIONATED_WARNINGS_MARKER).orElseThrow();
            int opinionEndIndex = Flake8Updater.findFirstMatchFromIndex(fileContent, opinionStartIndex, LIST_OF_OPINIONATED_WARNINGS_END_MARKER).orElseThrow();
            ArrayList<List<String>> dataTable = new ArrayList<List<String>>();
            BugbearPluginUpdater.parseTextTable(fileContent.substring(warningStartIndex, opinionStartIndexBefore), dataTable);
            BugbearPluginUpdater.parseTextTable(fileContent.substring(opinionStartIndex, opinionEndIndex), dataTable);
            return this.extractCheckTablePost(fileContent, dataTable);
        }

        private static void parseTextTable(String tableText, List<List<String>> dataTable) {
            String checkDesc;
            Matcher idMatcher = CHECK_ID_PATTERN.matcher(tableText);
            int index = 0;
            String checkId = null;
            while (idMatcher.find(index)) {
                if (checkId != null) {
                    checkDesc = tableText.substring(index, idMatcher.start()).trim();
                    dataTable.add(List.of(checkId, checkDesc));
                }
                checkId = idMatcher.group(1);
                index = idMatcher.end();
            }
            if (checkId != null) {
                checkDesc = tableText.substring(index).trim();
                dataTable.add(List.of(checkId, checkDesc));
            }
        }

        @Override
        protected String postprocessReadableName(String checkId, String checkDescription) {
            String cleanedText = StringUtils.replaceAll((String)checkDescription, (Pattern)UNICODE_NEWLINE, (String)" ");
            String filteredText = SimpleNLPUtils.removeIgnoredSubstrings((Pattern)Flake8Runner.BACKTICK_PATTERN, (String)cleanedText);
            Matcher matcher = Flake8Runner.END_OF_SENTENCE_PATTERN.matcher(filteredText);
            String checkName = matcher.find() ? cleanedText.substring(0, matcher.start() + 1) : cleanedText;
            return this.checkNameSpecialCases(checkId, checkName);
        }

        private @NonNull String checkNameSpecialCases(String checkId, String attemptedCheckName) {
            if (checkId.contains("B001")) {
                return attemptedCheckName.substring(0, attemptedCheckName.indexOf(", "));
            }
            if (checkId.contains("B012")) {
                return "Use of `break`, `continue` or `return` inside `finally` will silence exceptions or override return values";
            }
            if (checkId.contains("B903")) {
                return "Use `namedtuple` for data classes that only set attributes in `__init__`, and do nothing else";
            }
            if (checkId.contains("B904")) {
                return "Within an `except` clause, raise exceptions with `raise ... from err` or `raise ... from None`";
            }
            if (checkId.contains("B907")) {
                return attemptedCheckName.substring(0, attemptedCheckName.indexOf(" which is both"));
            }
            if (checkId.contains("B908")) {
                return "Contexts with exceptions assertions should not have multiple top-level statements";
            }
            if (attemptedCheckName.contains(", because")) {
                return attemptedCheckName.substring(0, attemptedCheckName.indexOf(", because"));
            }
            return attemptedCheckName;
        }
    }

    private static class TableParser {
        private final Pattern tableRowSeparator;
        private final Pattern tableRowCells;
        private final int numberOfColumns;
        private final List<String> tableLines;
        private final List<List<String>> tableRows;

        private TableParser(String textWithTable, int tableStart, int numberOfColumns, Pattern tableRowSeparator, Pattern tableRowCells) {
            this.tableRowSeparator = tableRowSeparator;
            this.tableRowCells = tableRowCells;
            this.numberOfColumns = numberOfColumns;
            this.tableLines = StringUtils.splitLinesAsList((String)textWithTable.substring(tableStart));
            this.tableRows = new ArrayList<List<String>>();
        }

        private TableMatchType matchTableRow(String line) {
            if (this.tableRowSeparator.matcher(line).matches()) {
                return TableMatchType.SEPARATOR;
            }
            Matcher cellMatcher = this.tableRowCells.matcher(line);
            if (cellMatcher.matches()) {
                if (cellMatcher.groupCount() != this.numberOfColumns) {
                    ERR.printf("ERROR: unexpected number of table cell groups: expected %d, but found %d in line '%s'%n", this.numberOfColumns, cellMatcher.groupCount(), line);
                }
                ArrayList<String> matchGroups = new ArrayList<String>(cellMatcher.groupCount());
                for (int i = 1; i <= cellMatcher.groupCount(); ++i) {
                    matchGroups.add(cellMatcher.group(i));
                }
                this.tableRows.add(matchGroups);
                return TableMatchType.ROW;
            }
            return TableMatchType.UNKNOWN;
        }

        private List<List<String>> parse() {
            TableMatchType prevType = TableMatchType.UNKNOWN;
            for (String line : this.tableLines) {
                TableMatchType type = this.matchTableRow(line);
                if (type == TableMatchType.UNKNOWN) {
                    if (prevType == TableMatchType.SEPARATOR) break;
                    ERR.println("ERROR: assumed table end may be premature; table format may be unexpected.");
                    break;
                }
                prevType = type;
            }
            OUT.printf("Found %d table rows%n", this.tableRows.size());
            return this.tableRows;
        }

        private static enum TableMatchType {
            SEPARATOR,
            ROW,
            UNKNOWN;

        }
    }
}

