/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.flake8;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.error.FormatException;
import org.conqat.lib.commons.version.Version;
import org.jspecify.annotations.NonNull;

record Flake8VersionInfo(Version flake8Version, Map<String, Version> pluginVersions, String pythonVersion) {
    private static final Pattern VERSION_OUTPUT_PATTERN = Pattern.compile("(\\S+)\\s+\\(([^)]+)\\)\\s*(.*)");
    private static final Pattern COMMA_WHITESPACE = Pattern.compile(",\\s+");
    private static final Pattern COLON_WHITESPACE = Pattern.compile(":\\s+");

    private static boolean areVersionsIncompatible(@NonNull Version currentVersion, @NonNull Version otherVersion) {
        return currentVersion.getMajor() != otherVersion.getMajor() || currentVersion.getMinor() != otherVersion.getMinor() || currentVersion.getPatch() > otherVersion.getPatch();
    }

    public boolean isCompatible(@NonNull Flake8VersionInfo other) {
        if (Flake8VersionInfo.areVersionsIncompatible(this.flake8Version, other.flake8Version)) {
            return false;
        }
        for (Map.Entry<String, Version> plugin : this.pluginVersions.entrySet()) {
            Version thisVersion = plugin.getValue();
            Version otherVersion = other.pluginVersions.get(plugin.getKey());
            if (otherVersion != null && !Flake8VersionInfo.areVersionsIncompatible(thisVersion, otherVersion)) continue;
            return false;
        }
        return true;
    }

    public static @NonNull Flake8VersionInfo parse(@NonNull String versionString) throws FormatException {
        Version flake8Version;
        HashMap<String, Version> pluginVersions = new HashMap<String, Version>();
        Matcher matcher = VERSION_OUTPUT_PATTERN.matcher(versionString);
        if (matcher.find()) {
            String[] commaSeparatedPlugins;
            flake8Version = Version.parseVersion((String)matcher.group(1));
            for (String plugin : commaSeparatedPlugins = COMMA_WHITESPACE.split(matcher.group(2))) {
                String[] pluginNameVersion = COLON_WHITESPACE.split(plugin);
                pluginVersions.put(pluginNameVersion[0], Version.parseVersion((String)pluginNameVersion[1]));
            }
        } else {
            throw new FormatException("Unexpected version string format: " + versionString);
        }
        String pythonVersion = matcher.group(3);
        return new Flake8VersionInfo(flake8Version, pluginVersions, pythonVersion);
    }
}

