/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.kubescore;

import com.teamscale.core.log.parse.ParseLogEntry;
import com.teamscale.index.findings.kubescore.KubernetesUtils;
import com.teamscale.index.resource.TokenElementIndex;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CommitDescriptor;

public abstract class KubernetesManifestBuilder {
    protected final TokenElementIndex contentIndex;
    protected final List<ParseLogEntry> parseLogEntries = new ArrayList<ParseLogEntry>();
    protected final CommitDescriptor schedulingCommit;

    protected KubernetesManifestBuilder(TokenElementIndex contentIndex, CommitDescriptor schedulingCommit) {
        this.contentIndex = contentIndex;
        this.schedulingCommit = schedulingCommit;
    }

    public abstract String build() throws ConQATException;

    protected void logManifestBuildError(Logger logger, String stdout, String error, String uniformPath) {
        if (stdout.isEmpty()) {
            this.parseLogEntries.add(KubernetesUtils.createParseLogEntry(error, uniformPath, this.schedulingCommit));
        } else {
            logger.warn(error);
        }
    }

    public List<ParseLogEntry> getParseLogEntries() {
        return this.parseLogEntries;
    }
}

