/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.kubescore;

import com.teamscale.core.log.parse.ParseLogEntry;
import com.teamscale.index.findings.kubescore.KubernetesUtils;
import com.teamscale.index.findings.kubescore.KustomizationReader;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementIndexCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.parser.ParserException;
import org.yaml.snakeyaml.scanner.ScannerException;

public class KubernetesResourceDiscriminator {
    private static final Logger LOGGER = LogManager.getLogger();
    private final TokenElementIndex contentIndex;
    private final TokenElementIndexCache contentIndexCache;
    private final List<String> allKubernetesKeys;
    private final CommitDescriptor schedulingCommit;
    private final List<ParseLogEntry> parseLogEntries = new ArrayList<ParseLogEntry>();

    public KubernetesResourceDiscriminator(TokenElementIndex contentIndex, TokenElementIndexCache contentIndexCache, CommitDescriptor schedulingCommit, List<String> allKubernetesKeys) {
        this.contentIndex = contentIndex;
        this.contentIndexCache = contentIndexCache;
        this.schedulingCommit = schedulingCommit;
        this.allKubernetesKeys = allKubernetesKeys;
    }

    public @NonNull Map<String, Set<String>> getRootKustomizationsWithAffectedFiles() throws StorageException {
        List allKustomizeKeys = CollectionUtils.filter(this.allKubernetesKeys, KubernetesUtils::isKustomization);
        HashMap<String, Set<String>> rootKustomizationsWithAffectedFiles = new HashMap<String, Set<String>>();
        HashSet<String> filesIncludedInOtherKustomzations = new HashSet<String>();
        for (String kustomization : allKustomizeKeys) {
            if (filesIncludedInOtherKustomzations.contains(kustomization)) continue;
            Set<String> affectedFiles = this.getFilesAffectedByKustomization(kustomization, new HashSet<String>());
            affectedFiles.remove(kustomization);
            filesIncludedInOtherKustomzations.addAll(affectedFiles);
            affectedFiles.forEach(rootKustomizationsWithAffectedFiles::remove);
            rootKustomizationsWithAffectedFiles.put(kustomization, affectedFiles);
        }
        return rootKustomizationsWithAffectedFiles;
    }

    public @NonNull Set<String> getRootHelmCharts() throws StorageException {
        List allHelmChartKeys = CollectionUtils.filter(this.allKubernetesKeys, KubernetesUtils::isHelmChart);
        HashSet<String> rootHelmCharts = new HashSet<String>();
        for (String key : allHelmChartKeys) {
            String rootHelmChart = this.findRootHelmChart(key);
            if (rootHelmChart == null) continue;
            rootHelmCharts.add(rootHelmChart);
        }
        return rootHelmCharts;
    }

    public @NonNull Set<String> getStaticManifests(Map<String, Set<String>> rootKustomizationsWithAffectedFiles, Set<String> rootHelmCharts) {
        Set<String> staticManifests = new HashSet<String>(this.allKubernetesKeys);
        for (String string : rootHelmCharts) {
            staticManifests = CollectionUtils.filterToSet(staticManifests, file -> !file.startsWith(UniformPathUtils.getParentPath((String)rootHelmChart)));
        }
        for (Map.Entry entry : rootKustomizationsWithAffectedFiles.entrySet()) {
            staticManifests.remove(entry.getKey());
            staticManifests.removeAll((Collection)entry.getValue());
        }
        return staticManifests;
    }

    private @Nullable String findRootHelmChart(String originalPath) throws StorageException {
        ArrayList<String> candidates = new ArrayList<String>();
        String parent = UniformPathUtils.getParentPath((String)originalPath);
        while (!parent.isEmpty()) {
            candidates.add(UniformPathUtils.concatenate((String[])new String[]{parent, "Chart.yaml"}));
            candidates.add(UniformPathUtils.concatenate((String[])new String[]{parent, "Chart.yml"}));
            parent = UniformPathUtils.getParentPath((String)parent);
        }
        candidates.add("Chart.yaml");
        candidates.add("Chart.yml");
        Set<String> allCharts = this.contentIndex.getContainedUniformPaths(candidates);
        if (allCharts.isEmpty()) {
            LOGGER.error("Did not find any chart candidates for {}.", (Object)originalPath);
            return null;
        }
        return allCharts.stream().min(Comparator.comparingInt(String::length)).get();
    }

    private Set<String> getFilesAffectedByKustomization(String kustomizationUniformPath, Set<String> visited) throws StorageException {
        if (visited.contains(kustomizationUniformPath)) {
            return Collections.emptySet();
        }
        visited.add(kustomizationUniformPath);
        String kustomizationContent = KubernetesUtils.getContentForUniformPath(kustomizationUniformPath, this.contentIndexCache);
        try {
            Map parsedYaml = (Map)new Yaml().load(kustomizationContent);
            Set<String> sources = KustomizationReader.getFilesForKustomization(kustomizationUniformPath, parsedYaml);
            Set<String> directories = KubernetesResourceDiscriminator.getDirectories(sources);
            sources.removeAll(directories);
            for (String directory : directories) {
                String kustomization = directory + "/kustomization.yaml";
                if (this.contentIndex.getTokenElement(kustomization) != null) {
                    sources.addAll(this.getFilesAffectedByKustomization(kustomization, visited));
                    continue;
                }
                LOGGER.warn("Interpreted as directory, but no kustomization.yaml found: {}", (Object)directory);
            }
            sources.add(kustomizationUniformPath);
            return sources;
        }
        catch (ParserException | ScannerException e) {
            this.parseLogEntries.add(KubernetesUtils.createParseLogEntry(e.getMessage(), kustomizationUniformPath, this.schedulingCommit));
            return Collections.emptySet();
        }
        catch (StorageException e) {
            LOGGER.error((Object)e);
            return Collections.emptySet();
        }
    }

    private static Set<String> getDirectories(Set<String> sources) {
        return sources.stream().filter(source -> UniformPathUtils.getExtension((String)source) == null).collect(Collectors.toSet());
    }

    public List<ParseLogEntry> getParseLogEntries() {
        return this.parseLogEntries;
    }
}

