/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.kubescore;

import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.core.log.parse.EParseLogOrigin;
import com.teamscale.core.log.parse.ParseLogEntry;
import com.teamscale.core.utils.YamlUtils;
import com.teamscale.index.findings.kubescore.entitites.KubernetesEntity;
import com.teamscale.index.resource.TokenElementIndexCache;
import com.teamscale.index.resource.TokenElementInfo;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.io.ProcessUtils;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.Nullable;

public final class KubernetesUtils {
    private static final Pattern LINE_NUMBER_PATTERN = Pattern.compile("(?i)line\\s+(\\d+)");

    static List<Map<String, Object>> convertToListMap(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            return list.stream().filter(Objects::nonNull).map(KubernetesUtils::convertToMap).toList();
        }
        throw new IllegalArgumentException("Object could not be cast to list map.");
    }

    static List<String> convertToStringList(Object object) throws IllegalArgumentException {
        if (object instanceof List) {
            List list = (List)object;
            return list.stream().filter(Objects::nonNull).map(listElement -> (String)listElement).toList();
        }
        throw new IllegalArgumentException("Object could not be cast to string list.");
    }

    static Map<String, Object> convertToMap(Object object) throws IllegalArgumentException {
        if (object instanceof Map) {
            Map map = (Map)object;
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Map.Entry mapEntry : map.entrySet()) {
                result.put((String)mapEntry.getKey(), mapEntry.getValue());
            }
            return result;
        }
        throw new IllegalArgumentException("Object could not be cast to string map.");
    }

    public static @Nullable KubernetesEntity readEntityContent(String uniformPath, String entityContent) {
        return (KubernetesEntity)YamlUtils.readFileContent((String)uniformPath, (String)entityContent, KubernetesEntity.class);
    }

    public static String loadConfiguredKustomizeExe() {
        return (String)TeamscaleSystemProperties.KUSTOMIZE_EXE_PATH.getValue();
    }

    public static String loadConfiguredHelmExe() {
        return (String)TeamscaleSystemProperties.HELM_EXE_PATH.getValue();
    }

    public static ParseLogEntry createParseLogEntry(String errorMessage, String uniformPath, CommitDescriptor schedulingCommit) {
        Matcher matcher = LINE_NUMBER_PATTERN.matcher(errorMessage);
        int lineNumber = 0;
        if (matcher.find()) {
            lineNumber = Integer.parseInt(matcher.group(1));
        }
        return new ParseLogEntry(EParseLogOrigin.KUBE_SCORE, errorMessage, uniformPath, schedulingCommit, lineNumber);
    }

    public static String getContentForUniformPath(String uniformPath, TokenElementIndexCache contentIndexCache) throws StorageException {
        TokenElementInfo value = contentIndexCache.getTokenElementInfo(UniformPathCompatibilityUtil.convert((String)uniformPath));
        CCSMAssert.isNotNull((Object)((Object)value), (String)("No token element found for uniform path" + uniformPath));
        return value.getText();
    }

    public static ProcessUtils.ExecutionResult executeKubernetesProcess(List<String> commands) throws IOException {
        return KubernetesUtils.executeKubernetesProcess(commands, null);
    }

    public static ProcessUtils.ExecutionResult executeKubernetesProcess(List<String> commands, String input) throws IOException {
        return ProcessUtils.execute((ProcessBuilder)new ProcessBuilder(commands), (String)input, (long)600L);
    }

    public static boolean isHelmChart(String uniformPath) {
        return KubernetesUtils.isExpectedResourceType(uniformPath, "Chart");
    }

    public static boolean isKustomization(String uniformPath) {
        return KubernetesUtils.isExpectedResourceType(uniformPath, "kustomization");
    }

    private static boolean isExpectedResourceType(String uniformPath, String expectedFileNameWithoutExtension) {
        return FileSystemUtils.getFilenameWithoutExtension((String)UniformPathUtils.getElementName((String)uniformPath)).equals(expectedFileNameWithoutExtension);
    }

    private KubernetesUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

