/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.pylint;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.index.configuration.tools.Rule;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.io.ProcessUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

public class PylintChecksExtractor {
    private static final Pattern UNESCAPED_INIT_LIKE_METHOD_PATTERN = Pattern.compile("(?<!`)(__[a-zA-Z]+__)(?<!`)");
    private static final Pattern UNESCAPED_METHOD_WITH_PARENTHESIS_PATTERN = Pattern.compile("(?<!`)([a-zA-Z._]+\\(\\))(?<!`)");
    private static final Pattern UNFORMATTED_URL_PATTERN = Pattern.compile("(?<!<)(http[^ ]+)(?<!>)");
    private static final Pattern ILLEGAL_CHECK_NAME_CHARACTERS_PATTERN = Pattern.compile("[^A-Za-z0-9() -]");
    private static final String PYLINT_MD_DESCRIPTION_FOLDER = "server/com.teamscale.index/check-descriptions/pylint";
    private static final File PYLINT_CHECK_MAPPINGS = new File("server/com.teamscale.index/src/main/resources/com/teamscale/index/configuration/tools/pylint/check-mappings.tsv");

    public static void main(String ... arguments) throws IOException, ProjectConfigurationException {
        List<Rule> allChecksFromPylint = PylintChecksExtractor.getAvailablePylintChecks();
        Set<String> allChecksFromTeamscale = PylintChecksExtractor.getMappedPylintChecks();
        PylintChecksExtractor.updateMarkdowns(allChecksFromPylint);
        PylintChecksExtractor.updateCheckMappings(allChecksFromPylint, allChecksFromTeamscale);
    }

    private static void updateMarkdowns(List<Rule> allChecksFromPylint) throws IOException {
        for (Rule rule : allChecksFromPylint) {
            Path descriptionFile = Paths.get(PYLINT_MD_DESCRIPTION_FOLDER, rule.id + ".md");
            FileSystemUtils.writeFileUTF8((Path)descriptionFile, (String)rule.description);
        }
    }

    private static void updateCheckMappings(List<Rule> allChecksFromPylint, Set<String> allChecksFromTeamscale) throws IOException {
        List missingCheckMappings = CollectionUtils.filterAndMap(allChecksFromPylint, pylintCheck -> !allChecksFromTeamscale.contains(pylintCheck.id), pylintCheck -> pylintCheck.id);
        List checkMappings = FileSystemUtils.readLinesUTF8((File)PYLINT_CHECK_MAPPINGS);
        checkMappings.addAll(CollectionUtils.map((Collection)missingCheckMappings, name -> name + "\t\tTODO\tTODO\tIGNORED"));
        FileSystemUtils.writeLines((File)PYLINT_CHECK_MAPPINGS, (Collection)checkMappings, (Charset)StandardCharsets.UTF_8);
    }

    private static @NonNull List<Rule> getAvailablePylintChecks() throws IOException {
        String[] potentialChecks;
        ArrayList<Rule> checks = new ArrayList<Rule>();
        List<String> command = List.of("pylint", "--list-msgs", "--enable-all-extensions", "--enable=all");
        ProcessBuilder builder = new ProcessBuilder(command);
        ProcessUtils.ExecutionResult result = ProcessUtils.execute((ProcessBuilder)builder);
        String stdOut = result.getStdout();
        for (String potentialCheck : potentialChecks = stdOut.split("\\n[:\n]")) {
            String[] lines = potentialCheck.split("\n");
            Optional<String> checkName = PylintChecksExtractor.extractCheckName(lines);
            if (checkName.isEmpty()) continue;
            String checkDescription = PylintChecksExtractor.extractCheckDescription(lines);
            Rule rule = new Rule();
            rule.id = checkName.get();
            rule.description = checkDescription;
            checks.add(rule);
        }
        return checks;
    }

    private static Set<String> getMappedPylintChecks() throws IOException {
        HashSet<String> mappedPylintChecks = new HashSet<String>();
        List checkMappings = FileSystemUtils.readLinesUTF8((File)PYLINT_CHECK_MAPPINGS);
        for (String line : checkMappings) {
            String[] checkData = line.split("\t");
            mappedPylintChecks.add(checkData[0]);
        }
        return mappedPylintChecks;
    }

    private static Optional<String> extractCheckName(String[] lines) {
        if (lines[0].indexOf(40) < 0) {
            return Optional.empty();
        }
        String[] firstLineParts = StringUtils.splitByWholeSeparator((String)lines[0], (String)": ");
        ArrayList<String> checkNameParts = new ArrayList<String>();
        for (String part : StringUtils.splitByWholeSeparator((String)firstLineParts[0], (String)"-")) {
            checkNameParts.add(StringUtils.capitalize((String)StringUtils.replaceAll((String)part, (Pattern)ILLEGAL_CHECK_NAME_CHARACTERS_PATTERN, (String)"")));
        }
        return Optional.of(String.join((CharSequence)" ", checkNameParts));
    }

    private static String extractCheckDescription(String[] lines) {
        ArrayList<String> descriptionParts = new ArrayList<String>();
        for (int i = 1; i < lines.length; ++i) {
            descriptionParts.add(PylintChecksExtractor.addMarkdownMarkings(lines[i].trim()));
        }
        return String.join((CharSequence)"\n", descriptionParts);
    }

    private static String addMarkdownMarkings(String line) {
        return StringUtils.replaceAll((String)line, (PairList)PairList.fromPairs((Pair)new Pair((Object)UNESCAPED_INIT_LIKE_METHOD_PATTERN, (Object)"`$1`"), (Pair[])new Pair[]{new Pair((Object)UNESCAPED_METHOD_WITH_PARENTHESIS_PATTERN, (Object)"`$1`"), new Pair((Object)UNFORMATTED_URL_PATTERN, (Object)"<$1>")}));
    }
}

