/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.semgrep;

import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.index.configuration.tools.SemgrepConfiguration;
import com.teamscale.index.findings.CppFileUtils;
import com.teamscale.index.findings.FindingsSynchronizingAnalyzingStepBase;
import com.teamscale.index.findings.IntegratedToolUtils;
import com.teamscale.index.findings.semgrep.SemgrepOutputParser;
import com.teamscale.index.findings.semgrep.SemgrepRuleFileLoader;
import com.teamscale.index.findings.semgrep.SemgrepWslUtils;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.TemporaryDirectory;
import org.conqat.lib.commons.io.ProcessUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

public class SemgrepAnalysisStep
extends FindingsSynchronizingAnalyzingStepBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String FINDING_PARTITION = "semgrep";
    public static final String EXPECTED_SEMGREP_VERSION = "1.92.0";
    private static final String EXECUTABLE_NAME = "semgrep";
    private static final String TEMP_HOME_DIRECTORY_PREFIX = "semgrep-home";
    public static final String CHECKS_PARAMETER = "checks";
    @StepParameter(value="checks")
    private final CodeScopeAware<List<String>> selectedChecks = CodeScopeAware.defaultCodeScopeWithValue(new ArrayList());

    public static void verifySemgrepVersion() throws ConQATException {
        Pair<Integer, String> actualVersion;
        try {
            actualVersion = SemgrepAnalysisStep.invokeSemgrepVersion();
        }
        catch (IOException e) {
            throw new ConQATException("Could not invoke semgrep version check. Is the required version (%s) correctly installed? Error: %s".formatted(EXPECTED_SEMGREP_VERSION, e.getMessage()), (Throwable)e);
        }
        if (actualVersion.getSecond() == null || !((String)actualVersion.getSecond()).contains(EXPECTED_SEMGREP_VERSION)) {
            throw new ConQATException("No semgrep or wrong version. Required version: 1.92.0 Return Code: " + String.valueOf(actualVersion.getFirst()) + " Output: " + (String)actualVersion.getSecond());
        }
    }

    private static @NonNull Pair<Integer, String> invokeSemgrepVersion() throws IOException {
        ProcessUtils.ExecutionResult result;
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        List<String> command = processBuilder.command();
        if (SemgrepWslUtils.isWindows()) {
            command.add("wsl");
            command.addAll(SemgrepWslUtils.WSL_EXECUTABLE_ARGS);
            command.add(SemgrepWslUtils.WSL_SEMGREP_EXECUTABLE);
        } else {
            command.add("semgrep");
        }
        command.add("--version");
        command.add("--disable-version-check");
        processBuilder.redirectErrorStream(true);
        if (SemgrepWslUtils.isWindows()) {
            result = ProcessUtils.execute((ProcessBuilder)processBuilder, null, (Duration)Duration.ofMinutes(1L));
        } else {
            try (TemporaryDirectory tempHomeDir = SemgrepAnalysisStep.getTempDirectory((String)TEMP_HOME_DIRECTORY_PREFIX);){
                processBuilder.environment().put("XDG_CONFIG_HOME", tempHomeDir.getPath().toString());
                result = ProcessUtils.execute((ProcessBuilder)processBuilder, null, (Duration)Duration.ofSeconds(30L));
            }
        }
        return Pair.createPair((Object)result.getReturnCode(), (Object)result.getStdout());
    }

    public void execute() throws Exception {
        List<TokenElementInfo> tokenElements = this.getAddedOrChangedTokenElements((Set<ELanguage>)EAnalysisTool.SEMGREP.getSupportedLanguages());
        CodeScopeAware<Set<ELanguage>> languagesPerCodeScope = SemgrepAnalysisStep.compileLanguagesPerCodeScope(tokenElements);
        CodeScopeAware<String> ruleSetPerCodeScope = SemgrepAnalysisStep.compileRulesPerCodeScope(this.selectedChecks, languagesPerCodeScope);
        Map<String, TokenElementInfo> elementsByUniformPath = tokenElements.stream().collect(Collectors.toMap(BasicTokenElementInfo::getUniformPath, Function.identity()));
        HashMap tokenElementsByRuleSet = new HashMap();
        for (TokenElementInfo element : tokenElements) {
            CodeScopeName codeScope = CodeScopeDetail.getCodeScopeNameFromTokenElement(element);
            String ruleSet = (String)ruleSetPerCodeScope.getValueOrNull(codeScope);
            if (ruleSet == null) continue;
            tokenElementsByRuleSet.putIfAbsent(ruleSet, new ArrayList());
            ((List)tokenElementsByRuleSet.get(ruleSet)).add(element);
        }
        Set<String> checkIdsWithDot = this.selectedChecks.getValues().stream().flatMap(Collection::stream).filter(c -> c.contains(".")).collect(Collectors.toSet());
        ListMap findingsPerElement = new ListMap();
        try (TemporaryDirectory tempDirectory = SemgrepAnalysisStep.getTempDirectory((String)"semgrep");){
            int ruleSetCounter = 0;
            for (Map.Entry entry : tokenElementsByRuleSet.entrySet()) {
                String ruleSetId = "ruleSet" + ruleSetCounter++;
                File ruleSetSourceFilesDir = new File(tempDirectory.getPath().toFile(), ruleSetId);
                SemgrepAnalysisStep.saveFiles((List)entry.getValue(), ruleSetSourceFilesDir);
                SemgrepAnalysisStep.saveRuleSetFile((String)entry.getKey(), ruleSetId, ruleSetSourceFilesDir);
                SemgrepAnalysisStep.saveSemgrepIgnoreFile(ruleSetSourceFilesDir);
                ProcessUtils.ExecutionResult result = SemgrepAnalysisStep.executeSemgrep(ruleSetId + ".yml", ruleSetSourceFilesDir);
                SemgrepAnalysisStep.parseSemgrepOutput(result, ruleSetSourceFilesDir, (ListMap<String, IndexFinding>)findingsPerElement, elementsByUniformPath, checkIdsWithDot);
            }
            CodeScopeAware<ListMap<String, IndexFinding>> findingsPerCodeScope = IntegratedToolUtils.splitFindingsByCodeScope(tokenElements, (ListMap<String, IndexFinding>)findingsPerElement);
            this.synchronizeFindingsForTokenElementIndexDelta(findingsPerCodeScope, "semgrep");
        }
    }

    private static CodeScopeAware<Set<ELanguage>> compileLanguagesPerCodeScope(List<TokenElementInfo> elementInfos) {
        CodeScopeAware languagesPerCodeScope = CodeScopeAware.empty();
        for (BasicTokenElementInfo basicTokenElementInfo : elementInfos) {
            CodeScopeName codeScopeName = CodeScopeDetail.getCodeScopeNameFromTokenElement(basicTokenElementInfo);
            ELanguage language = basicTokenElementInfo.getLanguage();
            if (!languagesPerCodeScope.contains(codeScopeName)) {
                languagesPerCodeScope.setValue(codeScopeName, new HashSet());
            }
            ((Set)languagesPerCodeScope.getValue(codeScopeName)).add(language);
        }
        return languagesPerCodeScope;
    }

    private static void saveRuleSetFile(String ruleSet, String ruleSetId, File ruleSetSourceFilesDir) throws IOException {
        File targetFile = new File(ruleSetSourceFilesDir, ruleSetId + ".yml");
        FileSystemUtils.writeFileUTF8((Path)targetFile.toPath(), (String)ruleSet);
    }

    private static void saveSemgrepIgnoreFile(File ruleSetSourceFilesDir) throws IOException {
        FileSystemUtils.writeFileUTF8((Path)new File(ruleSetSourceFilesDir, ".semgrepignore").toPath(), (String)"");
    }

    private static CodeScopeAware<String> compileRulesPerCodeScope(CodeScopeAware<List<String>> selectedChecks, CodeScopeAware<Set<ELanguage>> languagesPerCodeScope) {
        PairList ruleSetPerCodeScope = new PairList();
        for (Map.Entry entry : languagesPerCodeScope) {
            CodeScopeName codeScopeName = (CodeScopeName)entry.getKey();
            Set languagesOfAnalyzedFiles = (Set)entry.getValue();
            List checksInCodeScope = (List)selectedChecks.getValue(codeScopeName);
            Optional<String> ruleSet = SemgrepAnalysisStep.buildRuleSetForSelectedChecksAndLanguages(checksInCodeScope, languagesOfAnalyzedFiles);
            ruleSet.ifPresent(r -> ruleSetPerCodeScope.add((Object)codeScopeName, r));
        }
        return CodeScopeAware.fromPairList((PairList)ruleSetPerCodeScope);
    }

    private static Optional<String> buildRuleSetForSelectedChecksAndLanguages(List<String> checksInCodeScope, Set<ELanguage> languagesOfAnalyzedFiles) {
        ArrayList<StringBuilder> collectedRules = new ArrayList<StringBuilder>();
        for (String checkId : checksInCodeScope) {
            Optional<Path> ruleFileResource;
            Set<ELanguage> languagesOfCheck = SemgrepConfiguration.determineLanguagesFromGitlabSastRuleId(checkId);
            HashSet overlappingLanguages = CollectionUtils.intersectionSet(languagesOfCheck, (Collection[])new Collection[]{languagesOfAnalyzedFiles});
            if (overlappingLanguages.isEmpty() || (ruleFileResource = SemgrepRuleFileLoader.getRuleFilePath(checkId)).isEmpty()) continue;
            try {
                List ruleFileLines = FileSystemUtils.readLinesUTF8((Path)ruleFileResource.get());
                collectedRules.add(SemgrepAnalysisStep.extractRule(ruleFileLines));
            }
            catch (IOException e) {
                LOGGER.error("Could not read rule file for {}", (Object)checkId, (Object)e);
            }
        }
        if (collectedRules.isEmpty()) {
            return Optional.empty();
        }
        StringBuilder ruleSet = new StringBuilder("rules:\n");
        for (StringBuilder rule : collectedRules) {
            ruleSet.append((CharSequence)rule);
        }
        return Optional.of(ruleSet.toString());
    }

    private static StringBuilder extractRule(List<String> ruleFileLines) {
        StringBuilder rule = new StringBuilder();
        boolean skippedHeaderLine = false;
        boolean unindentRule = false;
        for (String ruleFileLine : ruleFileLines) {
            if ("rules:".equals(ruleFileLine)) {
                skippedHeaderLine = true;
                continue;
            }
            if (!skippedHeaderLine) continue;
            if (ruleFileLine.startsWith("  - id")) {
                unindentRule = true;
            }
            if (unindentRule) {
                rule.append(StringUtils.stripPrefix((String)ruleFileLine, (String)"  ")).append("\n");
                continue;
            }
            rule.append(ruleFileLine).append("\n");
        }
        return rule;
    }

    private static void parseSemgrepOutput(ProcessUtils.ExecutionResult processOutput, File ruleSetSourceFilesDir, ListMap<String, IndexFinding> findingsPerElement, Map<String, TokenElementInfo> elementsByUniformPath, Set<String> checkIdsWithDot) {
        switch (processOutput.getReturnCode()) {
            case 0: {
                return;
            }
            case 1: {
                break;
            }
            default: {
                LOGGER.error("Semgrep execution failed. Error output: {}", (Object)processOutput.getStderr());
                return;
            }
        }
        findingsPerElement.addAll(new SemgrepOutputParser(elementsByUniformPath, checkIdsWithDot).parseOutput(processOutput.getStdout(), ruleSetSourceFilesDir));
    }

    private static void saveFiles(List<TokenElementInfo> tokenElementInfos, File codeDirectory) throws IOException {
        for (TokenElementInfo tokenElementInfo : tokenElementInfos) {
            CppFileUtils.saveFile(tokenElementInfo.getUniformPath(), tokenElementInfo.getText(), codeDirectory);
        }
    }

    private static ProcessUtils.ExecutionResult executeSemgrep(String ruleSetFileName, File executionDirectory) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        if (SemgrepWslUtils.isWindows()) {
            command.add("wsl");
            command.addAll(SemgrepWslUtils.WSL_EXECUTABLE_ARGS);
            command.add(SemgrepWslUtils.WSL_SEMGREP_EXECUTABLE);
        } else {
            command.add("semgrep");
        }
        command.add("scan");
        command.add("--metrics");
        command.add("off");
        command.add("--disable-version-check");
        command.add("--jobs");
        command.add("1");
        if (EFeatureToggle.ENABLE_SEMGREP_EXPERIMENTAl_MODE.isEnabled()) {
            command.add("--experimental");
        }
        command.add("--no-git-ignore");
        command.add("--json");
        command.add("--error");
        command.add("--config");
        command.add(ruleSetFileName);
        if (SemgrepWslUtils.isWindows()) {
            command.add(SemgrepWslUtils.convertWindowsToWslPath(executionDirectory.getAbsolutePath()));
            ProcessBuilder processBuilder = new ProcessBuilder(command).directory(executionDirectory);
            return ProcessUtils.execute((ProcessBuilder)processBuilder);
        }
        command.add(executionDirectory.getAbsolutePath());
        try (TemporaryDirectory tempHomeDir = SemgrepAnalysisStep.getTempDirectory((String)TEMP_HOME_DIRECTORY_PREFIX);){
            ProcessBuilder processBuilder = new ProcessBuilder(command).directory(executionDirectory);
            processBuilder.environment().put("XDG_CONFIG_HOME", tempHomeDir.getPath().toString());
            ProcessUtils.ExecutionResult executionResult = ProcessUtils.execute((ProcessBuilder)processBuilder);
            return executionResult;
        }
    }
}

