/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.sonarlint;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.index.configuration.tools.NodeJsLinterUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.util.NativeLibUtil;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.version.Version;
import org.jspecify.annotations.Nullable;
import org.sonarsource.sonarlint.core.StandaloneSonarLintEngineImpl;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneGlobalConfiguration;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneSonarLintEngine;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.log.ClientLogOutput;

public class SonarLintEnginePool {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String TEMP_DIR_NAME = "sonarlint";
    private static ObjectPool<StandaloneSonarLintEngine> enginePool;
    public static final Version REQUIRED_MIN_NODE_JS_VERSION_FOR_JS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StandaloneSonarLintEngine createEngine() throws ConQATException, IOException {
        Class<SonarLintEnginePool> clazz = SonarLintEnginePool.class;
        synchronized (SonarLintEnginePool.class) {
            if (enginePool == null) {
                enginePool = new GenericObjectPool((PooledObjectFactory)new SonarLintEngineFactory(FileSystemUtils.getTemporaryDirectoryDeletedOnShutdown((String)TEMP_DIR_NAME).getPath().toFile()));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            try {
                return (StandaloneSonarLintEngine)enginePool.borrowObject();
            }
            catch (Exception e) {
                throw new ConQATException((Throwable)e);
            }
        }
    }

    public static void returnEngine(@Nullable StandaloneSonarLintEngine engine) {
        if (engine == null) {
            return;
        }
        try {
            enginePool.returnObject((Object)engine);
        }
        catch (Exception e) {
            LOGGER.error("Error returning engine: {}", (Object)e, (Object)e);
        }
    }

    public static ClientLogOutput createSonarMessageLogger(Logger logger) {
        return (formattedMessage, level) -> SonarLintEnginePool.logSonarLintMessage(logger, formattedMessage, level);
    }

    private static void logSonarLintMessage(Logger logger, String message, ClientLogOutput.Level level) {
        if (SonarLintEnginePool.isSuppressedSonarLintWarning(message)) {
            LOGGER.info(message);
            return;
        }
        switch (level) {
            case ERROR: {
                logger.error(message);
                break;
            }
            case WARN: {
                logger.warn(message);
                break;
            }
            case INFO: {
                logger.info(message);
                break;
            }
            case DEBUG: {
                logger.debug(message);
                break;
            }
            case TRACE: {
                logger.trace(message);
                break;
            }
            default: {
                logger.warn("Logged at unknown log level: {}", (Object)message);
            }
        }
    }

    private static boolean isSuppressedSonarLintWarning(String message) {
        return message.equals("No workDir in SonarLint") || message.startsWith("Unresolved imports/types") || message.startsWith("Use of preview features");
    }

    static {
        REQUIRED_MIN_NODE_JS_VERSION_FOR_JS = new Version(14, 17);
    }

    private static class SonarLintEngineFactory
    extends BasePooledObjectFactory<StandaloneSonarLintEngine> {
        private int counter = 0;
        private final File baseDirectory;
        private final Object lockObject = new Object();

        private SonarLintEngineFactory(File baseDirectory) {
            this.baseDirectory = baseDirectory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StandaloneSonarLintEngine create() throws Exception {
            File workDir;
            Object object = this.lockObject;
            synchronized (object) {
                ++this.counter;
                workDir = new File(this.baseDirectory, "sonar" + this.counter);
            }
            FileSystemUtils.deleteRecursively((Path)workDir.toPath());
            FileSystemUtils.ensureDirectoryExists((Path)workDir.toPath());
            StandaloneGlobalConfiguration.Builder builder = (StandaloneGlobalConfiguration.Builder)((StandaloneGlobalConfiguration.Builder)StandaloneGlobalConfiguration.builder().setSonarLintUserHome(workDir.toPath())).setLogOutput(SonarLintEnginePool.createSonarMessageLogger(LOGGER));
            File libsDirectory = NativeLibUtil.getNativeLib((String)"sonar");
            for (File lib : FileSystemUtils.listFilesRecursively((File)libsDirectory)) {
                builder.addPlugin(Paths.get(lib.getAbsolutePath(), new String[0]));
            }
            builder.addEnabledLanguage(Language.JAVA);
            builder.addEnabledLanguage(Language.PHP);
            builder.addEnabledLanguage(Language.KOTLIN);
            try {
                NodeJsLinterUtils.NodeJsInfo nodeJsInfo = NodeJsLinterUtils.getNodeJSFromSystem();
                if (nodeJsInfo.version().isGreaterOrEqual(REQUIRED_MIN_NODE_JS_VERSION_FOR_JS)) {
                    builder.setNodeJs(nodeJsInfo.nodeJsPath(), org.sonarsource.sonarlint.core.commons.Version.create((String)nodeJsInfo.version().toString()));
                    builder.addEnabledLanguage(Language.JS);
                    builder.addEnabledLanguage(Language.TS);
                }
            }
            catch (ProjectConfigurationException projectConfigurationException) {
                // empty catch block
            }
            return new StandaloneSonarLintEngineImpl(builder.build());
        }

        public PooledObject<StandaloneSonarLintEngine> wrap(StandaloneSonarLintEngine engine) {
            return new DefaultPooledObject((Object)engine);
        }
    }
}

