/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.sonarlint;

import com.google.common.base.Charsets;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.element_details.PartOfTestCodeDetail;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import org.conqat.lib.commons.string.StringUtils;
import org.sonarsource.sonarlint.core.analysis.api.ClientInputFile;

public class SonarLintInputFile
implements ClientInputFile {
    private final TokenElementInfo element;

    public SonarLintInputFile(TokenElementInfo element) {
        this.element = element;
    }

    public String getPath() {
        return this.element.getUniformPath();
    }

    public boolean isTest() {
        return this.element.getFirstDetailOfType(PartOfTestCodeDetail.class).isPresent();
    }

    public Charset getCharset() {
        return Charsets.UTF_8;
    }

    public <G> G getClientObject() {
        return null;
    }

    public InputStream inputStream() {
        return new ByteArrayInputStream(StringUtils.stringToBytes((String)this.element.getText()));
    }

    public String contents() {
        return this.element.getText();
    }

    public String relativePath() {
        return this.element.getUniformPath();
    }

    public URI uri() {
        return Paths.get(this.element.getUniformPath(), new String[0]).toUri();
    }
}

