/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.swiftlint;

import com.teamscale.index.findings.swiftlint.SwiftLintRunner;
import eu.cqse.check.framework.core.option.CheckMappingAndCheckOptionTSVUtils;
import eu.cqse.check.framework.core.option.EToolCheckOptionType;
import eu.cqse.check.framework.core.option.ToolCheckOption;
import eu.cqse.check.framework.core.registry.CheckMapping;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.sonar.api.internal.apachecommons.lang.math.NumberUtils;

public class SwiftLintCheckMappingsAndOptionsUpdater {
    private static final Set<String> IGNORED_OPTIONS_KEYWORDS = Set.of("warning", "error", "(severity) warning", "(severity) error", "N/A", "severity: warning", "severity: error");
    private static final File DEFAULT_RULES_FILE = new File("server/com.teamscale.service/src/main/resources/com/teamscale/service/project/analysis_profile/swiftlint-default-rules.txt");
    private static final File CHECK_MAPPINGS_TSV = new File("server/com.teamscale.index/src/main/resources/com/teamscale/index/configuration/tools/message/swiftlint/check-mappings.tsv");
    private static final File CHECK_OPTIONS_TSV = new File("server/com.teamscale.index/src/main/resources/com/teamscale/index/configuration/tools/message/swiftlint/check-options.tsv");
    private final ListMap<String, ToolCheck> warningAndErrorOptionsByPrefix = new ListMap();

    public static void main(String ... arguments) throws Exception {
        Pair<Integer, String> rules = SwiftLintRunner.getNonAnalysisCommandLineOutput("rules", "--verbose");
        SwiftLintCheckMappingsAndOptionsUpdater updater = new SwiftLintCheckMappingsAndOptionsUpdater();
        List<ToolCheck> toolChecks = updater.parseRules((String)rules.getSecond());
        SwiftLintCheckMappingsAndOptionsUpdater.updateCheckOptionsFile(toolChecks.stream().filter(t -> t.option != null).map(t -> t.option).toList());
        SwiftLintCheckMappingsAndOptionsUpdater.updateMappingsFile(toolChecks.stream().map(t -> t.checkId).toList());
        SwiftLintCheckMappingsAndOptionsUpdater.updateDefaultRulesFile(toolChecks);
    }

    private List<ToolCheck> parseRules(String commandlineOutput) {
        ArrayList<ToolCheck> toolCheckOptions = new ArrayList<ToolCheck>();
        List lines = StringUtils.splitLinesAsList((String)commandlineOutput);
        lines.remove(0);
        lines.remove(0);
        lines.remove(0);
        for (String rule : lines) {
            toolCheckOptions.addAll(this.parseLine(rule));
        }
        toolCheckOptions.addAll(this.addMissingOptions());
        return toolCheckOptions;
    }

    private static String getDefaultRulesDoc(String version) {
        return "# This file lists those SwiftLint rules that are enabled by default in version $version of SwiftLint. The file is\n# generated by SwiftLintCheckMappingsAndOptionsUpdater.java.\n".replace("$version", version).trim();
    }

    private static void updateDefaultRulesFile(List<ToolCheck> toolChecks) throws IOException {
        ArrayList<String> output = new ArrayList<String>();
        Pair<Integer, String> rules = SwiftLintRunner.getNonAnalysisCommandLineOutput("--version");
        output.add(SwiftLintCheckMappingsAndOptionsUpdater.getDefaultRulesDoc(((String)rules.getSecond()).trim()));
        output.addAll(new TreeSet<String>(toolChecks.stream().filter(t -> !t.optIn).map(t -> t.checkId).toList()));
        FileSystemUtils.writeLinesUTF8((Path)DEFAULT_RULES_FILE.toPath(), output);
    }

    private static void updateMappingsFile(List<String> newCheckIds) throws IOException {
        TreeSet<String> sortedCheckIds = new TreeSet<String>(newCheckIds);
        Map mappingMap = CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv((File)CHECK_MAPPINGS_TSV, (boolean)true, (boolean)true);
        ArrayList checkMappings = new ArrayList(mappingMap.values());
        for (String newCheckId : sortedCheckIds) {
            if (mappingMap.containsKey(newCheckId)) continue;
            checkMappings.add(new CheckMapping(newCheckId, "TODO", "TODO", "TODO", null));
        }
        CheckMappingAndCheckOptionTSVUtils.writeCheckMappingsToFile((File)CHECK_MAPPINGS_TSV, checkMappings);
    }

    private static void updateCheckOptionsFile(List<ToolCheckOption> toolCheckOptions) throws IOException {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("Check ID\tOption ID\tReadable Name\tDescription\tType\tDefault Value");
        strings.addAll(SwiftLintCheckMappingsAndOptionsUpdater.toTSV(toolCheckOptions));
        FileSystemUtils.writeLinesUTF8((Path)CHECK_OPTIONS_TSV.toPath(), strings);
    }

    private static List<String> toTSV(List<ToolCheckOption> options) {
        ArrayList<String> result = new ArrayList<String>();
        for (ToolCheckOption option : options) {
            String optionId = StringUtils.getLastPart((String)option.fullQualifiedID, (String)"#");
            result.add(option.checkId + "\t" + optionId + "\t" + option.getReadableName() + "\t" + option.getDescription() + "\t" + String.valueOf(option.type) + "\t" + StringUtils.emptyIfNull((String)option.getDefaultValue()));
        }
        return result;
    }

    @VisibleForTesting
    public List<ToolCheck> parseLine(String line) {
        ArrayList<ToolCheck> toolCheckOptions = new ArrayList<ToolCheck>();
        line = SwiftLintCheckMappingsAndOptionsUpdater.fixLinesWithInconsistentSyntax(line).trim();
        List parts = StringUtils.splitToList((String)(line = StringUtils.strip((String)line, (String)"|")), (String)" +\\|");
        if (parts.size() < 2) {
            return toolCheckOptions;
        }
        String rule = ((String)parts.get(0)).trim();
        if (rule.equals("custom_rules")) {
            return Collections.emptyList();
        }
        boolean optIn = "yes".equals(((String)parts.get(1)).trim());
        String configuration = (String)parts.get(parts.size() - 1);
        List configurationOptions = StringUtils.splitTopLevel((String)configuration, (char)';', (char)'[', (char)']');
        for (String optionGroup : configurationOptions) {
            toolCheckOptions.addAll(this.processOptionGroup(rule, optIn, optionGroup));
        }
        return toolCheckOptions;
    }

    private List<ToolCheck> processOptionGroup(String rule, boolean optIn, String optionGroup) {
        boolean composedWarningOption;
        boolean composedOption;
        String trimmedOptionGroup = optionGroup.trim();
        if (IGNORED_OPTIONS_KEYWORDS.contains(trimmedOptionGroup) || trimmedOptionGroup.contains("_severity:")) {
            return List.of(new ToolCheck(null, rule, optIn));
        }
        boolean containsColon = optionGroup.contains(":");
        Pair splittedOptionName = containsColon ? StringUtils.splitAtFirst((String)optionGroup, (char)':') : StringUtils.splitAtLast((String)optionGroup, (char)' ');
        String optionName = ((String)splittedOptionName.getFirst()).strip();
        String defaultValue = ((String)splittedOptionName.getSecond()).strip();
        EToolCheckOptionType defaultValueType = SwiftLintCheckMappingsAndOptionsUpdater.getTypeFromValue(defaultValue);
        if (defaultValueType == EToolCheckOptionType.STRING_LIST) {
            defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
        }
        boolean bl = composedOption = (composedWarningOption = optionGroup.contains(" warning:")) && optionGroup.contains("error:");
        if (composedOption || composedWarningOption) {
            return SwiftLintCheckMappingsAndOptionsUpdater.parseComposedOptions(rule, optIn, optionName, defaultValue);
        }
        boolean nestedOption = optionGroup.contains("(") && optionGroup.contains(")");
        return List.of(this.processNonComposedOption(rule, optIn, nestedOption, optionName, defaultValue, defaultValueType));
    }

    private ToolCheck processNonComposedOption(String rule, boolean optIn, boolean nestedOption, String optionName, String defaultValue, EToolCheckOptionType defaultValueType) {
        ToolCheck toolCheck = nestedOption ? SwiftLintCheckMappingsAndOptionsUpdater.parseNestedOption(rule, optIn, optionName, defaultValue) : SwiftLintCheckMappingsAndOptionsUpdater.buildToolCheck(rule, optIn, optionName, defaultValue, defaultValueType);
        if (toolCheck.option.getReadableName().endsWith(".warning")) {
            this.warningAndErrorOptionsByPrefix.add((Object)toolCheck.option.getReadableName().replace(".warning", ""), (Object)toolCheck);
        }
        if (toolCheck.option.getReadableName().endsWith(".error")) {
            this.warningAndErrorOptionsByPrefix.add((Object)toolCheck.option.getReadableName().replace(".error", ""), (Object)toolCheck);
        }
        return toolCheck;
    }

    private static List<ToolCheck> parseComposedOptions(String rule, boolean optIn, String optionName, String defaultValue) {
        String warningOptionName = optionName.concat(".warning");
        String warningInfo = (String)StringUtils.splitAtLast((String)defaultValue, (char)',').getFirst();
        String warningDefaultValue = ((String)StringUtils.splitAtLast((String)warningInfo, (char)':').getSecond()).trim();
        EToolCheckOptionType defaultWarningValueType = SwiftLintCheckMappingsAndOptionsUpdater.getTypeFromValue(warningDefaultValue);
        ToolCheck warningCheck = SwiftLintCheckMappingsAndOptionsUpdater.buildToolCheck(rule, optIn, warningOptionName, warningDefaultValue, defaultWarningValueType);
        String errorOptionName = optionName.concat(".error");
        String errorInfo = (String)StringUtils.splitAtLast((String)defaultValue, (char)',').getSecond();
        String errorDefaultValue = ((String)StringUtils.splitAtLast((String)errorInfo, (char)':').getSecond()).trim();
        EToolCheckOptionType defaultErrorValueType = defaultWarningValueType;
        if (!StringUtils.isEmpty((String)errorDefaultValue)) {
            defaultErrorValueType = SwiftLintCheckMappingsAndOptionsUpdater.getTypeFromValue(errorDefaultValue);
        }
        ToolCheck errorCheck = SwiftLintCheckMappingsAndOptionsUpdater.buildToolCheck(rule, optIn, errorOptionName, errorDefaultValue, defaultErrorValueType);
        return List.of(warningCheck, errorCheck);
    }

    private static ToolCheck parseNestedOption(String rule, boolean optIn, String optionName, String defaultValue) {
        String mainOptionName = ((String)optionName).substring(((String)optionName).indexOf("(") + 1, ((String)optionName).indexOf(")"));
        String subOptionName = (String)StringUtils.splitAtLast((String)optionName, (char)' ').getSecond();
        if (subOptionName.equals("w")) {
            subOptionName = "warning";
        }
        if (subOptionName.equals("e")) {
            subOptionName = "error";
        }
        optionName = subOptionName.isEmpty() ? mainOptionName : mainOptionName + "." + subOptionName;
        optionName = ((String)optionName).replace(" ", "_");
        return SwiftLintCheckMappingsAndOptionsUpdater.buildToolCheck(rule, optIn, (String)optionName, defaultValue, SwiftLintCheckMappingsAndOptionsUpdater.getTypeFromValue(defaultValue));
    }

    private static ToolCheck buildToolCheck(String checkId, boolean optIn, String optionName, String defaultValue, EToolCheckOptionType type) {
        String fixedCheckID = SwiftLintCheckMappingsAndOptionsUpdater.fixCheckId(checkId);
        Pair<EToolCheckOptionType, String> fixedTypeAndValue = SwiftLintCheckMappingsAndOptionsUpdater.fixTypeAndDefaultValue(optionName, type, defaultValue);
        optionName = optionName.replace(" ", "_");
        ToolCheckOption option = new ToolCheckOption(fixedCheckID, optionName, fixedCheckID + "." + optionName, "", (EToolCheckOptionType)fixedTypeAndValue.getFirst(), (String)fixedTypeAndValue.getSecond());
        return new ToolCheck(option, option.checkId, optIn);
    }

    private static EToolCheckOptionType getTypeFromValue(String value) {
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
            return EToolCheckOptionType.BOOLEAN;
        }
        if (NumberUtils.isDigits((String)value)) {
            return EToolCheckOptionType.INTEGER;
        }
        if (value.startsWith("[") && value.endsWith("]")) {
            return EToolCheckOptionType.STRING_LIST;
        }
        return EToolCheckOptionType.STRING;
    }

    private static String fixLinesWithInconsistentSyntax(String line) {
        int index;
        if (line.contains("required_enum_case") && (index = line.indexOf("{Protocol Name}: {Case Name 1}: {warning|error}, {Case Name 2}: {warning|error}")) != -1) {
            return line.substring(0, index) + "yaml_config:";
        }
        return line;
    }

    private static String fixCheckId(String checkId) {
        if ("nesting".equals(checkId)) {
            return "swift-nesting";
        }
        if ("cyclomatic_complexity".equals(checkId)) {
            return "swift-cyclomatic_complexity";
        }
        return checkId;
    }

    private static Pair<EToolCheckOptionType, String> fixTypeAndDefaultValue(String optionId, EToolCheckOptionType type, String defaultValue) {
        if ("yaml_config".equals(optionId)) {
            return Pair.createPair((Object)EToolCheckOptionType.MULTILINE_STRING, (Object)defaultValue);
        }
        if ("validates_start_with_lowercase".equals(optionId)) {
            return Pair.createPair((Object)EToolCheckOptionType.BOOLEAN, (Object)"true");
        }
        return Pair.createPair((Object)type, (Object)defaultValue);
    }

    public List<ToolCheck> addMissingOptions() {
        ArrayList<ToolCheck> missingToolChecks = new ArrayList<ToolCheck>();
        for (String key : this.warningAndErrorOptionsByPrefix.getKeys()) {
            List toolChecks = (List)this.warningAndErrorOptionsByPrefix.getCollection((Object)key);
            if (toolChecks == null || toolChecks.size() != 1) continue;
            ToolCheckOption toolCheckOption = ((ToolCheck)toolChecks.get((int)0)).option;
            ToolCheck toolCheck = new ToolCheck(SwiftLintCheckMappingsAndOptionsUpdater.getMissingOption(toolCheckOption), toolCheckOption.checkId, ((ToolCheck)toolChecks.get((int)0)).optIn);
            missingToolChecks.add(toolCheck);
        }
        return missingToolChecks;
    }

    private static ToolCheckOption getMissingOption(ToolCheckOption option) {
        String newReadableName;
        String newOptionId;
        if (option.optionId.contains("warning")) {
            newOptionId = option.optionId.replace("warning", "error");
            newReadableName = option.getReadableName().replace("warning", "error");
        } else {
            newOptionId = option.optionId.replace("error", "warning");
            newReadableName = option.getReadableName().replace("error", "warning");
        }
        return new ToolCheckOption(option.checkId, newOptionId, newReadableName, option.getDescription(), option.type, null);
    }

    public record ToolCheck(ToolCheckOption option, String checkId, boolean optIn) {
    }
}

