/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues;

import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.EConnectorType;
import com.teamscale.core.analysis.configuration.model.IConnectorEnum;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.configuration.ESchedulingParameter;
import com.teamscale.index.issues.IssueTrackerSynchronizerBase;
import com.teamscale.index.requirements_tracing.index.SpecItemChangesIndex;
import com.teamscale.index.requirements_tracing.index.TempWorkItemIndex;
import java.time.Duration;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;

public abstract class IssueTrackerConnectorDescriptorBase
extends ConnectorDescriptorBase {
    private static final Set<EConnectorType> ALLOWED_CONNECTOR_TYPES = Collections.unmodifiableSet(EnumSet.of(EConnectorType.REQUIREMENTS_MANAGEMENT_TOOL, EConnectorType.ISSUE_TRACKER));
    private static final String MAXIMUM_CHANGE_AGGREGATION_SPAN_PARAMETER = "Maximum Change Aggregation Span";
    private static final String MAXIMUM_CHANGE_AGGREGATION_SESSION_LENGTH_PARAMETER = "Maximum Change Aggregation Session Length";
    private static final String CHANGED_SINCE_PARAMETER = "Import Issue history since";
    @ConfigExposed(name="Polling interval (seconds)", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="The interval used for polling the server (default: 600).", changeRequiresReAnalysis=false)
    protected int pollingIntervalSeconds = 600;
    @ConfigExposed(name="Import Issue history since", description="The start timestamp of the history to retrieve. This limits the amount of history we import for each item, but does not limit which items to import.", visibility=ConfigExposed.EConfigVisibility.ADVANCED)
    private String changedSince = "1 year ago";
    @ConfigExposed(name="Import only Items Changed After", description="If given, items that did not change after the provided timestamp will be ignored during import. The preselected 'all items' imports all items.", visibility=ConfigExposed.EConfigVisibility.ADVANCED)
    private String importOnlyItemsChangedAfter = "";
    @ConfigExposed(name="Enable Change Aggregation", description="Enables Teamscale to aggregate several changes.\n\nEach item change creates a new commit within Teamscale.\nThis can lead to performance problems during analysis or metrics retrieval.\nTo mitigate this, Teamscale can aggregate multiple changes into one change, reducing the number of commits.\n\nWhen enabled, Teamscale aggregates multiple changes by the same author into one change.\nYou can configure the time thresholds using the 'Maximum Change Aggregation Session Length' and 'Maximum Change Aggregation Span' parameter.\n", visibility=ConfigExposed.EConfigVisibility.EXPERT, dependentOptions={"Maximum Change Aggregation Session Length", "Maximum Change Aggregation Span"})
    private boolean changeAggregationEnabled = false;
    @ConfigExposed(name="Maximum Change Aggregation Span", description="Defines the maximum time in seconds that can be between two changes in order for them to be aggregated.\n", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    private int maximumChangeAggregationSpan = (int)Duration.ofHours(1L).toSeconds();
    @ConfigExposed(name="Maximum Change Aggregation Session Length", description="Defines the maximum time in seconds that a single aggregation session can last.\n", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    private int maximumChangeAggregationSessionLength = (int)Duration.ofHours(8L).toSeconds();

    protected IssueTrackerConnectorDescriptorBase(IConnectorEnum<?> connectorEnum, EConnectorType connectorType) {
        super(connectorEnum, IssueTrackerConnectorDescriptorBase.assertCorrectType(connectorType));
    }

    private static EConnectorType assertCorrectType(EConnectorType connectorType) {
        CCSMAssert.isNotNull((Object)connectorType, () -> String.format("Expected \"%s\" to be not null", "connectorType"));
        CCSMAssert.isTrue((boolean)ALLOWED_CONNECTOR_TYPES.contains(connectorType), () -> String.format("Expected \"%s\" (%s) to be in: %s", "connectorType", connectorType, ALLOWED_CONNECTOR_TYPES));
        return connectorType;
    }

    public void validate() throws ConnectorValidationException {
        super.validate();
        ConnectorUtils.validateTimestamp((String)this.changedSince);
        if (!StringUtils.isEmpty((String)this.importOnlyItemsChangedAfter)) {
            ConnectorUtils.validateTimestamp((String)this.importOnlyItemsChangedAfter);
        }
        if (this.changeAggregationEnabled) {
            if (this.maximumChangeAggregationSpan <= 0) {
                throw new ConnectorValidationException("Maximum Change Aggregation Span must be positive");
            }
            if (this.maximumChangeAggregationSessionLength <= 0) {
                throw new ConnectorValidationException("Maximum Change Aggregation Session Length must be positive");
            }
            if (this.maximumChangeAggregationSessionLength < this.maximumChangeAggregationSpan) {
                throw new ConnectorValidationException("Maximum Change Aggregation Session Length must be greater than Maximum Change Aggregation Span");
            }
        }
    }

    protected void configureIndices(ConnectorDescriptorBase.IIndexCreator indexCreator) {
        super.configureIndices(indexCreator);
        indexCreator.createProjectIndex(TempWorkItemIndex.class, TempWorkItemIndex.getIndexNameForRepository(this.getConnectorIdentifier()));
        indexCreator.createProjectIndex(SpecItemChangesIndex.class, SpecItemChangesIndex.getIndexNameForRepository(this.getConnectorIdentifier()));
    }

    protected void configureTriggers(ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        super.configureTriggers(triggerCreator);
        triggerCreator.createTrigger(this.createIssueTrackerSynchronizer(), this.getConnectorIdentifier());
    }

    private TriggerBuilder createIssueTrackerSynchronizer() throws ProjectConfigurationException {
        Class<? extends IssueTrackerSynchronizerBase<?>> issueTrackerSynchronizerClass = this.getIssueTrackerSynchronizerClass();
        IssueTrackerConnectorDescriptorBase.ensureSchedulingHintIsPresent(issueTrackerSynchronizerClass, (EAnalysisStepParameter)EAnalysisStepParameter.IGNORE_FOR_ROLLBACK);
        TriggerBuilder triggerBuilder = new TriggerBuilder(issueTrackerSynchronizerClass);
        triggerBuilder.setTriggerParameter("polling-interval-seconds", this.pollingIntervalSeconds);
        triggerBuilder.setTriggerParameter("account-identifier", this.getAccountIdentifier());
        triggerBuilder.setTriggerParameter("connector-id", this.getConnectorIdentifier());
        triggerBuilder.setSchedulingParameter(ESchedulingParameter.PERIOD, (Object)Duration.ofSeconds(this.pollingIntervalSeconds));
        triggerBuilder.setTriggerParameter("initial-timestamp", ConnectorUtils.validateTimestamp((String)this.changedSince));
        if (!StringUtils.isEmpty((String)this.importOnlyItemsChangedAfter)) {
            triggerBuilder.setTriggerParameter("import-only-items-changed-after", ConnectorUtils.validateTimestamp((String)this.importOnlyItemsChangedAfter));
        }
        triggerBuilder.setTriggerParameter("changeAggregationGrouper-enabled", this.changeAggregationEnabled);
        if (this.changeAggregationEnabled) {
            triggerBuilder.setTriggerParameter("changeAggregationGrouper-maximumSessionLength", this.maximumChangeAggregationSessionLength);
            triggerBuilder.setTriggerParameter("changeAggregationGrouper-maximumAggregationSpan", this.maximumChangeAggregationSpan);
        }
        this.configureAdditionalIssueTrackerParameters(triggerBuilder);
        return triggerBuilder;
    }

    public abstract String getAccountIdentifier();

    public void deleteConfigurationData(ProjectStorageSystem projectStorageSystem, String uri) {
    }

    protected abstract Class<? extends IssueTrackerSynchronizerBase<?>> getIssueTrackerSynchronizerClass();

    protected abstract String getWorkItemIndexName();

    protected void configureAdditionalIssueTrackerParameters(TriggerBuilder issueTrackerTriggerBuilder) throws ProjectConfigurationException {
        issueTrackerTriggerBuilder.renameIndex("temp-spec-items", TempWorkItemIndex.getIndexNameForRepository(this.getConnectorIdentifier()));
        issueTrackerTriggerBuilder.renameIndex("single-specitemchanges", SpecItemChangesIndex.getIndexNameForRepository(this.getConnectorIdentifier()));
    }

    protected void storeConfigurationDataInternal(ProjectStorageSystem projectStorageSystem) {
    }
}

