/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.radar.client;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.rest.client.authentication.ICustomAuthenticationInterceptor;
import com.teamscale.index.issues.radar.client.RadarClient;
import java.io.IOException;
import java.time.Duration;
import okhttp3.Request;
import okhttp3.Response;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;

public class RadarAuthenticationInterceptor
implements ICustomAuthenticationInterceptor {
    public static final String APP_ID_HEADER_NAME = "X-Apple-Client-App-ID";
    public static final String A3_TOKEN_HEADER_NAME = "X-Apple-IDMS-A3-Token";
    public static final String USER_ID_HEADER_NAME = "X-Apple-User-ID";
    private static final String RADAR_AUTHENTICATION_HEADER_NAME = "Radar-Authentication";
    private final AccessTokenIndex accessTokenIndex;
    private final RadarClient.RadarAuthenticator authenticator;
    private final String radarBaseUrl;

    public RadarAuthenticationInterceptor(String radarBaseUrl, AccessTokenIndex accessTokenIndex, RadarClient.RadarAuthenticator authenticator) {
        this.radarBaseUrl = radarBaseUrl;
        this.authenticator = authenticator;
        this.accessTokenIndex = accessTokenIndex;
    }

    @VisibleForTesting
    public static String getTokenName(String radarBaseUrl) {
        return "##Radar##" + radarBaseUrl;
    }

    public @NonNull Response intercept(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Interceptor.Chain chain) throws IOException {
        String token;
        try {
            token = this.accessTokenIndex.getOrCreateToken(RadarAuthenticationInterceptor.getTokenName(this.radarBaseUrl), Duration.ofMinutes(30L), () -> this.authenticator.requestAuthenticationToken().toAccessToken());
        }
        catch (ServiceCallException | StorageException e) {
            throw new IOException("Could not retrieve Radar authentication token", e);
        }
        CCSMAssert.isNotNull((Object)token, (String)"Radar authentication token must not be null after request.");
        Request newRequest = chain.request().newBuilder().header(RADAR_AUTHENTICATION_HEADER_NAME, token).build();
        return chain.proceed(newRequest);
    }
}

