/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Comparators;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.voting.VotingRecord;
import com.teamscale.index.tracking.FindingChurnCount;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public record ExtendedMergeRequest(@JsonProperty(value="mergeRequest") MergeRequest mergeRequest, @JsonProperty(value="votingRecord") VotingRecord votingRecord, @JsonProperty(value="findingChurnCount") @Nullable FindingChurnCount findingChurnCount) implements Serializable
{
    private static final long serialVersionUID = 1L;

    @JsonCreator
    public ExtendedMergeRequest(@JsonProperty(value="mergeRequest") MergeRequest mergeRequest, @JsonProperty(value="votingRecord") VotingRecord votingRecord, @JsonProperty(value="findingChurnCount") @Nullable FindingChurnCount findingChurnCount) {
        this.mergeRequest = mergeRequest;
        this.votingRecord = votingRecord == null ? VotingRecord.unvoted() : votingRecord;
        this.findingChurnCount = findingChurnCount;
    }

    public String getTitle() {
        return this.mergeRequest.getTitle();
    }

    public long getId() {
        return this.mergeRequest.getId();
    }

    public String getSourceBranch() {
        return this.mergeRequest.getSourceBranch();
    }

    public String getTargetBranch() {
        return this.mergeRequest.getTargetBranch();
    }

    public Long getCreatedAt() {
        return this.mergeRequest.getCreatedAt();
    }

    public VotingRecord.EVotingState getVoteState() {
        return this.votingRecord.getState();
    }

    public Optional<Long> getVoteTimestamp() {
        return this.votingRecord.getTimestamp();
    }

    public static @Nullable Comparator<ExtendedMergeRequest> getComparatorForField(String sortBy) {
        switch (sortBy) {
            case "title": {
                return Comparator.comparing(ExtendedMergeRequest::getTitle);
            }
            case "id": {
                return Comparator.comparing(ExtendedMergeRequest::getId);
            }
            case "sourceBranch": {
                return Comparator.comparing(ExtendedMergeRequest::getSourceBranch);
            }
            case "targetBranch": {
                return Comparator.comparing(ExtendedMergeRequest::getTargetBranch);
            }
            case "createdAt": {
                return Comparator.comparing(ExtendedMergeRequest::getCreatedAt, Comparator.nullsLast(Long::compareTo));
            }
            case "voteState": {
                return Comparator.comparing(ExtendedMergeRequest::getVoteState);
            }
            case "voteTimestamp": {
                return Comparator.comparing(ExtendedMergeRequest::getVoteTimestamp, Comparators.emptiesLast(Comparator.naturalOrder()));
            }
            case "Findings": {
                return Comparator.comparing(ExtendedMergeRequest::findingChurnCount, Comparator.nullsFirst(Comparator.comparingInt(FindingChurnCount::getAddedFindings).thenComparingInt(FindingChurnCount::getFindingsInChangedCode).thenComparingInt(FindingChurnCount::getRemovedFindings).thenComparingInt(FindingChurnCount::getFindingsAddedInBranch).thenComparingInt(FindingChurnCount::getFindingsRemovedInBranch)));
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object extendedMergeRequestObject) {
        if (this == extendedMergeRequestObject) {
            return true;
        }
        if (extendedMergeRequestObject == null || this.getClass() != extendedMergeRequestObject.getClass()) {
            return false;
        }
        ExtendedMergeRequest extendedMergeRequest = (ExtendedMergeRequest)extendedMergeRequestObject;
        return this.mergeRequest.equals(extendedMergeRequest.mergeRequest) && this.votingRecord.state == extendedMergeRequest.votingRecord.state && this.votingRecord.getTimestamp().equals(extendedMergeRequest.getVoteTimestamp());
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.mergeRequest.identifier, this.mergeRequest.sourceBranch, this.mergeRequest.sourceHead, this.mergeRequest.targetBranch, this.mergeRequest.createdAt, this.votingRecord.state, this.votingRecord.getTimestamp()});
    }
}

