/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request;

import com.google.common.base.Preconditions;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.index.merge_request.EMergeRequestBuildStatus;
import com.teamscale.index.merge_request.EMergeRequestStatus;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.MergeRequestBuildJob;
import com.teamscale.index.merge_request.MergeRequestBuildJobHandler;
import com.teamscale.index.merge_request.MergeRequestBuildPipelineInfo;
import com.teamscale.index.repository.git.cross_repo_merge_requests.CrossRepositoryMergeRequestSourceBranch;
import com.teamscale.index.repository.git.cross_repo_merge_requests.ICrossRepositoryMergeRequestHandler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class MergeRequestProvider<PLATFORM_SPECIFIC_MERGE_REQUEST, PLATFORM_SPECIFIC_BUILD_JOB> {
    private final @Nullable ICrossRepositoryMergeRequestHandler<PLATFORM_SPECIFIC_MERGE_REQUEST> crossRepoMergeRequestHandler;
    private final @Nullable MergeRequestBuildJobHandler<PLATFORM_SPECIFIC_BUILD_JOB> mergeRequestBuildJobsHandler;

    protected MergeRequestProvider(@Nullable ICrossRepositoryMergeRequestHandler<PLATFORM_SPECIFIC_MERGE_REQUEST> crossRepoMergeRequestHandler, @Nullable MergeRequestBuildJobHandler<PLATFORM_SPECIFIC_BUILD_JOB> mergeRequestBuildJobsHandler) {
        this.crossRepoMergeRequestHandler = crossRepoMergeRequestHandler;
        this.mergeRequestBuildJobsHandler = mergeRequestBuildJobsHandler;
    }

    public abstract @Nullable PLATFORM_SPECIFIC_MERGE_REQUEST getPlatformMergeRequest(long var1) throws ServiceCallException;

    protected abstract List<PLATFORM_SPECIFIC_MERGE_REQUEST> getAllOpenPlatformMergeRequests() throws ServiceCallException;

    public List<MergeRequest> getAllSupportedOpenMergeRequests() throws ServiceCallException {
        return this.convertToMergeRequests(CollectionUtils.filterWithException(this.getAllOpenPlatformMergeRequests(), this::isMergeRequestSupported));
    }

    public MergeRequest getMergeRequest(long id) throws ServiceCallException {
        PLATFORM_SPECIFIC_MERGE_REQUEST mergeRequest = this.getPlatformMergeRequest(id);
        if (mergeRequest == null || !this.isMergeRequestSupported(mergeRequest)) {
            return null;
        }
        return this.convertToMergeRequest(mergeRequest);
    }

    @Contract(value="null -> null")
    public @Nullable MergeRequest convertToMergeRequest(@Nullable PLATFORM_SPECIFIC_MERGE_REQUEST mergeRequest) throws ServiceCallException {
        if (mergeRequest == null) {
            return null;
        }
        IMergeRequestAdapter converter = this.createMergeRequestAdapter(mergeRequest);
        SourceBranchAndCommit sourceBranchAndCommit = new SourceBranchAndCommit(this.getSourceBranch(mergeRequest, converter), converter.getCommit());
        return new MergeRequest(converter.getIdentifier(), converter.getStatus(), converter.getTitle(), sourceBranchAndCommit, converter.getTargetBranch(), converter.getUrl(), converter.getCreatedAt(), converter.getUpdatedAt(), this.createMergeRequestBuildPipelineInfo(sourceBranchAndCommit.sourceCommitHash()));
    }

    protected boolean requiresBuildCompletenessBeforeVoting() {
        return this.mergeRequestBuildJobsHandler != null && this.mergeRequestBuildJobsHandler.requiresBuildCompletenessBeforeVoting();
    }

    private MergeRequestBuildPipelineInfo createMergeRequestBuildPipelineInfo(String commitHash) throws ServiceCallException {
        if (!this.requiresBuildCompletenessBeforeVoting()) {
            return new MergeRequestBuildPipelineInfo(false, Collections.emptyList());
        }
        return new MergeRequestBuildPipelineInfo(true, this.getMergeRequestBuildJobs(commitHash));
    }

    protected @NonNull IncludeExcludeRegexSupport getConfiguredBuildJobIncludeExcludePatterns() {
        if (this.mergeRequestBuildJobsHandler == null) {
            return new IncludeExcludeRegexSupport();
        }
        return this.mergeRequestBuildJobsHandler.buildIncludeExcludeRegexSupport;
    }

    private List<MergeRequestBuildJob> getMergeRequestBuildJobs(String mergeRequestSourceHead) throws ServiceCallException {
        List<Object> buildJobs = new ArrayList();
        if (this.requiresBuildCompletenessBeforeVoting()) {
            Preconditions.checkArgument((this.mergeRequestBuildJobsHandler != null ? 1 : 0) != 0, (Object)"%s should not be null.".formatted("mergeRequestBuildJobsHandler"));
            buildJobs = this.mergeRequestBuildJobsHandler.getPlatformMergeRequestBuildJobs(mergeRequestSourceHead);
        }
        return buildJobs.stream().map(this::convertToMergeRequestBuildJob).toList();
    }

    private MergeRequestBuildJob convertToMergeRequestBuildJob(PLATFORM_SPECIFIC_BUILD_JOB buildJob) {
        IMergeRequestBuildJobAdapter buildJobAdapter = this.createMergeRequestBuildJobAdapter(buildJob);
        Preconditions.checkArgument((buildJobAdapter != null ? 1 : 0) != 0, (Object)"%s should not be null.".formatted("buildJobAdapter"));
        return new MergeRequestBuildJob(buildJobAdapter.getName(), buildJobAdapter.getStatus());
    }

    private String getSourceBranch(PLATFORM_SPECIFIC_MERGE_REQUEST mergeRequest, IMergeRequestAdapter converter) {
        Optional<CrossRepositoryMergeRequestSourceBranch> crossRepositorySourceBranch = this.getCrossRepositorySourceBranch(mergeRequest);
        if (crossRepositorySourceBranch.isPresent()) {
            return crossRepositorySourceBranch.get().localBranchName();
        }
        return converter.getSourceBranch();
    }

    public Optional<CrossRepositoryMergeRequestSourceBranch> getCrossRepositorySourceBranch(@Nullable PLATFORM_SPECIFIC_MERGE_REQUEST mergeRequest) {
        if (mergeRequest == null || !this.supportsCrossRepositoryMergeRequests() || !this.crossRepoMergeRequestHandler.isCrossRepositoryMergeRequest(mergeRequest)) {
            return Optional.empty();
        }
        return Optional.of(this.crossRepoMergeRequestHandler.getSourceBranch(mergeRequest));
    }

    protected abstract IMergeRequestAdapter createMergeRequestAdapter(@Nullable PLATFORM_SPECIFIC_MERGE_REQUEST var1);

    protected @Nullable IMergeRequestBuildJobAdapter createMergeRequestBuildJobAdapter(PLATFORM_SPECIFIC_BUILD_JOB buildJob) {
        return null;
    }

    public List<MergeRequest> convertToMergeRequests(List<PLATFORM_SPECIFIC_MERGE_REQUEST> mergeRequests) throws ServiceCallException {
        return CollectionUtils.mapWithException(mergeRequests, this::convertToMergeRequest);
    }

    public boolean isMergeRequestSupported(@NonNull PLATFORM_SPECIFIC_MERGE_REQUEST mergeRequest) throws ServiceCallException {
        return this.supportsCrossRepositoryMergeRequests() || !this.isCrossRepositoryMergeRequest(mergeRequest);
    }

    private boolean supportsCrossRepositoryMergeRequests() {
        return this.crossRepoMergeRequestHandler != null;
    }

    protected abstract boolean isCrossRepositoryMergeRequest(@NonNull PLATFORM_SPECIFIC_MERGE_REQUEST var1) throws ServiceCallException;

    public abstract String getRepositoryName();

    protected static interface IMergeRequestAdapter {
        public MergeRequestIdentifier getIdentifier();

        public EMergeRequestStatus getStatus();

        public String getTitle();

        public String getSourceBranch();

        public String getCommit() throws ServiceCallException;

        public String getTargetBranch();

        public String getUrl();

        public Long getCreatedAt();

        public Long getUpdatedAt();
    }

    public record SourceBranchAndCommit(String sourceBranchName, String sourceCommitHash) implements Serializable
    {
        private static final long serialVersionUID = 1L;
    }

    protected static interface IMergeRequestBuildJobAdapter {
        public EMergeRequestBuildStatus getStatus();

        public @NonNull String getName();
    }
}

