/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request;

import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.utils.CommitDescriptorUtils;
import com.teamscale.index.merge_request.EMergeRequestStatus;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.MergeRequestIndex;
import com.teamscale.index.merge_request.voting.VotingException;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.function.SupplierWithException;

final class SkipMergeRequestCalculationEarlyChecker {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SupplierWithException<CommitDescriptorIndex, StorageException> commitDescriptorIndexSupplier = SupplierWithException.memoize(() -> (CommitDescriptorIndex)projectStorageSystem.openProjectIndex(CommitDescriptorIndex.class, null));
    private final SupplierWithException<MergeRequestIndex, StorageException> mergeRequestIndexSupplier = SupplierWithException.memoize(() -> (MergeRequestIndex)projectStorageSystem.openProjectIndex(MergeRequestIndex.class, null));
    private final SupplierWithException<RepositoryRevisionIndex, StorageException> repositoryRevisionIndexSupplier = SupplierWithException.memoize(() -> (RepositoryRevisionIndex)projectStorageSystem.openProjectIndex(RepositoryRevisionIndex.class, null));
    private final SupplierWithException<RepositoryLogIndex, StorageException> repositoryLogIndexSupplier = SupplierWithException.memoize(() -> (RepositoryLogIndex)projectStorageSystem.openProjectIndex(RepositoryLogIndex.class, null));
    private final CommitDescriptor schedulingCommit;
    private final BranchRenameResolver branchRenameResolver;

    private SkipMergeRequestCalculationEarlyChecker(ProjectStorageSystem projectStorageSystem, CommitDescriptor schedulingCommit, BranchRenameResolver branchRenameResolver) {
        this.schedulingCommit = schedulingCommit;
        this.branchRenameResolver = branchRenameResolver;
    }

    public static void skipCalculationEarlyIfPossible(ProjectStorageSystem projectStorageSystem, CommitDescriptor schedulingCommit, BranchRenameResolver branchRenameResolver) throws StorageException, VotingException {
        new SkipMergeRequestCalculationEarlyChecker(projectStorageSystem, schedulingCommit, branchRenameResolver).trySkippingEarly();
    }

    private void trySkippingEarly() throws StorageException, VotingException {
        Optional<RepositoryLogEntryAggregate> codeCommitLogEntry = this.findCodeCommitLogEntry();
        if (codeCommitLogEntry.isEmpty()) {
            this.skipVotingIfThereAreNewerCommitsOnTheBranch();
            return;
        }
        String originalBranchName = this.branchRenameResolver.resolveBranchName(codeCommitLogEntry.get().getPrimaryEntry().getRepositoryIdentifier(), this.schedulingCommit.getBranchName());
        this.skipVotingIfNoMergeRequestExistsForBranch(originalBranchName);
        this.skipVotingIfNotHeadOfOpenMergeRequest(originalBranchName, codeCommitLogEntry.get());
    }

    private void skipVotingIfThereAreNewerCommitsOnTheBranch() throws StorageException, VotingException.Skipped {
        Optional<CommitDescriptor> branchHead = this.getActualBranchHeadIfAfterSchedulingCommit();
        if (branchHead.isPresent()) {
            LOGGER.info("Skipping vote because there are newer commits on the branch {}.", (Object)this.schedulingCommit.getBranchName());
            throw VotingException.Skipped.moreRecentCommitsOnBranch(this.schedulingCommit);
        }
    }

    private Optional<CommitDescriptor> getActualBranchHeadIfAfterSchedulingCommit() throws StorageException {
        return ((CommitDescriptorIndex)this.commitDescriptorIndexSupplier.get()).getFirstActualCommitBeforeOrAt(CommitDescriptor.latestOnBranch((String)this.schedulingCommit.getBranchName()), this.schedulingCommit.getTimestamp() + 1L);
    }

    private void skipVotingIfNotHeadOfOpenMergeRequest(String originalBranchName, RepositoryLogEntryAggregate codeCommitLogEntry) throws VotingException.Skipped, StorageException {
        Set<String> headCommits = ((MergeRequestIndex)this.mergeRequestIndexSupplier.get()).getHeadCommitsForBranch(originalBranchName);
        if (CollectionUtils.anyMatchWithException(headCommits, headCommit -> this.mergeRequestBlocksSkipping((String)headCommit, codeCommitLogEntry))) {
            return;
        }
        LOGGER.info("Skipping vote because the currently analyzed commit {} is not the head commit of an open merge request.", (Object)this.schedulingCommit);
        throw VotingException.Skipped.noMergeRequestExists(this.schedulingCommit);
    }

    private boolean mergeRequestBlocksSkipping(String headCommit, RepositoryLogEntryAggregate codeCommitLogEntry) throws StorageException {
        Optional<MergeRequest> mergeRequest = ((MergeRequestIndex)this.mergeRequestIndexSupplier.get()).getMergeRequest(headCommit);
        if (mergeRequest.isPresent() && mergeRequest.get().status != EMergeRequestStatus.OPEN) {
            return false;
        }
        Optional<CommitDescriptor> headCommitDescriptor = ((RepositoryRevisionIndex)this.repositoryRevisionIndexSupplier.get()).getFirstKnownRepositoryCommit(headCommit);
        if (headCommitDescriptor.isEmpty()) {
            LOGGER.warn("Cannot skip early because we couldn't resolve the head commit {} for merge request {}. Scheduling commit is {}", (Object)headCommit, mergeRequest, (Object)this.schedulingCommit);
            return true;
        }
        if (headCommitDescriptor.get().getTimestamp() > this.schedulingCommit.getTimestamp()) {
            return false;
        }
        LOGGER.info("Not skipping voting early because code commit {} for the currently analyzed commit {} is the head of the open merge request {}.", (Object)codeCommitLogEntry, (Object)this.schedulingCommit, mergeRequest);
        return true;
    }

    private void skipVotingIfNoMergeRequestExistsForBranch(String originalBranchName) throws StorageException, VotingException.Skipped {
        if (!((MergeRequestIndex)this.mergeRequestIndexSupplier.get()).isKnownSourceBranch(originalBranchName)) {
            LOGGER.info("Skipping vote because there are no merge requests with the source branch of the scheduling commit {}.", (Object)originalBranchName);
            throw VotingException.Skipped.noMergeRequestExists(this.schedulingCommit);
        }
    }

    private Optional<RepositoryLogEntryAggregate> findCodeCommitLogEntry() throws StorageException {
        RepositoryLogEntryAggregate codeCommitLogEntry = (RepositoryLogEntryAggregate)((RepositoryLogIndex)((Object)this.repositoryLogIndexSupplier.get())).getEntry(this.schedulingCommit);
        if (codeCommitLogEntry == null) {
            LOGGER.warn("Unable to retrieve log entry for {}. Cannot skip voting early. This might result in slightly reduced performance.", (Object)this.schedulingCommit);
            return Optional.empty();
        }
        if (codeCommitLogEntry.getCommitTypes().contains((Object)ECommitType.CODE_COMMIT)) {
            return Optional.of(codeCommitLogEntry);
        }
        Optional possibleCodeCommit = CommitDescriptorUtils.guessCorrespondingCodeCommit((CommitDescriptor)this.schedulingCommit, (CommitDescriptorIndex)((CommitDescriptorIndex)this.commitDescriptorIndexSupplier.get()));
        if (possibleCodeCommit.isEmpty()) {
            LOGGER.warn("Unable to guess last code commit from {}. Cannot skip voting early. This might result in slightly reduced performance.", (Object)this.schedulingCommit);
            return Optional.empty();
        }
        RepositoryLogEntryAggregate possibleCodeCommitLogEntry = (RepositoryLogEntryAggregate)((RepositoryLogIndex)((Object)this.repositoryLogIndexSupplier.get())).getEntry((CommitDescriptor)possibleCodeCommit.get());
        if (possibleCodeCommitLogEntry == null) {
            LOGGER.warn("Unable to retrieve log entry for guessed last code commit {}. Cannot skip voting early. This might result in slightly reduced performance.", (Object)possibleCodeCommit);
            return Optional.empty();
        }
        if (!possibleCodeCommitLogEntry.getCommitTypes().contains((Object)ECommitType.CODE_COMMIT)) {
            LOGGER.warn("Log entry for guessed last code commit {} does not contain a code commit entry. Cannot skip voting early. This might result in slightly reduced performance.", (Object)possibleCodeCommit);
            return Optional.empty();
        }
        return Optional.of(possibleCodeCommitLogEntry);
    }

    @FunctionalInterface
    static interface BranchRenameResolver {
        public String resolveBranchName(String var1, String var2) throws StorageException;
    }
}

