/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request.comments;

import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.index.commit_alert.CommitAlert;
import com.teamscale.index.commit_alert.CommitAlerts;
import com.teamscale.index.merge_request.comments.RepositoryPathMapper;
import com.teamscale.index.merge_request.comments.ReviewCommentEngineParameters;
import com.teamscale.index.merge_request.comments.cluster.FindingCluster;
import com.teamscale.index.merge_request.comments.cluster.IFindingClusterStrategy;
import com.teamscale.index.merge_request.comments.comments.CommitAlertReviewComment;
import com.teamscale.index.merge_request.comments.comments.FindingsForReviewComment;
import com.teamscale.index.merge_request.comments.comments.IReviewComment;
import com.teamscale.index.merge_request.comments.comments.IReviewCommentFactory;
import com.teamscale.index.merge_request.comments.comments.ReviewCommentFactoryParameters;
import com.teamscale.index.merge_request.comments.comments.TestGapReviewComment;
import com.teamscale.index.repository.RepositoryOriginalPathIndex;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class ReviewCommentEngine {
    private final ReviewCommentFactoryParameters parameters;
    private final IFindingClusterStrategy findingClusterStrategy;

    private ReviewCommentEngine(ReviewCommentFactoryParameters parameters, IFindingClusterStrategy findingClusterStrategy) {
        this.parameters = parameters;
        this.findingClusterStrategy = findingClusterStrategy;
    }

    public List<RepositoryPathMapper.RepositoryReviewComment> getReviewComments(List<TrackedFinding> findings) throws StorageException {
        RepositoryPathMapper repositoryPathMapper = new RepositoryPathMapper(this.parameters.originalPathView(), findings);
        findings = repositoryPathMapper.removeFindingsWithUnknownPaths(findings);
        List<FindingsForReviewComment> findingsForReviewComments = this.getFindingsForReviewComments(findings);
        ArrayList<IReviewComment> reviewComments = new ArrayList<IReviewComment>();
        for (FindingsForReviewComment findingsForReviewComment : findingsForReviewComments) {
            IReviewCommentFactory commentProviderFactory = findingsForReviewComment.getFindingClusterType().createCommentProviderFactory();
            reviewComments.add(commentProviderFactory.create(findingsForReviewComment, this.parameters));
        }
        return repositoryPathMapper.mapCommentsToRepositoryPaths(reviewComments);
    }

    public List<RepositoryPathMapper.RepositoryReviewComment> getReviewCommentsForTestGaps(List<AssessedTgaData.AssessedMethodData> untestedMethods, MergeRequestIdentifier mergeRequestIdentifier) throws StorageException {
        RepositoryPathMapper repositoryPathMapper = new RepositoryPathMapper(this.parameters.originalPathView(), untestedMethods.stream().map(method -> method.getLocation().getUniformPath().toStringAsMigrationFrontier()).collect(Collectors.toSet()));
        untestedMethods = repositoryPathMapper.removeMethodsWithUnknownPaths(untestedMethods);
        ArrayList<IReviewComment> reviewComments = new ArrayList<IReviewComment>();
        for (AssessedTgaData.AssessedMethodData untestedMethod : untestedMethods) {
            TokenElementLineInfo lineInfo = this.parameters.tokenElementLineInfoIndex().getLineInfo(untestedMethod.getLocation().getUniformPath().toStringAsMigrationFrontier());
            reviewComments.add(new TestGapReviewComment(untestedMethod, this.parameters.linkProvider(), lineInfo, mergeRequestIdentifier));
        }
        return repositoryPathMapper.mapCommentsToRepositoryPaths(reviewComments);
    }

    public List<RepositoryPathMapper.RepositoryReviewComment> getReviewCommentsForAlerts(CommitAlerts commitAlerts) throws StorageException {
        RepositoryPathMapper repositoryPathMapper = new RepositoryPathMapper(this.parameters.originalPathView(), commitAlerts.getCommitAlerts().stream().map(alert -> alert.getContext().getExpectedCloneLocation().getUniformPath()).collect(Collectors.toSet()));
        List<CommitAlert> alerts = repositoryPathMapper.removeAlertsWithUnknownPaths((List<CommitAlert>)commitAlerts.getCommitAlerts());
        ArrayList<IReviewComment> reviewComments = new ArrayList<IReviewComment>();
        for (CommitAlert alert2 : alerts) {
            reviewComments.add(new CommitAlertReviewComment(alert2, this.parameters.commentedCommit(), commitAlerts.getCommit(), this.parameters.linkProvider()));
        }
        return repositoryPathMapper.mapCommentsToRepositoryPaths(reviewComments);
    }

    private List<FindingsForReviewComment> getFindingsForReviewComments(List<TrackedFinding> findings) throws StorageException {
        List<UniformPath> uniformPaths = ReviewCommentEngine.getDistinctPathsWithFindings(findings);
        List<List<TrackedFinding>> findingsForPaths = this.parameters.trackedFindingsIndex().getFindings(uniformPaths);
        ArrayList<FindingsForReviewComment> findingClustersForPaths = new ArrayList<FindingsForReviewComment>();
        CollectionUtils.forEachWithException(uniformPaths, findingsForPaths, (uniformPath, trackedFindings) -> {
            if (trackedFindings == null) {
                return;
            }
            List<FindingCluster> findingClusters = this.findingClusterStrategy.getFindingClusters((UniformPath)uniformPath, (List<TrackedFinding>)trackedFindings);
            for (FindingCluster findingCluster : findingClusters) {
                Set<TrackedFinding> findingsFromCluster = findingCluster.getFindings();
                HashSet matchedFindings = CollectionUtils.intersectionSet(findingsFromCluster, (Collection[])new Collection[]{findings});
                if (matchedFindings.isEmpty()) continue;
                HashSet relatedFindings = CollectionUtils.differenceSet(findingsFromCluster, (Collection[])new Collection[]{matchedFindings});
                FindingsForReviewComment findingsForReviewComment = new FindingsForReviewComment(findingCluster.getFindingClusterType(), new ArrayList<TrackedFinding>(matchedFindings), new ArrayList<TrackedFinding>(relatedFindings));
                findingClustersForPaths.add(findingsForReviewComment);
            }
        });
        return findingClustersForPaths;
    }

    private static List<UniformPath> getDistinctPathsWithFindings(List<TrackedFinding> findings) {
        return findings.stream().map(finding -> UniformPathCompatibilityUtil.convert((String)finding.getLocation().getUniformPath())).distinct().collect(Collectors.toList());
    }

    public static ReviewCommentEngine create(ReviewCommentEngineParameters reviewCommentTriggerParameters, IFindingClusterStrategy findingClusterStrategy, RepositoryOriginalPathIndex.RepositoryOriginalPathView originalPathView, CommitDescriptor commentedCommit, TeamscaleCommitLinkProvider linkProvider) {
        ReviewCommentFactoryParameters parameters = new ReviewCommentFactoryParameters(commentedCommit, reviewCommentTriggerParameters.getTrackedFindingsByIdIndex(), reviewCommentTriggerParameters.getTrackedFindingsIndex(), reviewCommentTriggerParameters.getMethodInfoIndex(), reviewCommentTriggerParameters.getTokenElementLineInfoIndex(), originalPathView, linkProvider);
        return new ReviewCommentEngine(parameters, findingClusterStrategy);
    }
}

