/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.metrics.assessment.context;

import com.teamscale.core.analysis.configuration.index.model.EMetricSchemaSource;
import com.teamscale.core.analysis.configuration.index.model.EvaluatedMetricThreshold;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdBase;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.index.metrics.assessment.context.IMetricEvaluationContext;
import com.teamscale.index.metrics.assessment.context.MetricDataRetriever;
import com.teamscale.index.metrics.assessment.context.MetricDataRetrieverFactory;
import java.util.Objects;
import java.util.Optional;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class MetricEvaluationContext
implements IMetricEvaluationContext {
    private final @NonNull String uniformPath;
    protected final MetricDataRetrieverFactory metricDataRetrieverFactory;
    protected HistoryAccessOption currentHistoryAccessOption;
    protected @Nullable HistoryAccessOption baselineHistoryAccessOption = null;

    public MetricEvaluationContext(String uniformPath, MetricDataRetrieverFactory metricDataRetrieverFactory) {
        this.uniformPath = StringUtils.emptyIfNull((String)uniformPath);
        this.metricDataRetrieverFactory = metricDataRetrieverFactory;
    }

    private MetricDataRetriever getDataRetrieverBySource(EMetricSchemaSource source) {
        return this.metricDataRetrieverFactory.get(source);
    }

    @Override
    public void setCurrentHistoryAccessOption(HistoryAccessOption historyAccessOption) {
        CCSMAssert.isNotNull((Object)historyAccessOption);
        this.currentHistoryAccessOption = historyAccessOption;
    }

    @Override
    public void setBaselineHistoryAccessOption(@Nullable HistoryAccessOption historyAccessOption) {
        this.baselineHistoryAccessOption = historyAccessOption;
    }

    @Override
    public Optional<MetricDirectorySchemaEntry> getMetricDirectorySchemaEntry(MetricThresholdBase threshold) throws StorageException {
        return this.getMetricDirectorySchemaEntry(threshold.getMetricName(), threshold.getMetricSchemaSource());
    }

    @Override
    public Optional<MetricDirectorySchemaEntry> getMetricDirectorySchemaEntry(String metricName, EMetricSchemaSource schemaSource) throws StorageException {
        return this.getDataRetrieverBySource(schemaSource).getMetricDirectorySchemaEntry(metricName);
    }

    @Override
    public boolean doesMetricDirectoryEntryExistAtCurrentAccessOption() throws StorageException {
        return this.getDataRetrieverBySource(EMetricSchemaSource.determineFromSubPath((String)this.uniformPath)).hasDirectoryEntry(this.uniformPath, this.currentHistoryAccessOption);
    }

    @Override
    public String getThresholdPath(EvaluatedMetricThreshold threshold) {
        return this.getThresholdPath(threshold.getSubPath());
    }

    @Override
    public String getThresholdPath(String subPath) {
        return MetricEvaluationContext.getThresholdPath(this.uniformPath, subPath);
    }

    @VisibleForTesting
    static String getThresholdPath(String uniformPathString, String subPathString) {
        UniformPath subPath;
        if (StringUtils.isEmpty((String)uniformPathString) && StringUtils.isEmpty((String)subPathString)) {
            return "";
        }
        if (StringUtils.isEmpty((String)uniformPathString)) {
            return MetricEvaluationContext.stripPrefixAndSuffixFromPath(subPathString);
        }
        if (StringUtils.isEmpty((String)subPathString)) {
            return MetricEvaluationContext.stripPrefixAndSuffixFromPath(uniformPathString);
        }
        UniformPath uniformPath = UniformPathCompatibilityUtil.convert((String)uniformPathString);
        if (Objects.equals(uniformPath, subPath = UniformPathCompatibilityUtil.convert((String)subPathString)) || uniformPath.hasAncestor(subPath)) {
            return uniformPath.toString();
        }
        if (subPath.hasAncestor(uniformPath)) {
            return subPath.toString();
        }
        if (!uniformPath.isCodePath() && !subPath.isCodePath() && uniformPath.getType() != subPath.getType()) {
            return subPath.toString();
        }
        if (!subPath.isCodePath()) {
            return subPath.resolve(uniformPath.getSubPath(0)).toString();
        }
        return uniformPath.resolve(subPath.getSubPath(0)).toString();
    }

    private static String stripPrefixAndSuffixFromPath(String path) {
        return StringUtils.stripPrefix((String)StringUtils.stripSuffix((String)path, (String)UniformPathUtils.SEPARATOR), (String)UniformPathUtils.SEPARATOR);
    }

    @Override
    public Optional<Object> getMetricValueAtCurrentHistoryAccessOption(EvaluatedMetricThreshold threshold) throws StorageException {
        return this.getMetricValue(threshold, this.currentHistoryAccessOption);
    }

    @Override
    public Optional<Object> getMetricValueAtBaselineHistoryAccessOption(EvaluatedMetricThreshold threshold) throws StorageException {
        if (this.baselineHistoryAccessOption == null) {
            return Optional.empty();
        }
        return this.getMetricValue(threshold, this.baselineHistoryAccessOption);
    }

    private Optional<Object> getMetricValue(EvaluatedMetricThreshold threshold, HistoryAccessOption historyAccessOption) throws StorageException {
        String thresholdPath = this.getThresholdPath(threshold);
        Optional<Object> value = this.getMetricValue(threshold.getMetricName(), thresholdPath, threshold.getMetricSchemaSource(), historyAccessOption);
        if (value.isPresent()) {
            return value;
        }
        EMetricSchemaSource differentSchemaSource = EMetricSchemaSource.determineFromSubPath((String)thresholdPath);
        if (differentSchemaSource != threshold.getMetricSchemaSource()) {
            return this.getMetricValue(threshold.getMetricName(), thresholdPath, differentSchemaSource, historyAccessOption);
        }
        return Optional.empty();
    }

    @Override
    public Optional<Object> getMetricValue(String metricName, String uniformPathWithSubPath, EMetricSchemaSource schemaSource, HistoryAccessOption historyAccessOption) throws StorageException {
        return this.getDataRetrieverBySource(schemaSource).getMetricValue(metricName, uniformPathWithSubPath, historyAccessOption);
    }

    @Override
    public Optional<MetricDirectoryEntry> getMetricDirectoryEntry(String uniformPathWithSubPath, EMetricSchemaSource schemaSource, HistoryAccessOption historyAccessOption) throws StorageException {
        return this.getDataRetrieverBySource(schemaSource).getDirectoryEntry(uniformPathWithSubPath, historyAccessOption);
    }
}

