/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.SerializedValueMigratorBase;
import java.io.IOException;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.classes.SerializedFieldBase;
import org.conqat.lib.commons.serialization.classes.SerializedObjectField;
import org.conqat.lib.commons.serialization.objects.SerializedClassValues;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion167ExtractSuperClassOfTgaMethodTreeMapNode
extends SerializedValueMigratorBase {
    private static final String OLD_CLASS_NAME = "com.teamscale.index.testgap.treemap.MethodBasedTreeMapNode";
    private static final String NEW_CLASS_NAME = "com.teamscale.index.testgap.treemap.TgaMethodTreeMapNode";
    private static final String NEW_INTERMEDIATE_CLASS_NAME = "com.teamscale.index.testgap.treemap.MethodTreeMapNodeBase";

    public MigrateVersion167ExtractSuperClassOfTgaMethodTreeMapNode() {
        super(true);
    }

    protected void migrate(SerializedEntityPool entityPool) throws StorageException, IOException, MigrationException {
        SerializedClass oldClass = entityPool.findClass(OLD_CLASS_NAME);
        if (oldClass == null) {
            return;
        }
        List entities = entityPool.getEntities(oldClass);
        for (SerializedObject entity : entities) {
            this.migrateEntity(entity);
        }
        this.migrateClass(entityPool, oldClass);
    }

    private void migrateClass(SerializedEntityPool entityPool, SerializedClass oldClass) {
        SerializedClass intermediateClass = entityPool.getOrCreateClass(NEW_INTERMEDIATE_CLASS_NAME, new SerializedFieldBase[]{new SerializedObjectField("methodName", SerializedObjectField.STRING_TYPE), new SerializedObjectField("region", SerializedObjectField.createJvmNotationFromPlainClassName((String)"org.conqat.lib.commons.region.OffsetBasedRegion"))});
        intermediateClass.setSuperClassHandle(oldClass.getSuperClassHandle());
        oldClass.setSuperClassHandle(intermediateClass.getHandle());
        oldClass.removeField("region");
        oldClass.removeField("methodName");
        entityPool.renameClass(OLD_CLASS_NAME, NEW_CLASS_NAME);
    }

    private void migrateEntity(SerializedObject entity) throws IOException {
        Pair region = entity.getFieldSetAndIndex("region");
        Pair methodName = entity.getFieldSetAndIndex("methodName");
        SerializedClassValues oldFieldSet = entity.getFieldSet(1);
        SerializedClassValues intermediateFieldSet = new SerializedClassValues(2);
        intermediateFieldSet.setValue(0, oldFieldSet.getValue(((Integer)methodName.getSecond()).intValue()));
        intermediateFieldSet.setValue(1, oldFieldSet.getValue(((Integer)region.getSecond()).intValue()));
        oldFieldSet.removeValue(((Integer)region.getSecond()).intValue());
        oldFieldSet.removeValue(((Integer)methodName.getSecond()).intValue());
        entity.addFieldSet(intermediateFieldSet, 1);
    }

    public String getStoreName() {
        return "slide-render-data";
    }

    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V167;
    }

    public EStorageMigratorType getType() {
        return EStorageMigratorType.GLOBAL;
    }
}

