/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.index.migration.ProjectConfigurationHolder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;

public class ProjectVersion42TestGapIntegrationOptionsMigration {
    private static final String TEST_GAP_INTEGRATION_OPTION_NAME = "Enable Test Gap integration for merge requests";
    private static final String TEST_GAP_BADGE_OPTION_NAME = "Enable Test Gap Badges";
    private static final String NEW_FINDINGS_LIMIT_NAME = "Detailed Line Comments Limit for Findings";
    private static final String OLD_FINDINGS_LIMIT_NAME = "Detailed Line Comments Limit";
    private static final Set<String> REPOSITORY_CONNECTOR_TYPES = new HashSet<String>();

    public static String migrate(String json) throws JsonSerializationException {
        ProjectConfigurationHolder holder = (ProjectConfigurationHolder)JsonUtils.deserializeFromJson((String)json, ProjectConfigurationHolder.class);
        holder.connectors.replaceAll(ProjectVersion42TestGapIntegrationOptionsMigration::migrateConnectorConfiguration);
        return JsonUtils.serializeToJSON((Object)holder);
    }

    private static ConnectorConfiguration migrateConnectorConfiguration(ConnectorConfiguration connectorConfiguration) {
        String enableTestGapIntegration;
        if (!REPOSITORY_CONNECTOR_TYPES.contains(connectorConfiguration.getRawType())) {
            return connectorConfiguration;
        }
        String findingsCommentLimit = connectorConfiguration.getOptionValue(OLD_FINDINGS_LIMIT_NAME);
        if (findingsCommentLimit != null) {
            connectorConfiguration.removeOption(OLD_FINDINGS_LIMIT_NAME);
            connectorConfiguration.setOptionValue(NEW_FINDINGS_LIMIT_NAME, findingsCommentLimit);
        }
        if ((enableTestGapIntegration = connectorConfiguration.getOptionValue(TEST_GAP_INTEGRATION_OPTION_NAME)) != null) {
            connectorConfiguration.setOptionValue(TEST_GAP_BADGE_OPTION_NAME, enableTestGapIntegration);
        }
        return connectorConfiguration;
    }

    static {
        REPOSITORY_CONNECTOR_TYPES.addAll((Collection<String>)ERepositoryConnector.getReadableNames());
        REPOSITORY_CONNECTOR_TYPES.add("Bitbucket Server (On-Premise)");
    }
}

