/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.index.migration.ProjectConfigurationHolder;
import java.util.Set;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;

public class ProjectVersion46ABAPDefaultPartitionPatternMigration {
    private static final String PARTITION_PATTERN_OPTION_NAME = "Partition Pattern";
    private static final Set<String> PREVIOUS_DEFAULT_PARTITION_PATTERN_VALUE = Set.of("\\.(sci)$|^coverage/.*([$]).*\\.scov$|^coverage/.*\\.(scov)$", "\\.(sci)$|^coverage/.*\\.(scov)$");

    public static String migrate(String json) throws JsonSerializationException {
        ProjectConfigurationHolder holder = (ProjectConfigurationHolder)JsonUtils.deserializeFromJson((String)json, ProjectConfigurationHolder.class);
        holder.connectors.replaceAll(ProjectVersion46ABAPDefaultPartitionPatternMigration::replacePartitionPatternDefaultValue);
        return JsonUtils.serializeToJSON((Object)holder);
    }

    private static ConnectorConfiguration replacePartitionPatternDefaultValue(ConnectorConfiguration connectorConfiguration) {
        String value = connectorConfiguration.getOptionValue(PARTITION_PATTERN_OPTION_NAME);
        if (value != null && PREVIOUS_DEFAULT_PARTITION_PATTERN_VALUE.contains(value)) {
            connectorConfiguration.setOptionValue(PARTITION_PATTERN_OPTION_NAME, "\\.(sci)$|^coverage/.*([%$]).*\\.scov$|^coverage/.*\\.(scov)$");
        }
        return connectorConfiguration;
    }
}

