/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration.v134_dashboard_creator;

import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.IPointwiseStorageMigrator;
import com.teamscale.index.migration.ClassNameMigrator;
import com.teamscale.index.migration.v116_dashboards.V116EBasicPermissionScope;
import com.teamscale.index.migration.v116_dashboards.V116EBasicRole;
import com.teamscale.index.migration.v116_dashboards.V116EGlobalPermission;
import com.teamscale.index.migration.v116_dashboards.V116EProjectPermission;
import com.teamscale.index.migration.v116_dashboards.V116ESubjectType;
import com.teamscale.index.migration.v116_dashboards.V116GlobalRole;
import com.teamscale.index.migration.v116_dashboards.V116InternalProjectId;
import com.teamscale.index.migration.v116_dashboards.V116ProjectIdBase;
import com.teamscale.index.migration.v116_dashboards.V116ProjectRole;
import com.teamscale.index.migration.v116_dashboards.V116PublicProjectId;
import com.teamscale.index.migration.v116_dashboards.V116RoleBase;
import com.teamscale.index.migration.v116_dashboards.V116SubjectRoleAssignments;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.LZ4Utils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion134PermissionIndex
implements IPointwiseStorageMigrator {
    private static final String DASHBOARD_CREATOR_ROLE = "Dashboard Creator";
    private static final String DASHBOARD_CREATOR_ROLE_KEY = "GLOBAL_ROLE#Dashboard Creator";
    private static final String ROLE_ASSIGNMENTS_KEY_PREFIX = "ROLE_ASSIGNMENTS";
    private final ClassNameMigrator permissionClassNameMigrator = new ClassNameMigrator();

    public MigrateVersion134PermissionIndex() {
        this.permissionClassNameMigrator.registerIntermediateClass("com.teamscale.core.permissions.roles.GlobalRole", V116GlobalRole.class);
        this.permissionClassNameMigrator.registerIntermediateClass("com.teamscale.core.permissions.roles.EGlobalPermission", V116EGlobalPermission.class);
        this.permissionClassNameMigrator.registerIntermediateClass("com.teamscale.core.permissions.roles.EProjectPermission", V116EProjectPermission.class);
        this.permissionClassNameMigrator.registerIntermediateClass("com.teamscale.core.permissions.roles.RoleBase", V116RoleBase.class);
        this.permissionClassNameMigrator.registerIntermediateClass("com.teamscale.core.permissions.SubjectRoleAssignments", V116SubjectRoleAssignments.class);
        this.permissionClassNameMigrator.registerIntermediateClass("com.teamscale.core.permissions.roles.EBasicPermissionScope", V116EBasicPermissionScope.class);
        this.permissionClassNameMigrator.registerIntermediateClass("com.teamscale.core.permissions.roles.EBasicRole", V116EBasicRole.class);
        this.permissionClassNameMigrator.registerIntermediateClass("com.teamscale.core.permissions.roles.ProjectRole", V116ProjectRole.class);
        this.permissionClassNameMigrator.registerIntermediateClass("org.conqat.engine.index.shared.ESubjectType", V116ESubjectType.class);
        this.permissionClassNameMigrator.registerIntermediateClass("org.conqat.engine.index.shared.InternalProjectId", V116InternalProjectId.class);
        this.permissionClassNameMigrator.registerIntermediateClass("org.conqat.engine.index.shared.PublicProjectId", V116PublicProjectId.class);
        this.permissionClassNameMigrator.registerIntermediateClass("org.conqat.engine.index.shared.ProjectIdBase", V116ProjectIdBase.class);
    }

    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V134;
    }

    public EStorageMigratorType getType() {
        return EStorageMigratorType.GLOBAL;
    }

    public String getStoreName() {
        return "permissions";
    }

    public PairList<byte[], byte[]> migrate(byte[] key, byte[] value) throws StorageException {
        String stringKey = StringUtils.bytesToString((byte[])key);
        if (DASHBOARD_CREATOR_ROLE_KEY.equals(stringKey)) {
            return null;
        }
        if (stringKey.startsWith("GLOBAL_ROLE")) {
            V116GlobalRole globalRole = (V116GlobalRole)this.permissionClassNameMigrator.deserialize(LZ4Utils.decompress((byte[])value));
            globalRole.removePermission(V116EGlobalPermission.CREATE_DASHBOARDS);
            return PairList.from((Object)key, (Object)LZ4Utils.compress((byte[])this.permissionClassNameMigrator.serialize(globalRole)));
        }
        if (stringKey.startsWith(ROLE_ASSIGNMENTS_KEY_PREFIX)) {
            V116SubjectRoleAssignments assignment = (V116SubjectRoleAssignments)this.permissionClassNameMigrator.deserialize(LZ4Utils.decompress((byte[])value));
            assignment.removeGlobalRole(DASHBOARD_CREATOR_ROLE);
            boolean hadDashboardAdminRights = assignment.getGlobalRoleNames().contains("Instance Admin");
            if (hadDashboardAdminRights) {
                assignment.addGlobalBasicRole(V116EBasicPermissionScope.DASHBOARDS, V116EBasicRole.OWNER);
                assignment.addGlobalBasicRole(V116EBasicPermissionScope.DASHBOARD_TEMPLATES, V116EBasicRole.OWNER);
            }
            return PairList.from((Object)key, (Object)LZ4Utils.compress((byte[])this.permissionClassNameMigrator.serialize(assignment)));
        }
        return PairList.from((Object)key, (Object)value);
    }
}

