/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration.v187_github_allowed_organizations;

import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.IMultiStoreMigrator;
import com.teamscale.index.migration.ClassNameMigrator;
import com.teamscale.index.migration.v187_github_allowed_organizations.V187GitHubApplicationDescription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.LZ4Utils;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;
import org.jspecify.annotations.NonNull;

@ThreadSafe
public class MigrateVersion187GitHubAllowedOrgsForSso
implements IMultiStoreMigrator {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String SERVER_OPTIONS_STORE_NAME = "server-options";
    private static final String GITHUB_INSTALLATIONS_STORE_NAME = "github-installations";
    private static final String GITHUB_APPLICATION_OPTION_KEY = "server:auth.github.application";
    private static final char URL_TO_ORGANIZATION_SEPARATOR = '#';
    private final ClassNameMigrator classNameMigrator = new ClassNameMigrator();

    public MigrateVersion187GitHubAllowedOrgsForSso() {
        this.classNameMigrator.registerIntermediateClass("com.teamscale.core.authenticate.github.GitHubApplicationDescription", V187GitHubApplicationDescription.class);
    }

    public Set<String> getInputStoreNames() {
        return Set.of(SERVER_OPTIONS_STORE_NAME, GITHUB_INSTALLATIONS_STORE_NAME);
    }

    public Set<String> getOutputStoreNames() {
        return Set.of(SERVER_OPTIONS_STORE_NAME);
    }

    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V187;
    }

    public EStorageMigratorType getType() {
        return EStorageMigratorType.GLOBAL;
    }

    public void migrate(Map<String, IStore> inputStoresByName, Map<String, IStore> outputStoresByName) throws StorageException {
        IStore githubInstallationsStore = inputStoresByName.get(GITHUB_INSTALLATIONS_STORE_NAME);
        IStore serverOptionsStore = inputStoresByName.get(SERVER_OPTIONS_STORE_NAME);
        IStore outputServerOptionsStore = outputStoresByName.get(SERVER_OPTIONS_STORE_NAME);
        StorageUtils.copyStore((IStore)serverOptionsStore, (IStore)outputServerOptionsStore);
        Map<String, Collection<String>> currentlyAllowedOrganizationsByApplication = MigrateVersion187GitHubAllowedOrgsForSso.getCurrentlyAllowedOrganizationsByApplication(githubInstallationsStore);
        Map<byte[], V187GitHubApplicationDescription> gitHubApplicationsByServerOptionsKey = this.readGitHubApplicationsByServerOptionsKey(serverOptionsStore);
        this.updateGitHubApplications(gitHubApplicationsByServerOptionsKey, currentlyAllowedOrganizationsByApplication, outputServerOptionsStore);
    }

    private void updateGitHubApplications(Map<byte[], V187GitHubApplicationDescription> gitHubApplicationsByServerOptionsKey, Map<String, Collection<String>> currentlyAllowedOrganizationsByApplication, IStore outputServerOptionsStore) throws StorageException {
        for (Map.Entry<byte[], V187GitHubApplicationDescription> entry : gitHubApplicationsByServerOptionsKey.entrySet()) {
            V187GitHubApplicationDescription gitHubApplicationDescription = entry.getValue();
            if (!gitHubApplicationDescription.getAllowedOrganizations().isEmpty()) continue;
            Collection<String> allowedOrganizations = currentlyAllowedOrganizationsByApplication.get(gitHubApplicationDescription.getAppId());
            if (CollectionUtils.isNullOrEmpty(allowedOrganizations)) {
                LOGGER.warn("No organizations found for application with id {}. The \"Allowed Organizations for SSO\" will remain empty which will prevent user from logging in from now on. To resolve this issue, add all allowed organizations manually in Admin > Settings > GitHub Integration > Your GitHub App", (Object)gitHubApplicationDescription.getAppId());
            }
            gitHubApplicationDescription.setAllowedOrganizations(allowedOrganizations);
            outputServerOptionsStore.put(entry.getKey(), LZ4Utils.compress((byte[])this.classNameMigrator.serialize(gitHubApplicationDescription)));
        }
    }

    private @NonNull Map<byte[], V187GitHubApplicationDescription> readGitHubApplicationsByServerOptionsKey(IStore serverOptionsStore) throws StorageException {
        ArrayList values = new ArrayList();
        ArrayList keys = new ArrayList();
        serverOptionsStore.scan(StringUtils.stringToBytes((String)GITHUB_APPLICATION_OPTION_KEY), (key, value) -> {
            keys.add(key);
            values.add(value);
        });
        return CollectionUtils.zipAsMap(keys, (SequencedCollection)CollectionUtils.mapWithException(values, bytes -> (V187GitHubApplicationDescription)this.classNameMigrator.deserialize(LZ4Utils.decompress((byte[])bytes))));
    }

    private static @NonNull Map<String, Collection<String>> getCurrentlyAllowedOrganizationsByApplication(IStore githubInstallationsStore) throws StorageException {
        Map<String, TreeSet<Long>> organizationToInstallation = MigrateVersion187GitHubAllowedOrgsForSso.readOrganizationToInstallationFromStore(githubInstallationsStore);
        Map installationToOrganization = CollectionUtils.inverseMap(organizationToInstallation, HashMap::new, TreeSet::new);
        Map<String, Collection<Long>> appToInstallation = MigrateVersion187GitHubAllowedOrgsForSso.readAppToInstallationFromStore(githubInstallationsStore);
        return CollectionUtils.calculateTransitiveMap(appToInstallation, (Map)installationToOrganization, HashMap::new, TreeSet::new);
    }

    private static @NonNull Map<String, Collection<Long>> readAppToInstallationFromStore(IStore githubInstallationsStore) throws StorageException {
        String installationToAppPrefix = "i2a:";
        ArrayList keys = new ArrayList();
        ArrayList values = new ArrayList();
        githubInstallationsStore.scan(StringUtils.stringToBytes((String)installationToAppPrefix), (key, value) -> {
            keys.add(StringUtils.stripPrefix((String)StringUtils.bytesToString((byte[])key), (String)installationToAppPrefix));
            values.add(value);
        });
        List<List> appIds = CollectionUtils.mapWithException(values, ByteArrayUtils::byteArrayToLong).stream().map(Object::toString).map(List::of).toList();
        List<Long> installations = keys.stream().map(Long::parseLong).toList();
        Map installationToApp = CollectionUtils.zipAsMap(installations, appIds);
        return CollectionUtils.inverseMap((Map)installationToApp, HashMap::new, TreeSet::new);
    }

    private static @NonNull Map<String, TreeSet<Long>> readOrganizationToInstallationFromStore(IStore githubInstallationsStore) throws StorageException {
        HashMap<String, TreeSet<Long>> organizationsToInstallation = new HashMap<String, TreeSet<Long>>();
        String organizationsToInstallationsPrefix = "o2i:";
        githubInstallationsStore.scan(StringUtils.stringToBytes((String)organizationsToInstallationsPrefix), (key, value) -> {
            String urlAndOrganization = StringUtils.stripPrefix((String)StringUtils.bytesToString((byte[])key), (String)organizationsToInstallationsPrefix);
            String organization = (String)StringUtils.splitAtLast((String)urlAndOrganization, (char)'#').getSecond();
            organizationsToInstallation.put(organization, MigrateVersion187GitHubAllowedOrgsForSso.deserializeGitHubInstallationIds(value));
        });
        return organizationsToInstallation;
    }

    private static TreeSet<Long> deserializeGitHubInstallationIds(byte[] bytes) {
        if (bytes == null) {
            return new TreeSet<Long>();
        }
        ArrayList<Long> result = new ArrayList<Long>();
        for (int i = 0; i < bytes.length; i += 8) {
            result.add(ByteArrayUtils.getLongFromByteArray((byte[])bytes, (int)i));
        }
        return new TreeSet<Long>(result);
    }
}

