/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration.v88_project_alias;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfiguration;
import com.teamscale.index.migration.v88_project_alias.V89CommitGranularityConfiguration;
import com.teamscale.index.migration.v88_project_alias.V89ProjectConfigurationMigrated;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.index.shared.ProjectIdBase;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.Nullable;

public class V89ProjectConfigurationUnmigrated
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String NAME_PROPERTY = "name";
    private static final String ID_PROPERTY = "id";
    private static final String ALIAS_PROPERTY = "alias";
    private static final String ALIASES_PROPERTY = "aliases";
    private static final String PARENT_PROJECT_ID_PROPERTY = "parentProjectId";
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String PROFILE_PROPERTY = "profile";
    private static final String EMBEDDED_PROFILE_PROPERTY = "embeddedProfile";
    private static final String METRIC_THRESHOLD_CONFIGURATION_PROPERTY = "metricThresholdConfiguration";
    private static final String ANALYSIS_GRANULARITY_PROPERTY = "analysisGranularity";
    private static final String CONNECTORS_PROPERTY = "connectors";
    @JsonProperty(value="name")
    String name;
    @JsonProperty(value="id")
    public String id;
    @JsonProperty(value="alias")
    @Nullable String alias;
    @JsonProperty(value="aliases")
    @Nullable List<String> aliases;
    @JsonProperty(value="parentProjectId")
    @Nullable String parentProjectId;
    @JsonProperty(value="description")
    @Nullable String description;
    @JsonProperty(value="profile")
    String profile;
    @JsonProperty(value="embeddedProfile")
    @Nullable AnalysisProfile embeddedProfile;
    @JsonProperty(value="metricThresholdConfiguration")
    @Nullable MetricThresholdConfiguration metricThresholdConfiguration;
    @JsonProperty(value="analysisGranularity")
    @Nullable V89CommitGranularityConfiguration analysisGranularity;
    @JsonProperty(value="connectors")
    List<ConnectorConfiguration> connectors = new ArrayList<ConnectorConfiguration>();

    @JsonCreator
    public V89ProjectConfigurationUnmigrated(@JsonProperty(value="name") String name, @JsonProperty(value="id") String id, @JsonProperty(value="profile") String profile) {
        this.name = name;
        this.id = id;
        this.profile = profile;
    }

    public V89ProjectConfigurationUnmigrated(V89ProjectConfigurationMigrated migrated) {
        this.name = migrated.name;
        this.id = migrated.internalId.toString();
        this.alias = migrated.publicIds.get(0).toString();
        this.aliases = CollectionUtils.map(migrated.publicIds, ProjectIdBase::toString);
        this.parentProjectId = Optional.ofNullable(migrated.parentProjectId).map(ProjectIdBase::toString).orElse(null);
        this.description = migrated.description;
        this.profile = migrated.profile;
        this.embeddedProfile = migrated.embeddedProfile;
        this.metricThresholdConfiguration = migrated.metricThresholdConfiguration;
        this.analysisGranularity = migrated.analysisGranularity;
        this.connectors.addAll(migrated.connectors);
    }
}

