/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.naming;

import com.teamscale.index.naming.CLikeNamingConventionAnalyzer;
import com.teamscale.index.naming.ENamingConventionTokenClass;
import com.teamscale.index.naming.NamingConventionGroup;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class JavaNamingConventionAnalyzer
extends CLikeNamingConventionAnalyzer {
    public JavaNamingConventionAnalyzer() {
        super(ELanguage.JAVA);
    }

    @Override
    protected void checkAttribute(TokenElementInfo element, ShallowEntity entity) {
        if (this.isConstant(entity) && "serialVersionUID".equals(entity.getName())) {
            return;
        }
        super.checkAttribute(element, entity);
    }

    @Override
    protected boolean isConstant(ShallowEntity entity) {
        return LanguageFeatureParser.JAVA.isConstant(entity);
    }

    @Override
    protected Set<String> getExcludedMethodSubTypes() {
        return Set.of("static initializer", "non-static initializer");
    }

    @Override
    protected void checkMeta(TokenElementInfo element, ShallowEntity entity) {
        if (entity.getSubtype().equalsIgnoreCase(ETokenType.PACKAGE.name())) {
            this.checkEntityWithGivenName(element, entity, JavaNamingConventionAnalyzer.extractJavaPackageName(entity), NamingConventionGroup.create(this.language, ENamingConventionTokenClass.MODULES));
        }
    }

    private static String extractJavaPackageName(ShallowEntity entity) {
        return entity.includedTokens().stream().filter(arg_0 -> ((ETokenType)ETokenType.IDENTIFIER).matches(arg_0)).map(IToken::getText).collect(Collectors.joining("."));
    }

    @Override
    protected boolean isOverride(ShallowEntity entity) {
        List annotations = LanguageFeatureParser.JAVA.getAnnotations(entity);
        for (ShallowEntity annotation : annotations) {
            if (!"Override".equals(annotation.getName())) continue;
            return true;
        }
        return false;
    }
}

