/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.notifications.metrics;

import com.teamscale.index.notifications.NotificationContext;
import com.teamscale.index.notifications.NotificationMailHelperBase;
import com.teamscale.index.notifications.NotificationThresholdViolationInfo;
import com.teamscale.index.notifications.metrics.MetricNotificationRule;
import com.teamscale.index.notifications.metrics.MetricNotificationRuleToViolationInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.html.EHTMLElement;
import org.conqat.lib.commons.html.HTMLWriter;

public class MetricNotificationMailHelper
extends NotificationMailHelperBase {
    public MetricNotificationMailHelper(NotificationContext notificationContext) throws StorageException {
        super(notificationContext);
    }

    public String buildSubject() {
        StringWriter stringWriter = new StringWriter();
        HTMLWriter writer = new HTMLWriter(new PrintWriter(stringWriter));
        writer.addText("Your Teamscale notification rules matched for commit ");
        writer.addText(this.notificationContext.getRepositoryLogEntry().getRevision());
        writer.addText(" (Project: " + this.getProjectReadableName() + ")");
        writer.close();
        return stringWriter.toString();
    }

    public String buildContent(List<MetricNotificationRuleToViolationInfo> rulesToInfos) {
        StringWriter stringWriter = new StringWriter();
        HTMLWriter writer = new HTMLWriter(new PrintWriter(stringWriter));
        this.appendMailContent(writer, rulesToInfos);
        writer.close();
        return stringWriter.toString();
    }

    private void appendMailContent(HTMLWriter writer, List<MetricNotificationRuleToViolationInfo> rulesToInfos) {
        writer.addClosedTextElement((Enum)EHTMLElement.H3, "Metric Threshold Violation", new Object[0]);
        this.appendCommitInformation(writer);
        writer.addClosedElement((Enum)EHTMLElement.BR, new Object[0]);
        MetricNotificationMailHelper.appendRulesBlock(writer, rulesToInfos);
        writer.addClosedElement((Enum)EHTMLElement.BR, new Object[0]);
        writer.addClosedElement((Enum)EHTMLElement.BR, new Object[0]);
        this.appendViewCommitInTeamscaleText(writer);
    }

    private static void appendRulesBlock(HTMLWriter writer, List<MetricNotificationRuleToViolationInfo> rulesToInfos) {
        writer.addText("The following rules applied: ");
        writer.openElement((Enum)EHTMLElement.UL);
        for (MetricNotificationRuleToViolationInfo ruleToInfo : rulesToInfos) {
            MetricNotificationMailHelper.appendRuleSummary(writer, ruleToInfo);
        }
        writer.closeElement((Enum)EHTMLElement.UL);
    }

    private static void appendRuleSummary(HTMLWriter writer, MetricNotificationRuleToViolationInfo ruleToInfo) {
        MetricNotificationRule rule = ruleToInfo.getRule();
        NotificationThresholdViolationInfo info = ruleToInfo.getInfo();
        writer.openElement((Enum)EHTMLElement.LI);
        writer.addText(rule.getRuleName() + ": ");
        writer.addText("Violation of threshold ");
        writer.addText("'" + info.getCurrentThreshold().toString() + "'");
        writer.addText(" (" + rule.getMetricName() + ")");
        writer.addClosedElement((Enum)EHTMLElement.BR, new Object[0]);
        Double oldValue = info.getPreviousValue();
        if (oldValue != null) {
            writer.addText("Old value: ");
            writer.addClosedTextElement((Enum)EHTMLElement.B, oldValue.toString(), new Object[0]);
            writer.addText(". ");
        }
        writer.addText("Current value: ");
        writer.addClosedTextElement((Enum)EHTMLElement.B, info.getCurrentValue().toString(), new Object[0]);
        writer.addText(".");
        writer.closeElement((Enum)EHTMLElement.LI);
    }
}

