/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.notifications.project;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.index.model.EThresholdEvaluationOption;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfigurationException;
import com.teamscale.core.user.User;
import com.teamscale.index.notifications.ENotificationThresholdType;
import com.teamscale.index.notifications.INotificationRule;
import com.teamscale.index.notifications.InvalidNotificationRuleException;
import com.teamscale.index.notifications.NotificationContext;
import com.teamscale.index.notifications.NotificationThresholdViolationChecker;
import com.teamscale.index.notifications.NotificationThresholdViolationInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.ProjectIdBase;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;

@IndexValueClass(containedInBackup=true)
public class ProjectNotificationRule
implements INotificationRule,
Serializable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 1L;
    protected static final String RULE_NAME_PROPERTY = "ruleName";
    protected static final String PROJECT_NAMES_PROPERTY = "projectNames";
    protected static final String METRIC_DISPLAY_NAME_PROPERTY = "metricDisplayName";
    protected static final String THRESHOLD_VALUE_PROPERTY = "thresholdValue";
    protected static final String TYPE_PROPERTY = "type";
    protected static final String RECIPIENT_USERS_PROPERTY = "recipientUsers";
    protected static final String RECIPIENT_GROUPS_PROPERTY = "recipientGroups";
    protected static final String CURRENT_USER_PROPERTY = "currentUser";
    @JsonProperty(value="ruleName")
    private final String ruleName;
    @JsonProperty(value="projectNames")
    private final Set<String> projectNames;
    @JsonProperty(value="metricDisplayName")
    private final String metricDisplayName;
    @JsonProperty(value="thresholdValue")
    private final Double thresholdValue;
    @JsonProperty(value="type")
    private final ENotificationThresholdType type;
    @JsonProperty(value="recipientUsers")
    private final List<String> recipientUsers;
    @JsonProperty(value="recipientGroups")
    private final List<String> recipientGroups;
    @JsonProperty(value="currentUser")
    protected final User currentUser;

    @JsonCreator
    protected ProjectNotificationRule(@JsonProperty(value="ruleName") String ruleName, @JsonProperty(value="projectNames") Set<String> projectNames, @JsonProperty(value="metricDisplayName") String metricDisplayName, @JsonProperty(value="thresholdValue") Double thresholdValue, @JsonProperty(value="type") ENotificationThresholdType type, @JsonProperty(value="recipientUsers") List<String> recipientUsers, @JsonProperty(value="recipientGroups") List<String> recipientGroups, @JsonProperty(value="currentUser") User currentUser) {
        this.ruleName = ruleName;
        this.projectNames = projectNames;
        this.metricDisplayName = metricDisplayName;
        this.thresholdValue = thresholdValue;
        this.type = type;
        this.recipientUsers = recipientUsers;
        this.recipientGroups = recipientGroups;
        this.currentUser = currentUser;
    }

    public NotificationThresholdViolationInfo matches(NotificationContext notificationContext) throws StorageException, InvalidNotificationRuleException, MetricThresholdConfigurationException {
        if (!this.matchesProject(notificationContext)) {
            LOGGER.debug("The project {} does not match rule {}", (Object)notificationContext.getInternalId(), (Object)this.ruleName);
            return NotificationThresholdViolationInfo.createNoMatchInfo();
        }
        return this.doesViolateThreshold(notificationContext);
    }

    protected NotificationThresholdViolationInfo doesViolateThreshold(NotificationContext notificationContext) throws StorageException, InvalidNotificationRuleException, MetricThresholdConfigurationException {
        NotificationThresholdViolationChecker checker = this.createNotificationThresholdViolationChecker(this.getMetricDisplayName(), "", notificationContext, new HashSet<EThresholdEvaluationOption>(), this.currentUser);
        return checker.doesViolateConstantThreshold(this.thresholdValue, this.type);
    }

    protected NotificationThresholdViolationChecker createNotificationThresholdViolationChecker(String metricName, String subPath, NotificationContext notificationContext, Set<EThresholdEvaluationOption> evaluationOptions, User currentUser) throws StorageException, MetricThresholdConfigurationException {
        return new NotificationThresholdViolationChecker(metricName, subPath, notificationContext, evaluationOptions, currentUser);
    }

    protected boolean matchesProject(NotificationContext notificationContext) {
        return this.getProjectNames().isEmpty() || !CollectionUtils.intersectionSet((Collection)CollectionUtils.map(notificationContext.getPublicIds(), ProjectIdBase::toString), (Collection[])new Collection[]{this.getProjectNames()}).isEmpty();
    }

    public void checkValidity() throws InvalidNotificationRuleException {
        if (this.getMetricDisplayName() == null) {
            throw new InvalidNotificationRuleException(this, "The metric name must not be empty.");
        }
        if (this.getType() == ENotificationThresholdType.VALUE && this.getThresholdValue() == null) {
            throw new InvalidNotificationRuleException(this, "The rule must provide a threshold value or an assessment color.");
        }
        if (this.getRecipientGroups() == null || this.getRecipientUsers() == null) {
            throw new InvalidNotificationRuleException(this, "The recipients lists must at least be initialized.");
        }
    }

    public UnmodifiableSet<String> getProjectNames() {
        return CollectionUtils.asUnmodifiable(this.projectNames);
    }

    public String getMetricDisplayName() {
        return this.metricDisplayName;
    }

    public Double getThresholdValue() {
        return this.thresholdValue;
    }

    public List<String> getRecipientUsers() {
        return this.recipientUsers;
    }

    public List<String> getRecipientGroups() {
        return this.recipientGroups;
    }

    public ENotificationThresholdType getType() {
        return this.type;
    }

    @VisibleForTesting
    public User getCurrentUser() {
        return this.currentUser;
    }

    @Override
    public String getRuleName() {
        return this.ruleName;
    }
}

