/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.portfolio;

import com.teamscale.index.portfolio.QualityGoalManualAssessment;
import java.util.List;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.Nullable;

@Index(name="portfolio-manual-assessments", options={EStorageOption.COMPRESSED, EStorageOption.BACKUP, EStorageOption.NO_ROLLBACK})
public class PortfolioManualAssessmentIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "portfolio-manual-assessments";
    private static final String SELECTED_MANUAL_ASSESSMENT_KEY = "selected-manual-assessment-key";
    private final ValueIndex<QualityGoalManualAssessment> delegate;

    public PortfolioManualAssessmentIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public @Nullable QualityGoalManualAssessment getSelectedManualAssessment() throws StorageException {
        return (QualityGoalManualAssessment)this.delegate.getValue(SELECTED_MANUAL_ASSESSMENT_KEY);
    }

    public void setSelectedManualAssessment(@Nullable QualityGoalManualAssessment selected) throws StorageException {
        if (selected == null) {
            this.delegate.removeValue(SELECTED_MANUAL_ASSESSMENT_KEY);
        } else {
            this.delegate.setValue(SELECTED_MANUAL_ASSESSMENT_KEY, (Object)selected);
        }
    }

    public @Nullable List<QualityGoalManualAssessment> getAllAssessments() throws StorageException {
        List<String> keys = this.delegate.getAllKeys().stream().filter(key -> !SELECTED_MANUAL_ASSESSMENT_KEY.equals(key)).toList();
        return this.delegate.getValues(keys);
    }

    public void addAssessment(QualityGoalManualAssessment manualAssessment) throws StorageException {
        this.delegate.setValue(String.valueOf(manualAssessment.getCreatedAt()), (Object)manualAssessment);
        this.setSelectedManualAssessment(manualAssessment);
    }

    public void removeAssessment(QualityGoalManualAssessment manualAssessment) throws StorageException {
        this.delegate.removeValue(String.valueOf(manualAssessment.getCreatedAt()));
        QualityGoalManualAssessment selectedAssessment = this.getSelectedManualAssessment();
        if (selectedAssessment != null && selectedAssessment.createdAt == manualAssessment.getCreatedAt()) {
            this.delegate.removeValue(SELECTED_MANUAL_ASSESSMENT_KEY);
        }
    }
}

