/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.quality_report;

import com.teamscale.index.quality_report.QualityArtifactIndexBase;
import com.teamscale.index.quality_report.QualityReport;
import com.teamscale.index.quality_report.ReportSlideBase;
import java.util.HashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.jspecify.annotations.NonNull;

@Index(name="quality-reports-index", options={EStorageOption.BACKUP, EStorageOption.ENCRYPTED})
public class QualityReportsIndex
extends QualityArtifactIndexBase<QualityReport>
implements IGlobalIndex {
    public static final String INDEX_NAME = "quality-reports-index";
    private static final Logger LOGGER = LogManager.getLogger();

    public QualityReportsIndex(IStore store) {
        super(store);
    }

    private static QualityReport ensureUniqueSlideIdsInReport(@NonNull QualityReport report) {
        HashSet<String> ids = new HashSet<String>();
        int idCounter = 1;
        for (ReportSlideBase slide : report.getSlides()) {
            if (ids.contains(slide.getId())) {
                String newId;
                while (ids.contains(newId = "id-" + idCounter++)) {
                }
                LOGGER.warn("Found duplicate slide ids in report '" + report.getMetaInfo().getName() + "'. Duplicate slide id '" + slide.getId() + "' will be replaced with '" + newId + "'.");
                slide.setId(newId);
            }
            ids.add(slide.getId());
        }
        return report;
    }

    @Override
    public QualityReport getById(String id) throws StorageException {
        QualityReport report = (QualityReport)super.getById(id);
        if (report == null) {
            return null;
        }
        return QualityReportsIndex.ensureUniqueSlideIdsInReport(report);
    }

    public PairList<String, QualityReport> getAllQualityReports() throws StorageException {
        PairList reports = super.getAllQualityArtifacts();
        for (Pair report : reports) {
            report.setSecond((Object)QualityReportsIndex.ensureUniqueSlideIdsInReport((QualityReport)report.getSecond()));
        }
        return reports;
    }
}

