/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.quality_report.slides;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.findings.calculation.BasicFindingsFilterSettings;
import com.teamscale.index.findings.calculation.FindingDeltaCount;
import com.teamscale.index.findings.calculation.FindingDeltaFilterUtils;
import com.teamscale.index.findings.calculation.FindingsCalculationInfo;
import com.teamscale.index.quality_report.slides.ISlideComment;
import com.teamscale.index.quality_report.slides.ProjectBranchPath;
import com.teamscale.index.quality_report.slides.SlideCommentRenderData;
import com.teamscale.index.quality_report.slides.SlideFindingBadgeRenderData;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public record BadgeSlideComment(@JsonProperty(value="findingFilter") BasicFindingsFilterSettings findingFilter, @JsonProperty(value="showUnresolvedFindings") boolean showUnresolvedFindings) implements ISlideComment
{
    private static final long serialVersionUID = 1L;

    @Override
    public SlideCommentRenderData calculateRenderData(IndexLayer indexLayer, ProjectBranchPath projectBranchPath, CommitDescriptor start, CommitDescriptor end) throws StorageException {
        PublicProjectId projectId = projectBranchPath.getProjectId();
        FindingsCalculationInfo calculationInfo = new FindingsCalculationInfo(projectId, (ProjectStorageSystem)indexLayer.openProjectStorageSystem((IProjectId)projectId), indexLayer);
        FindingDeltaCount delta = FindingDeltaFilterUtils.calculateFindingDeltaCountForPath(start, end, this.findingFilter, projectBranchPath.getPath(), calculationInfo);
        SlideFindingBadgeRenderData badgeRenderData = new SlideFindingBadgeRenderData(delta.addedFindings(), delta.findingsInChangedCode(), delta.removedFindings());
        return new SlideCommentRenderData(this, badgeRenderData);
    }
}

