/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.quality_report.slides;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.index.quality_report.ReportSlideBase;
import com.teamscale.index.quality_report.SlideRenderDataBase;
import com.teamscale.index.quality_report.slides.EReportSlide;
import com.teamscale.index.quality_report.slides.ESlideOptionType;
import com.teamscale.index.quality_report.slides.ISlideComment;
import com.teamscale.index.quality_report.slides.ProjectBranchPath;
import com.teamscale.index.quality_report.slides.SlideCommentRenderData;
import com.teamscale.index.quality_report.slides.SlideParameter;
import com.teamscale.index.quality_report.slides.SlideParametersBase;
import com.teamscale.index.quality_report.slides.TrendChartMetric;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.index.baseline.BaselineInfo;
import org.conqat.engine.index.baseline.FrequencyData;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass(containedInBackup=true)
public class MetricTrendChartSlide
extends ReportSlideBase<MetricTrendChartSlideParameters, TrendChartSlideResult> {
    private static final long serialVersionUID = 1L;

    @Override
    public EReportSlide getSlideType() {
        return EReportSlide.METRIC_TREND;
    }

    @IndexValueClass(containedInBackup=true)
    public static class SingleTrendResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="metricName")
        private String metricName;
        @JsonProperty(value="metricTimestamps")
        private List<Long> metricTimestamps;
        @JsonProperty(value="metricValues")
        @Schema(implementation=MetricDirectoryEntry.MetricValues.class)
        private List<Object> metricValues;
        @JsonProperty(value="metricColor")
        private @Nullable String metricColor;
        @JsonProperty(value="metricPercentages")
        private @Nullable List<FrequencyData> metricPercentages;
        @JsonProperty(value="projectBaselines")
        private @Nullable List<BaselineInfo> projectBaselines;

        @JsonCreator
        public SingleTrendResult(@JsonProperty(value="metricName") String metricName, @JsonProperty(value="metricTimestamps") List<Long> metricTimestamps, @JsonProperty(value="metricValues") List<Object> metricValues, @JsonProperty(value="metricColor") @Nullable String metricColor, @JsonProperty(value="metricPercentages") @Nullable List<FrequencyData> metricPercentages, @JsonProperty(value="projectBaselines") @Nullable List<BaselineInfo> projectBaselines) {
            this.metricName = metricName;
            this.metricTimestamps = metricTimestamps;
            this.metricValues = metricValues;
            this.metricColor = metricColor;
            this.metricPercentages = metricPercentages;
            this.projectBaselines = projectBaselines;
        }

        public @Nullable String getMetricColor() {
            return this.metricColor;
        }

        public @Nullable List<BaselineInfo> getProjectBaselines() {
            return this.projectBaselines;
        }

        public @Nullable List<FrequencyData> getMetricPercentages() {
            return this.metricPercentages;
        }
    }

    @IndexValueClass(containedInBackup=true)
    public static class TrendChartSlideResult
    extends SlideRenderDataBase {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="trendHistory")
        private List<SingleTrendResult> trendHistory;
        @JsonProperty(value="comments")
        private List<SlideCommentRenderData> comments;

        @JsonCreator
        public TrendChartSlideResult(@JsonProperty(value="trendHistory") List<SingleTrendResult> trendHistory, @JsonProperty(value="comments") List<SlideCommentRenderData> comments) {
            this.trendHistory = trendHistory;
            this.comments = comments;
        }

        public List<SingleTrendResult> getTrendHistory() {
            return this.trendHistory;
        }

        public List<SlideCommentRenderData> getComments() {
            return this.comments;
        }
    }

    @IndexValueClass(containedInBackup=true)
    public static class MetricTrendChartSlideParameters
    extends SlideParametersBase {
        private static final long serialVersionUID = 1L;
        @SlideParameter(formattedName="Project, Branch & Path", type=ESlideOptionType.PROJECT_BRANCH_PATH)
        @JsonProperty(value="projectBranchPath")
        private ProjectBranchPath projectBranchPath;
        @SlideParameter(formattedName="Title", inputHint="Markdown supported", type=ESlideOptionType.STRING)
        @JsonProperty(value="slideTitle")
        private String slideTitle;
        @SlideParameter(formattedName="Metric(s)", inputHint="Select one or more", type=ESlideOptionType.TREND_CHART_METRIC)
        @JsonProperty(value="slideMetrics")
        private List<TrendChartMetric> slideMetrics;
        @SlideParameter(formattedName="Comments", inputHint="Markdown supported", type=ESlideOptionType.COMMENTS)
        @JsonProperty(value="comments")
        private List<ISlideComment> comments;

        @JsonCreator
        MetricTrendChartSlideParameters() {
        }

        public ProjectBranchPath getProjectBranchPath() {
            return this.projectBranchPath;
        }

        @Override
        public List<PublicProjectId> getReferencedProjects() {
            if (this.projectBranchPath == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(this.projectBranchPath.getProjectId());
        }

        public List<TrendChartMetric> getSlideMetrics() {
            return this.slideMetrics;
        }

        public List<String> getMetricNames() {
            return CollectionUtils.map(this.slideMetrics, TrendChartMetric::getName);
        }

        public String getSlideTitle() {
            return this.slideTitle;
        }

        public List<ISlideComment> getComments() {
            return this.comments;
        }
    }
}

