/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.quality_report.slides;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Objects;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.Nullable;

@IndexValueClass(containedInBackup=true)
public class ProjectBranchPath
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String PROPERTY_PROJECT = "projectOrAlias";
    private static final String PROPERTY_PATH = "path";
    private static final String PROPERTY_BRANCH = "branch";
    @JsonProperty(value="projectOrAlias")
    private final @Nullable String projectOrAlias;
    @JsonProperty(value="path")
    private final String path;
    private transient UniformPath parsedPath;
    @JsonProperty(value="branch")
    private final @Nullable String branch;

    @JsonCreator
    public ProjectBranchPath(@JsonProperty(value="projectOrAlias") @Nullable String projectOrAlias, @JsonProperty(value="path") UniformPath path, @JsonProperty(value="branch") @Nullable String branch) {
        this.projectOrAlias = projectOrAlias;
        this.path = path.toString();
        this.parsedPath = path;
        this.branch = branch;
    }

    public PublicProjectId getProjectId() {
        if (StringUtils.isEmpty((String)this.projectOrAlias)) {
            return null;
        }
        return new PublicProjectId(this.projectOrAlias);
    }

    public UniformPath getPath() {
        UniformPath tmp = this.parsedPath;
        if (tmp == null) {
            this.parsedPath = tmp = UniformPath.parse((String)this.path);
        }
        return tmp;
    }

    public @Nullable String getBranch() {
        return this.branch;
    }

    public int hashCode() {
        return Objects.hash(this.projectOrAlias, this.path, this.branch);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ProjectBranchPath)) {
            return false;
        }
        ProjectBranchPath other = (ProjectBranchPath)obj;
        return Objects.equals(this.projectOrAlias, other.projectOrAlias) && Objects.equals(this.path, other.path) && Objects.equals(this.branch, other.branch);
    }
}

