/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.query;

import com.teamscale.index.query.StoredQueryDescriptor;
import com.teamscale.index.query.StoredQueryIndex;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.persistence.index.keyed.query.error.QueryParsingException;
import org.conqat.engine.persistence.index.keyed.query.lexer.EQueryTokenType;
import org.conqat.engine.persistence.index.keyed.query.lexer.IQueryPreprocessor;
import org.conqat.engine.persistence.index.keyed.query.lexer.QueryLexer;
import org.conqat.engine.persistence.index.keyed.query.lexer.QueryToken;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.NonNull;

public class QueryReferencePreprocessor
implements IQueryPreprocessor {
    private static final String QUERY_REFERENCE_KEYWORD = "query";
    private final StoredQueryIndex queryIndex;

    public QueryReferencePreprocessor(StoredQueryIndex queryIndex) {
        this.queryIndex = queryIndex;
    }

    public List<QueryToken> preprocessQuery(List<QueryToken> tokens) throws QueryParsingException {
        return this.preprocessQuery(tokens, new HashSet<String>());
    }

    private List<QueryToken> preprocessQuery(List<QueryToken> tokens, Set<String> encounteredValues) throws QueryParsingException {
        ArrayList<QueryToken> result = new ArrayList<QueryToken>();
        for (int i = 0; i < tokens.size(); ++i) {
            boolean isInSubQuery = i > 0 && EQueryTokenType.isInOperator((EQueryTokenType)tokens.get(i - 1).getType());
            QueryToken token = tokens.get(i);
            if (i < tokens.size() - 3 && token.getType() == EQueryTokenType.QUERY) {
                QueryToken nextToken = tokens.get(i + 1);
                QueryToken nextNextToken = tokens.get(i + 2);
                QueryToken nextNextNextToken = tokens.get(i + 3);
                if (nextToken.getType() == EQueryTokenType.PAREN_OPEN && nextNextToken.getType() == EQueryTokenType.LITERAL && nextNextNextToken.getType() == EQueryTokenType.PAREN_CLOSE) {
                    String queryName = nextNextToken.getText();
                    try {
                        result.addAll(this.expandNamedQuery(queryName, nextNextToken, new HashSet<String>(encounteredValues), isInSubQuery));
                        i += 3;
                        continue;
                    }
                    catch (StorageException e) {
                        throw new QueryParsingException(e.getMessage(), tokens);
                    }
                }
                result.add(token);
                continue;
            }
            result.add(token);
        }
        return result;
    }

    private List<QueryToken> expandNamedQuery(String queryName, QueryToken replacedToken, Set<String> encounteredValues, boolean forIsInSubQuery) throws StorageException, QueryParsingException {
        if (encounteredValues.contains(queryName)) {
            throw new QueryParsingException("Invalid query. The query has a recursive loop. Query \"" + queryName + "\" is encountered twice.", new QueryToken[0]);
        }
        encounteredValues.add(queryName);
        ArrayList<QueryToken> result = new ArrayList<QueryToken>();
        if (forIsInSubQuery) {
            result.add(new QueryToken(EQueryTokenType.QUERY, QUERY_REFERENCE_KEYWORD, (long)replacedToken.getPosition()));
        }
        result.add(new QueryToken(EQueryTokenType.PAREN_OPEN, "(", (long)replacedToken.getPosition()));
        result.addAll(this.preprocessQuery(this.getQueryExpansion(queryName), encounteredValues));
        result.add(new QueryToken(EQueryTokenType.PAREN_CLOSE, ")", (long)replacedToken.getPosition()));
        return result;
    }

    private @NonNull List<QueryToken> getQueryExpansion(String queryName) throws StorageException {
        StoredQueryDescriptor query = this.queryIndex.getQuery(queryName).orElseThrow(() -> new StorageException("Query \"" + queryName + "\" does not exist."));
        return QueryLexer.tokenize((String)query.getQuery());
    }
}

