/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.query;

import com.teamscale.core.user.User;
import com.teamscale.index.query.BaselinePreprocessor;
import com.teamscale.index.query.CurrentUserPreprocessor;
import com.teamscale.index.query.GroupExpansionPreprocessor;
import com.teamscale.index.query.IssueQueryReferencePreprocessor;
import com.teamscale.index.query.QueryReferencePreprocessor;
import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.wia.TeamscaleIssueId;
import jakarta.ws.rs.BadRequestException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectIndex;
import org.conqat.engine.persistence.index.keyed.query.QueryEngine;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.error.QueryParsingException;
import org.conqat.engine.persistence.index.keyed.query.lexer.IQueryPreprocessor;
import org.conqat.engine.persistence.index.keyed.query.trend.CountBasedTrendCollector;
import org.conqat.engine.persistence.index.keyed.query.trend.ITrendCollector;
import org.conqat.engine.persistence.index.keyed.query.trend.SpecItemTrendCollector;
import org.conqat.engine.persistence.index.keyed.query.trend.SpecItemTrendItem;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.eclipse.jgit.util.StringUtils;

public final class QueryableEntityUtils {
    public static PairList<Long, SpecItemTrendItem> getSpecItemTrend(IKeyedObjectIndex<?> historyIndex, String queryString, QueryContext queryContext) throws StorageException, BadRequestException {
        SpecItemTrendCollector trendCollector = new SpecItemTrendCollector("testReferences", "codeReferences");
        return QueryableEntityUtils.getTrendWithErrorHandling(historyIndex, queryString, queryContext, trendCollector);
    }

    public static PairList<Long, Double> getIssueTrend(IKeyedObjectIndex<?> historyIndex, String queryString, QueryContext queryContext) throws StorageException, BadRequestException {
        CountBasedTrendCollector trendCollector = new CountBasedTrendCollector();
        return QueryableEntityUtils.getTrendWithErrorHandling(historyIndex, queryString, queryContext, trendCollector);
    }

    private static <T> PairList<Long, T> getTrendWithErrorHandling(IKeyedObjectIndex<?> historyIndex, String queryString, QueryContext queryContext, ITrendCollector<T> trendCollector) throws StorageException {
        try {
            return QueryEngine.selectTrend(historyIndex, (String)queryString, (QueryEngine.IQueryContext)queryContext, trendCollector);
        }
        catch (QueryCompilationException | QueryParsingException e) {
            throw new BadRequestException("Could not process query: " + e.getMessage(), e);
        }
    }

    public static List<TeamscaleIssueId> runIssueQuery(IKeyedObjectIndex<?> index, String query, QueryContext queryContext) throws StorageException, QueryParsingException, QueryCompilationException {
        return CollectionUtils.map((Collection)QueryEngine.selectIds(index, (String)query, (QueryEngine.IQueryContext)queryContext), TeamscaleIssueId::fromInternalId);
    }

    public static List<String> performQueryWithEmptyHandling(String query, IKeyedObjectIndex<?> historyIndex, QueryContext queryContext) throws StorageException, QueryCompilationException, QueryParsingException {
        ArrayList resultKeys = StringUtils.isEmptyOrNull((String)query) ? new ArrayList(historyIndex.getAllIds()) : QueryEngine.selectIds(historyIndex, (String)query, (QueryEngine.IQueryContext)queryContext);
        return CollectionUtils.sort(resultKeys);
    }

    private QueryableEntityUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    public record QueryContext(ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, User currentUser, StoredQueryIndex queryIndex, long startTime, long endTime, String branch, boolean onlyQueryValidation) implements QueryEngine.IQueryContext
    {
        public QueryContext {
            long finalEnd = endTime;
            long finalStart = startTime;
            CCSMAssert.isTrue((endTime >= startTime ? 1 : 0) != 0, () -> String.format("Expected \"%s\" (%d) to greater or equal to \"%s\" (%d)", "endTime", finalEnd, "startTime", finalStart));
            endTime = Math.min(endTime, System.currentTimeMillis());
            startTime = Math.min(startTime, endTime);
        }

        public static QueryContext ofTimestamp(ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, User currentUser, StoredQueryIndex.EStoredQueryType storedQueryType, CommitDescriptor commit) throws StorageException {
            return QueryContext.ofTimestamp(projectStorageSystem, globalStorageSystem, currentUser, storedQueryType, commit.getTimestamp(), commit.getBranchName());
        }

        public static QueryContext ofTimestamp(ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, User currentUser, StoredQueryIndex.EStoredQueryType storedQueryType, HistoryAccessOption historyAccessOption) throws StorageException {
            return QueryContext.ofTimestamp(projectStorageSystem, globalStorageSystem, currentUser, storedQueryType, historyAccessOption.getTimestampOrNow(), historyAccessOption.getBranchName());
        }

        public static QueryContext ofTimestamp(ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, User currentUser, StoredQueryIndex.EStoredQueryType storedQueryType, long timestamp, String branch) throws StorageException {
            return QueryContext.ofTrend(projectStorageSystem, globalStorageSystem, currentUser, storedQueryType, timestamp, timestamp, branch);
        }

        public static QueryContext ofTrend(ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, User currentUser, StoredQueryIndex.EStoredQueryType storedQueryType, long startTime, long endTime, String branch) throws StorageException {
            return new QueryContext(projectStorageSystem, globalStorageSystem, currentUser, StoredQueryIndex.openIndex(projectStorageSystem, storedQueryType), startTime, endTime, branch, false);
        }

        public QueryContext onlyForQueryValidation() {
            if (this.onlyQueryValidation) {
                return this;
            }
            return new QueryContext(this.projectStorageSystem, this.globalStorageSystem, this.currentUser, this.queryIndex, this.startTime, this.endTime, this.branch, true);
        }

        QueryContext withQueryType(StoredQueryIndex.EStoredQueryType storedQueryType) throws StorageException {
            return new QueryContext(this.projectStorageSystem, this.globalStorageSystem, this.currentUser, StoredQueryIndex.openIndex(this.projectStorageSystem, storedQueryType), this.startTime, this.endTime, this.branch, this.onlyQueryValidation);
        }

        QueryContext withTimestamp(long timestamp) {
            return new QueryContext(this.projectStorageSystem, this.globalStorageSystem, this.currentUser, this.queryIndex, timestamp, timestamp, this.branch, this.onlyQueryValidation);
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public List<IQueryPreprocessor> getPreprocessors() {
            ArrayList<IQueryPreprocessor> preprocessors = new ArrayList<IQueryPreprocessor>();
            preprocessors.add(new GroupExpansionPreprocessor(this.globalStorageSystem, this.onlyQueryValidation));
            preprocessors.add(new CurrentUserPreprocessor(this.currentUser));
            preprocessors.add(new QueryReferencePreprocessor(this.queryIndex));
            preprocessors.add(new BaselinePreprocessor(this.projectStorageSystem));
            if (this.queryIndex.getStoredQueryType() == StoredQueryIndex.EStoredQueryType.SPEC_ITEM) {
                preprocessors.add(new IssueQueryReferencePreprocessor(this));
            }
            return preprocessors;
        }
    }
}

