/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.astree;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.index.configuration.tools.message.AstreeMessageManager;
import com.teamscale.index.report.astree.AstreeAlarmMessage;
import com.teamscale.index.report.astree.AstreeElementBase;
import com.teamscale.index.report.astree.AstreeFile;
import com.teamscale.index.report.astree.AstreeLocation;
import com.teamscale.index.report.astree.AstreeReportHandler;
import com.teamscale.index.report.base.FindingCollectingReportParserBase;
import com.teamscale.reportparser.parser.ReportParserException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.xml.XMLUtils;
import org.jspecify.annotations.Nullable;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AstreeReportParser
extends FindingCollectingReportParserBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private AstreeReportHandler handler;
    private AstreeMessageManager manager;

    @Override
    public void parseStringReportInternal(String report, @Nullable String reportPath) throws ReportParserException {
        try {
            this.handler = new AstreeReportHandler();
            XMLUtils.parseSAX((String)report, (DefaultHandler)this.handler);
            if (this.manager == null) {
                this.manager = AstreeMessageManager.getInstance();
            }
        }
        catch (IOException e) {
            throw new ReportParserException("Error when parsing report.", (Throwable)e);
        }
        catch (SAXException e) {
            throw new ReportParserException((Throwable)e);
        }
        catch (ProjectConfigurationException e) {
            throw new ReportParserException("Could not initialize message manager: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void collectFindings() throws StorageException {
        Map<String, AstreeFile> fileIdToFileMapping = this.handler.getFiles().stream().collect(Collectors.toMap(AstreeElementBase::getId, file -> file));
        Map<String, AstreeLocation> locationIdToLocationMapping = this.handler.getLocations().stream().collect(Collectors.toMap(AstreeElementBase::getId, location -> location));
        List<AstreeAlarmMessage> alarmMessages = this.handler.getAlarmMessages();
        for (AstreeAlarmMessage astreeAlarmMessage : alarmMessages) {
            ElementLocation elementLocation;
            AstreeLocation location2 = locationIdToLocationMapping.get(astreeAlarmMessage.getLocationId());
            if (location2 == null) {
                LOGGER.error("Alarm references location with id {} which is not present in locations.", (Object)astreeAlarmMessage.getLocationId());
                continue;
            }
            AstreeFile file2 = fileIdToFileMapping.get(location2.getFileId());
            Optional<String> uniformPath = this.resolvePath(file2.getName());
            if (!uniformPath.isPresent()) continue;
            if (location2.getoStartLine().isPresent()) {
                Integer startLine = location2.getoStartLine().get();
                elementLocation = AstreeReportParser.createLineLocation(uniformPath.get(), startLine, location2.getoEndLine().orElse(startLine));
            } else {
                elementLocation = new ElementLocation(uniformPath.get());
            }
            DetachedFinding finding = AstreeReportParser.createFindingWithLocation(astreeAlarmMessage.getType(), this.manager.getFindingsGroupNameFor(astreeAlarmMessage.getType()), this.manager.getFindingCategoryName(), astreeAlarmMessage.getMessage(), elementLocation);
            this.addFindingForPath(uniformPath.get(), finding);
        }
    }
}

