/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.generic;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.teamscale.core.rest.IExternalUploadRequestPart;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.Nullable;

public class NonCodeMetricsEntry
implements IExternalUploadRequestPart {
    private static final String PATH_PROPERTY = "path";
    private static final String CONTENT_PROPERTY = "content";
    private static final String COUNT_PROPERTY = "count";
    private static final String ASSESSMENT_PROPERTY = "assessment";
    private static final String TIME_PROPERTY = "time";
    private static final String METRICS_PROPERTY = "metrics";
    @JsonProperty(value="path")
    private final String path;
    @JsonProperty(value="content")
    private final @Nullable String content;
    @JsonProperty(value="metrics")
    @Schema(implementation=OpenApiSchema.NonCodeMetrics.class)
    private final Map<String, Object> metrics = new HashMap<String, Object>();

    public NonCodeMetricsEntry(String path, @Nullable String content, @Nullable Map<String, Object> metrics) {
        this(path, content, null, null, null, metrics);
    }

    @JsonCreator
    public NonCodeMetricsEntry(@JsonProperty(value="path") String path, @JsonProperty(value="content") @Nullable String content, @Schema(hidden=true) @JsonProperty(value="count") @Nullable Integer count, @Schema(hidden=true) @JsonProperty(value="assessment") @Nullable Map<ETrafficLightColor, Integer> assessment, @Schema(hidden=true) @JsonProperty(value="time") @Nullable Double time, @JsonProperty(value="metrics") @Nullable Map<String, Object> metrics) {
        this.path = Objects.requireNonNull(path);
        this.content = content;
        NonCodeMetricsEntry.checkForConflictingMetrics(COUNT_PROPERTY, count, metrics);
        NonCodeMetricsEntry.checkForConflictingMetrics(ASSESSMENT_PROPERTY, assessment, metrics);
        NonCodeMetricsEntry.checkForConflictingMetrics(TIME_PROPERTY, time, metrics);
        this.putIfNotNull(this.metrics, COUNT_PROPERTY, count);
        this.putIfNotNull(this.metrics, ASSESSMENT_PROPERTY, this.toStringKeys(assessment));
        this.putIfNotNull(this.metrics, TIME_PROPERTY, time);
        if (metrics != null) {
            this.metrics.putAll(metrics);
        }
    }

    private static void checkForConflictingMetrics(String metricName, @Nullable Object hardCodedMetricValue, @Nullable Map<String, Object> customMetricValues) {
        Preconditions.checkArgument((hardCodedMetricValue == null || customMetricValues == null || !customMetricValues.containsKey(metricName) ? 1 : 0) != 0, (String)"Conflicting metric: %s", (Object)metricName);
    }

    private <K, V> void putIfNotNull(Map<K, V> map, K key, V value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    private <K> @Nullable Map<String, ?> toStringKeys(@Nullable Map<K, ?> assessment) {
        if (assessment == null) {
            return null;
        }
        return CollectionUtils.map(assessment, Object::toString, Function.identity());
    }

    public String getUniformPath() {
        return UniformPath.parse((UniformPath.EType)UniformPath.EType.NON_CODE, (String)this.path).toStringAsMigrationFrontier();
    }

    public String getContent() {
        return StringUtils.emptyIfNull((String)this.content);
    }

    public Map<String, Object> getMetrics() {
        return this.metrics;
    }

    private static class OpenApiSchema {
        private OpenApiSchema() {
        }

        @ArraySchema(minItems=3, maxItems=3)
        private static interface ArrayEncodedAssessment
        extends List<Integer> {
        }

        private static interface ObjectEncodedAssessment
        extends Map<ETrafficLightColor, Integer> {
        }

        @Schema(oneOf={Number.class, ObjectEncodedAssessment.class, ArrayEncodedAssessment.class})
        private static interface NonCodeMetricValue {
        }

        @Schema(implementation=NonCodeMetricValue.class)
        private static interface NonCodeMetricValueSchema {
        }

        private static interface NonCodeMetrics
        extends Map<String, NonCodeMetricValueSchema> {
        }
    }
}

