/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.parser;

import com.teamscale.core.utils.CSVParserBase;
import com.teamscale.core.utils.CsvStringListParser;
import com.teamscale.index.report.parser.ReportParserBase;
import com.teamscale.reportparser.parser.ReportParserException;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public abstract class IssueCsvReportParserBase
extends ReportParserBase {
    private static final String DELIMITER = ",";
    public static final long UPDATED_DEFAULT = -1L;

    @Override
    protected void parseStringReportInternal(String report, @Nullable String reportPath) throws ReportParserException {
        try {
            CSVParserBase.Configuration config = new CSVParserBase.Configuration();
            config.setDelimiterChar(DELIMITER.charAt(0));
            CsvStringListParser parser = new CsvStringListParser(config);
            parser.parseAndWrapExceptions((Reader)new StringReader(report));
            List header = parser.getHeader();
            if (!this.isValidHeader(header)) {
                throw new ReportParserException("CSV has the wrong format. It must have the following fields, in that order: [" + String.join((CharSequence)DELIMITER, this.getHeaderFormat()) + "]");
            }
            for (List row : parser) {
                this.addItem(row, header);
            }
        }
        catch (NumberFormatException | ConQATException e) {
            throw new ReportParserException(e);
        }
    }

    private boolean isValidHeader(List<String> header) {
        return String.join((CharSequence)DELIMITER, header).startsWith(String.join((CharSequence)DELIMITER, this.getHeaderFormat()));
    }

    protected abstract List<String> getHeaderFormat();

    protected abstract void addItem(List<String> var1, List<String> var2) throws ReportParserException;

    protected TeamscaleIssue parseIssue(List<String> row, List<String> header) throws ReportParserException {
        if (row.size() < this.getHeaderFormat().size()) {
            throw new ReportParserException("The row " + String.valueOf(row) + " from the issue CSV file contains too little entries");
        }
        String id = row.get(0);
        String subject = row.get(1);
        String assignee = row.get(2);
        String author = row.get(3);
        String description = row.get(4);
        long created = Long.parseLong(row.get(5));
        long updated = -1L;
        if (!StringUtils.isEmpty((String)row.get(6))) {
            updated = Long.parseLong(row.get(6));
        }
        String status = row.get(7);
        boolean closed = Boolean.parseBoolean(row.get(8));
        String url = row.get(9);
        ArrayList<String> additionalFieldNames = new ArrayList<String>(header.subList(this.getHeaderFormat().size(), header.size()));
        ArrayList<String> additionalFieldValues = new ArrayList<String>(row.subList(this.getHeaderFormat().size(), row.size()));
        int indexOfParentField = additionalFieldNames.indexOf("parent");
        String parent = null;
        if (indexOfParentField != -1) {
            if (!StringUtils.isEmpty((String)((String)additionalFieldValues.get(indexOfParentField)))) {
                parent = (String)additionalFieldValues.get(indexOfParentField);
            }
            additionalFieldNames.remove(indexOfParentField);
            additionalFieldValues.remove(indexOfParentField);
        }
        return new TeamscaleIssue(new TeamscaleIssueId(this.connectorId, id), subject, assignee, author, description, created, updated, status, closed, url, additionalFieldNames, additionalFieldValues, parent);
    }
}

