/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.parser.sonarqube;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.index.report.base.OffsetConvertingFindingReportParserBase;
import com.teamscale.index.report.parser.sonarqube.SonarqubeIssueData;
import com.teamscale.index.report.parser.sonarqube.SonarqubeRuleDetails;
import com.teamscale.index.upload.IExternalToolRule;
import com.teamscale.index.upload.sonarqube.data.SonarqubeRule;
import com.teamscale.reportparser.parser.ReportParserException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.text.WordUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class SonarqubeReportParser
extends OffsetConvertingFindingReportParserBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String SONARQUBE_CATEGORY = "SonarQube";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private Map<String, IExternalToolRule> rulesById;
    private Map<String, SonarqubeRuleDetails> ruleDetailsById;

    @Override
    public void resetState() {
        super.resetState();
        this.rulesById = new HashMap<String, IExternalToolRule>();
        this.ruleDetailsById = new HashMap<String, SonarqubeRuleDetails>();
    }

    @Override
    public void parseStringReportInternal(String report, @Nullable String reportPath) throws ReportParserException {
        if (StringUtils.isEmpty((String)report)) {
            LOGGER.info("Empty SonarQube report \"{}\"", (Object)reportPath);
            return;
        }
        try {
            this.parseJsonReport(report);
        }
        catch (IOException e) {
            throw new ReportParserException("Error parsing SonarQube report", (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            throw new ReportParserException("Out of memory parsing large SonarQube report. Consider increasing heap size or splitting the report.", (Throwable)e);
        }
    }

    @Override
    protected void collectFindings() throws StorageException {
    }

    @Override
    public void checkEnabledAnalysesAndTools(List<AnalysisProfile> analysisProfiles, PublicProjectId projectId) throws ConQATException {
        SonarqubeReportParser.checkEnabledAnalysisTool(EAnalysisTool.SONARQUBE, analysisProfiles, projectId);
    }

    @Override
    public Collection<IExternalToolRule> getRules() {
        return this.rulesById.values();
    }

    @Override
    public EAnalysisTool getAnalysisTool() {
        return EAnalysisTool.SONARQUBE;
    }

    private void parseJsonReport(String report) throws IOException {
        try (JsonParser parser = OBJECT_MAPPER.createParser(report);){
            while (parser.nextToken() != null) {
                String fieldName = parser.currentName();
                if ("rules".equals(fieldName)) {
                    this.parseRulesArray(parser);
                    continue;
                }
                if (!"issues".equals(fieldName)) continue;
                this.parseIssuesArray(parser);
            }
        }
        catch (StorageException e) {
            throw new IOException("Storage error during JSON parsing", e);
        }
    }

    private void parseRulesArray(JsonParser parser) throws IOException, StorageException {
        parser.nextToken();
        if (parser.currentToken() != JsonToken.START_ARRAY) {
            return;
        }
        while (parser.nextToken() == JsonToken.START_OBJECT) {
            SonarqubeRuleDetails ruleDetails = (SonarqubeRuleDetails)parser.readValueAs(SonarqubeRuleDetails.class);
            if (ruleDetails == null || ruleDetails.key() == null) continue;
            this.ruleDetailsById.put(ruleDetails.key(), ruleDetails);
        }
    }

    private void parseIssuesArray(JsonParser parser) throws IOException, StorageException {
        parser.nextToken();
        if (parser.currentToken() != JsonToken.START_ARRAY) {
            return;
        }
        while (parser.nextToken() == JsonToken.START_OBJECT) {
            SonarqubeIssueData issueData = (SonarqubeIssueData)parser.readValueAs(SonarqubeIssueData.class);
            if (!SonarqubeReportParser.shouldProcessIssue(issueData) || SonarqubeReportParser.isClosedIssue(issueData)) continue;
            this.createFindingFromIssueData(issueData);
        }
    }

    private static boolean shouldProcessIssue(@Nullable SonarqubeIssueData data) {
        return data != null && !StringUtils.isEmpty((String)data.component()) && data.line() > 0 && !StringUtils.isEmpty((String)data.message());
    }

    private static boolean isClosedIssue(SonarqubeIssueData data) {
        return "CLOSED".equals(data.status());
    }

    private void createFindingFromIssueData(SonarqubeIssueData data) throws StorageException {
        String filePath = SonarqubeReportParser.extractFilePathFromComponent(data.component());
        Optional<String> uniformPath = this.resolvePath(filePath);
        if (uniformPath.isEmpty()) {
            return;
        }
        SonarqubeRule rule = this.getOrCreateRule(data);
        TextRegionLocation location = this.createLocationFromTextRange(uniformPath.get(), data);
        DetachedFinding finding = SonarqubeReportParser.createFindingWithLocation(rule.getSonarqubeID(), rule.getId(), SONARQUBE_CATEGORY, data.message(), (ElementLocation)location);
        finding.setProperty("Severity", (Object)WordUtils.capitalizeFully((String)data.severity()));
        if (!StringUtils.isEmpty((String)data.effort())) {
            finding.setProperty("Effort", (Object)data.effort());
        }
        if (!StringUtils.isEmpty((String)data.cleanCodeAttribute())) {
            finding.setProperty("CleanCodeAttribute", (Object)WordUtils.capitalizeFully((String)data.cleanCodeAttribute()));
        }
        finding.setProperty("IssueKey", (Object)data.key());
        boolean isFalsePositive = "FALSE_POSITIVE".equals(data.issueStatus());
        finding.setProperty("Marked as False Positive externally", (Object)isFalsePositive);
        boolean isTolerated = "ACCEPTED".equals(data.issueStatus());
        finding.setProperty("Tolerated Externally", (Object)isTolerated);
        this.addFindingForPath(uniformPath.get(), finding);
    }

    private TextRegionLocation createLocationFromTextRange(String uniformPath, SonarqubeIssueData data) throws StorageException {
        if (data.textRange() != null) {
            SonarqubeIssueData.TextRange textRange = data.textRange();
            int startColumn = textRange.startOffset() + 1;
            int endColumn = textRange.endOffset() + 1;
            Optional<TextRegionLocation> location = this.createTextRegionLocation(uniformPath, textRange.startLine(), startColumn, textRange.endLine(), endColumn);
            if (location.isPresent()) {
                return location.get();
            }
            LOGGER.debug("Failed to convert offsets for {} at lines {}-{}, falling back to line-only location", (Object)uniformPath, (Object)textRange.startLine(), (Object)textRange.endLine());
        }
        return SonarqubeReportParser.createLineLocation(uniformPath, data.line(), data.line());
    }

    private static String extractFilePathFromComponent(String component) {
        int colonIndex = component.indexOf(58);
        if (colonIndex >= 0 && colonIndex < component.length() - 1) {
            return component.substring(colonIndex + 1);
        }
        return component;
    }

    private SonarqubeRule getOrCreateRule(SonarqubeIssueData data) {
        String ruleId = data.rule();
        return (SonarqubeRule)this.rulesById.computeIfAbsent(ruleId, id -> new SonarqubeRule(data, this.ruleDetailsById.get(ruleId)));
    }
}

