/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.result.processor;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.index.dependencies.ExternalDependencyIndex;
import com.teamscale.index.dependencies.ExternalDependencyInfo;
import com.teamscale.index.external.result.ExternalAnalysisResultDependencyInfo;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultProcessorBase;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class ExternalAnalysisResultDependencyInfoProcessor
extends ExternalAnalysisResultProcessorBase<ExternalAnalysisResultDependencyInfo> {
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ExternalDependencyIndex externalDependencyIndex;
    private final Map<String, Map<String, ExternalDependencyInfo>> newDependencyInfos = new HashMap<String, Map<String, ExternalDependencyInfo>>();

    @Override
    public boolean isRelevantPath(UniformPath uniformPath) {
        return uniformPath.isCodePath();
    }

    @Override
    public Class<ExternalAnalysisResultDependencyInfo> getResultClass() {
        return ExternalAnalysisResultDependencyInfo.class;
    }

    @Override
    public boolean extract(String partition, UniformPath uniformPath, ExternalAnalysisResultDependencyInfo analysisResult, CommitDescriptor resultsCommit, CommitDescriptor resultsForCommit, BasicTokenElementInfo element) {
        this.newDependencyInfos.computeIfAbsent(partition, p -> new HashMap()).put(uniformPath.toString(), analysisResult.getData());
        return true;
    }

    @Override
    public void persist(CommitDescriptor commit) throws StorageException {
        this.externalDependencyIndex.setDependencyInfos(this.newDependencyInfos);
    }

    @Override
    public void processDeleted(Collection<PartitionAndPath> deletedPartitionAndPaths, CommitDescriptor commit) throws StorageException {
        this.externalDependencyIndex.removeDependencyInfos(deletedPartitionAndPaths);
    }

    @Override
    public void reset() {
        this.newDependencyInfos.clear();
    }
}

