/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="first-code-commit", options={EStorageOption.COMMIT_ISOLATED}, valueClasses={String.class})
public class FirstCodeCommitIndex
extends IndexBase
implements IProjectIndex,
IRollbackableIndex {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String NAME = "first-code-commit";
    private static final String CODE_KEY_PREFIX = "C";

    public FirstCodeCommitIndex(IStore store) {
        super(store);
    }

    private OptionalLong getFirstCodeTimestamp(String branchName) throws StorageException {
        return ByteArrayUtils.byteArrayToOptionalLong((byte[])this.store.getWithString(CODE_KEY_PREFIX + branchName));
    }

    public Map<String, Long> getBranchToFirstCodeCommitMapping() throws StorageException {
        HashMap<String, Long> branchToFirstCodeCommitMapping = new HashMap<String, Long>();
        this.store.scan(CODE_KEY_PREFIX, (key, value) -> {
            long timestamp = ByteArrayUtils.byteArrayToLong((byte[])value);
            String branchName = StringUtils.stripPrefix((String)StringUtils.bytesToString((byte[])key), (String)CODE_KEY_PREFIX);
            Map map = branchToFirstCodeCommitMapping;
            synchronized (map) {
                branchToFirstCodeCommitMapping.put(branchName, timestamp);
            }
        });
        return branchToFirstCodeCommitMapping;
    }

    public boolean insertCodeCommit(CommitDescriptor commit) throws StorageException {
        OptionalLong currentTimestamp = this.getFirstCodeTimestamp(commit.getBranchName());
        if (currentTimestamp.isPresent()) {
            if (currentTimestamp.getAsLong() > commit.getTimestamp()) {
                LOGGER.warn("Expected first inserted value to be the smallest one! Tried to insert " + commit.toServiceCallFormat() + ", but already had timestamp " + currentTimestamp.getAsLong());
            }
            return false;
        }
        this.store.putWithString(CODE_KEY_PREFIX + commit.getBranchName(), ByteArrayUtils.longToByteArray((long)commit.getTimestamp()));
        return true;
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        ArrayList<String> branchNames = new ArrayList<String>(timestampByBranch.keySet());
        List codeTimestampValues = CollectionUtils.map((Collection)this.store.getWithStrings(CollectionUtils.map(branchNames, name -> CODE_KEY_PREFIX + name)), ByteArrayUtils::byteArrayToOptionalLong);
        ArrayList<CallSite> keysToDelete = new ArrayList<CallSite>();
        for (int i = 0; i < branchNames.size(); ++i) {
            String branchName = (String)branchNames.get(i);
            if (!((OptionalLong)codeTimestampValues.get(i)).isPresent() || ((OptionalLong)codeTimestampValues.get(i)).getAsLong() <= timestampByBranch.get(branchName)) continue;
            keysToDelete.add((CallSite)((Object)(CODE_KEY_PREFIX + branchName)));
        }
        if (!keysToDelete.isEmpty()) {
            this.store.removeWithStrings(keysToDelete);
        }
    }
}

