/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.index.repository.RepositoryCommitMappingIndexBase;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;

@Index(name="repository-commit-by-task", options={EStorageOption.NO_ROLLBACK}, valueClasses={String.class})
public class RepositoryCommitTaskMappingIndex
extends RepositoryCommitMappingIndexBase
implements IProjectIndex {
    public static final String INDEX_NAME = "repository-commit-by-task";

    public RepositoryCommitTaskMappingIndex(IStore store) {
        super(store);
    }

    public List<CommitDescriptor> getCommitsForTask(String task) throws StorageException {
        return Optional.ofNullable(this.getCommitsForId(task)).orElse((List<CommitDescriptor>)CollectionUtils.emptyList());
    }

    public List<String> getTasksForCommit(CommitDescriptor commit) throws StorageException {
        return Optional.ofNullable(this.getIdsForCommit(commit)).orElse((List<String>)CollectionUtils.emptyList());
    }

    public List<List<String>> getTasksForCommits(List<CommitDescriptor> commits) throws StorageException {
        return Optional.ofNullable(this.getIdsForCommits(commits)).orElse((List<List<String>>)CollectionUtils.emptyList());
    }

    @Override
    public void addValues(SetMap<CommitDescriptor, String> commitsToIds) throws StorageException {
        super.addValues(commitsToIds);
    }
}

