/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.repository.ContentPipelineRepositoryLogFileIndex;
import com.teamscale.index.repository.RepositoryLogFileEntry;
import com.teamscale.index.repository.RepositoryLogFileIndex;
import java.util.List;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class RepositoryLogFileIndexSynchronizer
extends ChangeProcessorAnalysisStep {
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    protected RepositoryLogFileIndex logFileIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    protected ContentPipelineRepositoryLogFileIndex contentLogFileIndex;
    @DeltaSource(value=ContentPipelineRepositoryLogFileIndex.class)
    KeyDelta contentPipelineDelta;

    public void execute() throws Exception {
        if (this.contentPipelineDelta.isEmpty()) {
            return;
        }
        List<RepositoryLogFileEntry> newValues = this.contentLogFileIndex.getEntriesByDeltaKeys(this.contentPipelineDelta.getAddedOrChangedKeysAsBytes(), this.getSchedulingCommit());
        this.logFileIndex.insertEntries(newValues);
    }
}

