/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store;

import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.IConnectorDescriptorConsistencyValidator;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.index.repository.artifact_store.ArtifactStoreRepositoryConnectorDescriptorBase;
import com.teamscale.index.repository.base.RepositoryConnectorDescriptorBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.NonNull;

public enum DeletePartitionsWithoutUploadsConnectorConsistencyChecker implements IConnectorDescriptorConsistencyValidator
{
    INSTANCE;


    public static DeletePartitionsWithoutUploadsConnectorConsistencyChecker getInstance() {
        return INSTANCE;
    }

    public void validate(List<ConnectorDescriptorBase> connectors, boolean usesExternalStorageBackend, List<PublicProjectId> projectIds) throws ConnectorValidationException {
        List<ArtifactStoreRepositoryConnectorDescriptorBase<?>> relevantConnectors = DeletePartitionsWithoutUploadsConnectorConsistencyChecker.filterArtifactStoreConnectors(connectors);
        if (DeletePartitionsWithoutUploadsConnectorConsistencyChecker.validationCanBeSkipped(relevantConnectors, usesExternalStorageBackend)) {
            return;
        }
        ConnectorsByDeletionSetting connectorGroups = DeletePartitionsWithoutUploadsConnectorConsistencyChecker.groupConnectorsByDeletionSetting(relevantConnectors);
        if (usesExternalStorageBackend) {
            DeletePartitionsWithoutUploadsConnectorConsistencyChecker.validateConnectorsWithExternalBackend(connectorGroups, projectIds);
        } else {
            DeletePartitionsWithoutUploadsConnectorConsistencyChecker.validateConnectors(connectorGroups);
        }
    }

    private static boolean validationCanBeSkipped(List<ArtifactStoreRepositoryConnectorDescriptorBase<?>> connectors, boolean usesExternalStorageBackend) {
        if (connectors.isEmpty()) {
            return true;
        }
        return connectors.size() == 1 && !usesExternalStorageBackend;
    }

    private static ConnectorsByDeletionSetting groupConnectorsByDeletionSetting(List<ArtifactStoreRepositoryConnectorDescriptorBase<?>> connectors) {
        Map<Boolean, List<ArtifactStoreRepositoryConnectorDescriptorBase>> connectorsGroupedByDeletionSetting = connectors.stream().collect(Collectors.partitioningBy(connector -> connector.deletePartitionsWithoutNewUploads));
        return new ConnectorsByDeletionSetting(connectorsGroupedByDeletionSetting.get(true), connectorsGroupedByDeletionSetting.get(false));
    }

    private static void validateConnectors(ConnectorsByDeletionSetting connectorGroups) throws ConnectorValidationException {
        if (connectorGroups.hasInconsistentSettings()) {
            throw new ConnectorValidationException("Inconsistent connector configuration detected. The following connectors have the option '%s' enabled: %s. However, for the following connectors it is disabled: %s. To avoid unexpected behavior, please ensure that this option is set consistently over all connectors.".formatted("Delete Partitions Without New Uploads", DeletePartitionsWithoutUploadsConnectorConsistencyChecker.extractIdentifiers(connectorGroups.deleteOldPartitionsConnectors), DeletePartitionsWithoutUploadsConnectorConsistencyChecker.extractIdentifiers(connectorGroups.keepOldPartitionsConnectors)));
        }
    }

    private static void validateConnectorsWithExternalBackend(ConnectorsByDeletionSetting connectorGroups, List<PublicProjectId> projectIds) throws ConnectorValidationException {
        boolean externalBackendDeletesPartitions = ArtifactStoreRepositoryConnectorDescriptorBase.determineDeletePartitionsWithoutUploadsForExternalStorageBackend(projectIds);
        if (connectorGroups.hasDeleteOldPartitionsConnectors() && !externalBackendDeletesPartitions) {
            throw new ConnectorValidationException("Inconsistent connector configuration detected. The following connectors have the option '%s' enabled: %s. However, the external storage backend is configured to _preserve_ partitions without new uploads (configurable via JVM options). To avoid unexpected behavior, please ensure that this option is set consistently over all connectors.".formatted("Delete Partitions Without New Uploads", DeletePartitionsWithoutUploadsConnectorConsistencyChecker.extractIdentifiers(connectorGroups.deleteOldPartitionsConnectors)));
        }
        if (connectorGroups.hasKeepOldPartitionsConnectors() && externalBackendDeletesPartitions) {
            throw new ConnectorValidationException("Inconsistent connector configuration detected. The following connectors have the option '%s' disabled: %s. However, the external storage backend is configured to _delete_ partitions without new uploads (configurable via JVM options). To avoid unexpected behavior, please ensure that this option is set consistently over all connectors.".formatted("Delete Partitions Without New Uploads", DeletePartitionsWithoutUploadsConnectorConsistencyChecker.extractIdentifiers(connectorGroups.keepOldPartitionsConnectors)));
        }
    }

    private static @NonNull List<ArtifactStoreRepositoryConnectorDescriptorBase<?>> filterArtifactStoreConnectors(List<ConnectorDescriptorBase> connectors) {
        ArrayList relevantConnectors = new ArrayList();
        for (ConnectorDescriptorBase connector : connectors) {
            if (!(connector instanceof ArtifactStoreRepositoryConnectorDescriptorBase)) continue;
            relevantConnectors.add((ArtifactStoreRepositoryConnectorDescriptorBase)connector);
        }
        return relevantConnectors;
    }

    private static String extractIdentifiers(List<ArtifactStoreRepositoryConnectorDescriptorBase<?>> connectors) {
        return String.join((CharSequence)", ", CollectionUtils.map(connectors, RepositoryConnectorDescriptorBase::getConnectorIdentifier));
    }

    private record ConnectorsByDeletionSetting(List<ArtifactStoreRepositoryConnectorDescriptorBase<?>> deleteOldPartitionsConnectors, List<ArtifactStoreRepositoryConnectorDescriptorBase<?>> keepOldPartitionsConnectors) {
        boolean hasInconsistentSettings() {
            return this.hasDeleteOldPartitionsConnectors() && this.hasKeepOldPartitionsConnectors();
        }

        boolean hasDeleteOldPartitionsConnectors() {
            return !this.deleteOldPartitionsConnectors.isEmpty();
        }

        boolean hasKeepOldPartitionsConnectors() {
            return !this.keepOldPartitionsConnectors.isEmpty();
        }
    }
}

