/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store.artifactory;

import com.teamscale.core.analysis.IProfilingMonitor;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.index.repository.ReportMappingSupport;
import com.teamscale.index.repository.artifact_store.ArtifactStoreRepositoryConnectionBase;
import com.teamscale.index.repository.artifact_store.ArtifactStoreRepositoryConnectorBaseParameters;
import com.teamscale.index.repository.artifact_store.artifactory.ArtifactoryRepositoryInfo;
import com.teamscale.index.repository.artifact_store.artifactory.SimpleArtifactoryClient;
import com.teamscale.index.repository.base.RepositoryConnectorBaseParameterStep;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.string.StringUtils;

public class ArtifactoryRepositoryConnection
extends ArtifactStoreRepositoryConnectionBase<ArtifactoryRepositoryInfo, SimpleArtifactoryClient> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ArtifactoryRepositoryConnection(RepositoryConnectorBaseParameterStep connectorBaseParameterStep, ArtifactStoreRepositoryConnectorBaseParameters artifactStoreRepositoryConnectorBaseParameters, ArtifactoryRepositoryInfo repositoryInfo, IProfilingMonitor profilingMonitor, ReportMappingSupport reportMappingSupport, IParallelTaskExecutor parallelTaskExecutor) throws RepositoryException {
        super(connectorBaseParameterStep, artifactStoreRepositoryConnectorBaseParameters, repositoryInfo, profilingMonitor, reportMappingSupport, artifactoryRepositoryInfo -> ArtifactoryRepositoryConnection.createArtifactoryClient(artifactoryRepositoryInfo, profilingMonitor), parallelTaskExecutor);
    }

    private static SimpleArtifactoryClient createArtifactoryClient(ArtifactoryRepositoryInfo repositoryInfo, IProfilingMonitor profilingMonitor) {
        if (StringUtils.isEmpty((String)repositoryInfo.getPublicContextPath())) {
            repositoryInfo.setPublicContextPath("artifactory");
        }
        return new SimpleArtifactoryClient(repositoryInfo.getExternalCredentials(), repositoryInfo.getPublicContextPath(), LOGGER, profilingMonitor);
    }

    @Override
    protected String getArtifactStoreType() {
        return "Artifactory";
    }
}

