/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store.s3;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.ScheduleOption;
import com.teamscale.index.repository.artifact_store.s3.S3GarbageMonitoringTrigger;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="repository.s3.garbage.monitoring", name="S3 Garbage Monitoring", type=EOptionType.SERVER, category=EOptionCategory.MONITORING)
@IndexValueClass(containedInBackup=true)
public class S3GarbageMonitoringOption
implements IOption {
    private static final long serialVersionUID = 1L;
    protected static final String OPTION_ID = "repository.s3.garbage.monitoring";
    protected static final String OPTION_NAME = "S3 Garbage Monitoring";
    @JsonProperty(value="enabled")
    @OptionFieldDescription(name="Enable automatic S3 garbage monitoring. If enabled, please configure a scheduling interval as well.", description="Enable automatic garbage monitoring. If enabled, please configure a scheduling interval as well.")
    public boolean enabled = false;
    @JsonProperty(value="schedule")
    @OptionFieldDescription(name="Defines when the S3 Garbage monitoring trigger is scheduled. Has no effect if garbage monitoring is disabled.")
    @ScheduleOption(triggerClass=S3GarbageMonitoringTrigger.class, enablementOption="enabled")
    public String schedule = "@midnight";

    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) {
        if (this.enabled && StringUtils.isEmpty((String)this.schedule)) {
            return "Enabling automatic S3 Storage Size Monitoring has no effect without providing a schedule.";
        }
        return null;
    }
}

