/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.base;

import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.index.model.CodeScope;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EConnectorType;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.IConnectorEnum;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.connectors.ICommitTreeConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.analysis.trigger.ChangeRetrieverAnalysisStep;
import com.teamscale.core.analysis.trigger.configuration.ESchedulingParameter;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.index.issues.BugTrackerConnectorDescriptorBase;
import com.teamscale.index.report.EReportFormat;
import com.teamscale.index.repository.RepositoryChangeIndex;
import com.teamscale.index.repository.RepositoryOriginalPathIndex;
import com.teamscale.index.repository.base.BranchPointerHistoryIndex;
import com.teamscale.index.repository.base.RepositoryToTriggerMappingIndex;
import com.teamscale.index.repository.base.RevisionParameterProcessor;
import com.teamscale.index.requirements_tracing.connectors.RequirementsManagementToolConnectorDescriptorBase;
import eu.cqse.check.framework.scanner.ELanguage;
import java.net.URI;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.conqat.engine.core.pattern.StringTransformation;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.filesystem.AntPatternUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.TestOnly;

public abstract class RepositoryConnectorDescriptorBase
extends ConnectorDescriptorBase
implements ICommitTreeConnectorDescriptor {
    public static final String LANGUAGE_MAPPING_PARAMETER_NAME = "Language mapping";
    public static final String START_REVISION_PARAMETER_NAME = "Start revision";
    public static final String END_REVISION_PARAMETER_NAME = "End revision";
    public static final String ANALYSIS_REPORT_MAPPING_NAME = "Analysis report mapping";
    public static final String REPOSITORY_IDENTIFIER_PARAMETER_NAME = "Repository identifier";
    public static final String DEFAULT_BRANCH_NAME_PARAMETER_NAME = "Default branch name";
    public static final String INCLUDED_FILE_NAMES_PARAMETER_NAME = "Included file names";
    public static final String EXCLUDED_FILE_NAMES_PARAMETER_NAME = "Excluded file names";
    public static final String PARTITION_PATTERN_PARAMETER_NAME = "Partition Pattern";
    public static final String SOURCE_LIBRARY_CONNECTOR_PARAMETER_NAME = "Source library connector";
    public static final String PATH_TRANSFORMATION_PARAMETER_NAME = "Path transformation";
    public static final String AUTHOR_TRANSFORMATION_PARAMETER_NAME = "Author transformation";
    protected static final String ENCODING_PARAMETER_NAME = "Encoding";
    public static final String TEXT_FILTER_PARAMETER_NAME = "Text filter";
    public static final String BRANCH_TRANSFORMATION_PARAMETER_NAME = "Branch transformation";
    public static final String CONTENT_EXCLUDE_PARAMETER_NAME = "Content exclude";
    private static final String CONFIGURE_DEFAULT_BRANCH_ERROR_MESSAGE_EMPTY = "The default branch name must not be empty.";
    public static final String PARTITION_REQUIRED_FOR_SECURITY_VIEW_NAME = "Partitions Required for Security View";
    private static final String ISSUE_CSV_COMMIT_MESSAGE_MAPPING = System.getProperty("com.teamscale.issue-csv.pattern", "(\\d+)");
    public static final String INCLUDED_BRANCHES_PARAMETER_NAME = "Included branches";
    public static final String EXCLUDED_BRANCHES_PARAMETER_NAME = "Excluded branches";
    public static final String CONFIGURE_EXCLUDE_BRANCHES_ERROR_MESSAGE_DEFAULT = "The default branch name must not be excluded using the 'Excluded branches' option.";
    public static final String TEST_CODE_INCLUDE_PARAMETER_NAME = "Test-code path pattern";
    public static final String TEST_CODE_EXCLUDE_PARAMETER_NAME = "Test-code path exclude pattern";
    public static final String ENABLE_BRANCH_ANALYSIS_PARAMETER_NAME = "Enable branch analysis";
    private static final String FILE_SIZE_EXCLUDE_PARAMETER_NAME = "File-size exclude";
    public static final String POLLING_INTERVAL_PARAMETER_NAME = "Polling interval";
    public static final String DEFAULT_REPOSITORY_IDENTIFIER = "repository1";
    public static final String PREPEND_REPOSITORY_IDENTIFIER_PARAMETER_NAME = "Prepend repository identifier";
    public static final String PATH_PREFIX_TRANSFORMATION_PARAMETER_NAME = "Path prefix transformation";
    @ConfigExposed(name="Repository identifier", description="A unique identifier used to reference the repository. This is also shown in the UI and should have a meaningful value.", required=true)
    protected String repositoryIdentifier = "repository1";
    @ConfigExposed(name="Default branch name", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="The name of the default branch. This branch is used as the default in the Web UI and as the target for external uploads, if no other branch is chosen/specified. This setting needs to be identical over all repository connectors configured for this project. Must not be empty, but can be set to any value if branching is disabled.", required=true)
    protected String defaultBranchName;
    @ConfigExposed(name="Test-code path pattern", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="Ant patterns describing the file paths to be considered test code. Files that match one of the given patterns are considered to be test code unless also matched by a pattern in `Test-code path exclude pattern`. Patterns can be separated by comma or newline. Files matched as test code will be excluded from test gap treemaps, will not have a line coverage metric calculated and are not considered for the \"Test Coverage\" feature in the Merge Request details view.\nLines starting with '##' are ignored.", multilineText=true)
    public final List<String> testCodeIncludePatterns = new ArrayList<String>();
    @ConfigExposed(name="Test-code path exclude pattern", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="Ant patterns describing the file paths that should be excluded from the test-code files matched by option `Test-code path pattern`. Files that match one of the given patterns will not be considered test code. Patterns can be separated by comma or newline.\nLines starting with '##' are ignored.", multilineText=true)
    public final List<String> testCodeExcludePatterns = new ArrayList<String>();
    @ConfigExposed(name="Prepend repository identifier", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="Whether to include the repository identifier as a prefix for the created file paths.")
    public boolean prependRepositoryIdentifier = false;
    @ConfigExposed(name="Included file names", description="Ant patterns describing the files to be read from the repository. Files will be matched case-insensitively. Patterns can be inserted in two ways:\n1. Multiple lines where each pattern is inserted in a new line, e.g.:\n    **.java\n    **/*.js\n2. Single line with patterns separated by a comma, e.g. **.java, **/*.js\nLines starting with '##' are ignored.", multilineText=true, required=true)
    public final List<String> codeIncludePatterns = new ArrayList<String>();
    @ConfigExposed(name="Excluded file names", description="Ant patterns describing the files to be excluded from the repository. Files will be matched case-insensitively. Patterns can be inserted in two ways:\n1. Multiple lines where each pattern is inserted in a new line, e.g.:\n    **/*test/*\n    **/*Test*\n2. Single line with patterns separated by a comma, e.g. **/*test/*, **/*Test*\nLines starting with '##' are ignored.", multilineText=true)
    public final List<String> codeExcludePatterns = new ArrayList<String>();
    @ConfigExposed(name="Enable branch analysis", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Whether not only the main line but also branches should be analyzed.", dependentOptions={"Included branches", "Excluded branches"})
    public boolean branchingEnabled = this.branchingEnabledDefaultValue();
    @ConfigExposed(name="Included branches", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Regex patterns describing the branches to be read from the repository. Patterns can be separated by comma or newline. Leave empty to include all branches.\nLines starting with '##' are ignored.", multilineText=true)
    public final List<String> branchIncludePatterns = new ArrayList<String>(Collections.singletonList(".*"));
    @ConfigExposed(name="Excluded branches", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Regex patterns describing the branches to be excluded from the repository. Patterns can be separated by comma or newline\nLines starting with '##' are ignored.", multilineText=true)
    public final List<String> branchExcludePatterns = new ArrayList<String>();
    @ConfigExposed(name="Start revision", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="The first date or revision to be read. The preselected 'branching configuration' will use the earliest value from the branch configuration.")
    protected String startRevision = "";
    @ConfigExposed(name="End revision", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="The last date or revision to be read. The preselected 'latest revision' will read the history up to the latest revision.")
    protected String endRevision = null;
    @ConfigExposed(name="Text filter", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="A list of regular expressions describing what parts of a file should be excluded from analysis, e.g. generated code. The syntax conforms to Java regular expressions. Multiple patterns can be separated by line break or comma.\nMake sure to escape reserved characters like '(', ')' or '.' as well as commas properly with the escape character '\\\\'. \nLines starting with '##' are ignored.", multilineText=true)
    protected final List<String> textFilter = new ArrayList<String>();
    @ConfigExposed(name="Language mapping", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="Mapping from ant pattern to language used to override default language mapping. Example: **.jav -> JAVA, **/code/*.sql -> PLSQL")
    private final PairList<String, String> languageMapping = new PairList();
    @ConfigExposed(name="Analysis report mapping", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="Mapping from ant pattern to report format to be imported. Example: **/junit.xml -> JUNIT, **/jacoco.xml -> JACOCO")
    protected PairList<String, String> reportMapping = this.reportMappingDefaultValue();
    @ConfigExposed(name="Partition Pattern", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="A regular expression to extract the partition from the path of the artifacts. The first non-null group is used as partition e.g.  use sub-folders of coverage as partition \"coverage/([^/]+)/\"")
    public String partitionPattern = this.partitionPatternDefaultValue();
    @ConfigExposed(name="Content exclude", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="A comma-separated list of filters that removes the complete content of a file (i.e., content is shown in grey and not analyzed) based on a regular expression matched against the file's content. The syntax conforms to Java regular expressions.The provided regex must match a substring of the file's content, i.e. 'generated' (without quotes) will exclude all files containing the substring 'generated'. \nMake sure to escape reserved characters like '(', ')' or '.' as well as commas properly with the escape character '\\\\'. \nLines starting with '##' are ignored.", multilineText=true)
    protected final List<String> contentExclude = new ArrayList<String>();
    @ConfigExposed(name="File-size exclude", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="A file size limit (i.e., contents of larger files are shown in grey and not analyzed). The file size is given in bytes with units (B, KB, KiB, ...). The default limit is 1MB which corresponds to about 20-30 kLOC.")
    private String fileSizeExclude = "1MB";
    @ConfigExposed(name="Polling interval", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Delay used for polling the repository in seconds (default is 60 seconds).", changeRequiresReAnalysis=false)
    public int pollingIntervalSeconds = 60;
    @ConfigExposed(name="Source library connector", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="If this is true, the contained files will only be used for source library lookup, but not for analysis. Library files will also not be visible in Teamscale. For example, this can be used for third-party C/C++ header files that are required for compilation.")
    public boolean sourceLibraryConnector = false;
    @ConfigExposed(name="Run to exhaustion", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="If this is true, the repository will not be polled after the current head is reached.")
    public boolean runToExhaustion = false;
    @ConfigExposed(name="Preserve empty commits", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="If this is true, Teamscale also reads and processes commits without relevant changes. This can be useful for showing these in the activity stream as well or for post-processing empty commits (e.g. for Gerrit voting). Disabling this can improve performance. Please note that all fork commits will be preserved in any case, even if they are empty and this option is not set.")
    public boolean keepEmptyCommits = true;
    @ConfigExposed(name="Delta size", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="Adjusts the size of deltas produced by this connector (experts only, default is 500).", changeRequiresReAnalysis=false)
    public int deltaSize = 500;
    @ConfigExposed(name="Path prefix transformation", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="Prefix transformations that are applied to the paths from the repository. So a path that matches a given prefix has this prefix replaced by the matched value. Example: 'some_project/trunk -> some_project, other_project/trunk -> the_project'")
    private final PairList<String, String> pathPrefixTransformation = new PairList();
    @ConfigExposed(name="Path transformation", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="Regex transformations that are applied to the paths from the repository. Example: '/trunk/ -> /'")
    private final PairList<String, String> pathTransformations = new PairList();
    @ConfigExposed(name="Encoding", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="This can be used to set the encoding used (e.g. UTF-8, latin1) when reading files. Leave this empty to use the platform's default encoding.")
    public String encodingName = "";
    @ConfigExposed(name="Author transformation", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="Regex transformations that are applied to the authors of the repository. \n\nExample: 'Bob -> Robert'")
    private final PairList<String, String> authorTransformations = new PairList();
    @ConfigExposed(name="Branch transformation", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="Regex transformations that are applied to the branch names of the repository. The mapping should be one-to-one.\n\nNote that include/exclude patterns for branch names are evaluated before the transformation.\n\nExample: 'master -> main'.\n\nThe precondition for the transformation is that no actual branch with the same name as the transformation target (e.g., 'main' in the previous example) is analysed. To ensure this, the transformation targets are automatically added to the list of excluded branches.")
    private final PairList<String, String> branchTransformations = new PairList();
    @ConfigExposed(name="Partitions Required for Security View", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="List of external upload partitions that are expected to be present to assess the security of the project.", changeRequiresReAnalysis=false)
    public final List<String> partitionsRequiredForSecurityOverview = new ArrayList<String>();
    protected String changeRetrieverTriggerName;

    protected RepositoryConnectorDescriptorBase(ERepositoryConnector connectorType, String defaultBranchName) {
        super((IConnectorEnum)connectorType, EConnectorType.SOURCE_CODE_REPOSITORY);
        this.defaultBranchName = defaultBranchName;
    }

    public String getConnectorIdentifier() {
        return this.getRepositoryIdentifier();
    }

    public String getConnectorIdentifierOptionName() {
        return REPOSITORY_IDENTIFIER_PARAMETER_NAME;
    }

    protected void configureIndices(ConnectorDescriptorBase.IIndexCreator indexCreator) {
        super.configureIndices(indexCreator);
        indexCreator.createProjectIndex(RepositoryOriginalPathIndex.class);
        indexCreator.createProjectIndex(RepositoryChangeIndex.class, this.repositoryIdentifier + "-repositorychanges");
        indexCreator.createProjectIndex(CommitTreeIndex.class, CommitTreeIndex.getIndexNameForRepository((String)this.repositoryIdentifier));
        indexCreator.createProjectIndex(BranchPointerHistoryIndex.class, BranchPointerHistoryIndex.getIndexName(this.repositoryIdentifier));
    }

    protected void configureTriggers(ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        super.configureTriggers(triggerCreator);
        this.createChangeRetrieverTrigger(triggerCreator);
        this.createContentUpdateTrigger(triggerCreator);
        this.createIssueCsvTriggers(triggerCreator);
        this.createRequirementCsvTrigger(triggerCreator);
    }

    private void createIssueCsvTriggers(ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        if (CollectionUtils.anyMatch((Collection)this.reportMapping.extractSecondList(), reportFormat -> reportFormat.equalsIgnoreCase(EReportFormat.ISSUE_CSV.name()))) {
            TriggerBuilder issueMappingSynchronizer = BugTrackerConnectorDescriptorBase.createIssueMappingSynchronizer(this.repositoryIdentifier);
            TriggerBuilder pathIssueSynchronizer = BugTrackerConnectorDescriptorBase.createPathIssueSynchronizer();
            issueMappingSynchronizer.setTriggerParameter("issue-in-commit-pattern", ISSUE_CSV_COMMIT_MESSAGE_MAPPING);
            triggerCreator.createTrigger(issueMappingSynchronizer, this.repositoryIdentifier);
            triggerCreator.createTrigger(pathIssueSynchronizer, this.repositoryIdentifier);
        }
    }

    private void createRequirementCsvTrigger(ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        Optional requirementsCsvIdPattern = TeamscaleSystemProperties.REQUIREMENTS_CSV_ID_PATTERN.getValue();
        if (requirementsCsvIdPattern.isPresent() && CollectionUtils.anyMatch((Collection)this.reportMapping.extractSecondList(), reportFormat -> reportFormat.equalsIgnoreCase(EReportFormat.REQUIREMENTS_CSV.name()))) {
            RequirementsManagementToolConnectorDescriptorBase.appendRequiredSynchronizer(triggerCreator, (String)requirementsCsvIdPattern.get(), this.repositoryIdentifier);
        }
    }

    protected void createChangeRetrieverTrigger(ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        TriggerBuilder trigger = new TriggerBuilder(this.getChangeRetrieverBlockName(), ETriggerConcurrency.OUTPUT_ISOLATED);
        this.setCommonParameters(trigger, triggerCreator);
        this.setChangeRetrieverParameters(trigger);
        this.changeRetrieverTriggerName = triggerCreator.createTrigger(trigger, this.repositoryIdentifier);
    }

    private void createContentUpdateTrigger(ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        TriggerBuilder trigger = new TriggerBuilder(this.getContentUpdaterBlockName(), ETriggerConcurrency.PARALLEL);
        this.setCommonParameters(trigger, triggerCreator);
        this.setContentUpdaterParameters(trigger, triggerCreator.getConfiguredLanguages());
        RepositoryConnectorDescriptorBase.setCodeScopeParameters(trigger, triggerCreator.getCodeScopes());
        triggerCreator.createTrigger(trigger, this.repositoryIdentifier);
    }

    protected void setCommonParameters(TriggerBuilder triggerBuilder, ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        triggerBuilder.setTriggerParameter("internal-project-id", this.getProjectId().toString());
        triggerBuilder.setTriggerParameter("connection-identifier", this.repositoryIdentifier);
        triggerBuilder.setTriggerParameter("hidden-element-connector", this.sourceLibraryConnector);
        triggerBuilder.renameIndex("commit-tree", this.getCommitTreeName());
        triggerBuilder.setTriggerParameter("code-include-pattern", ITriggerParameter.of((Object)CollectionUtils.unionSet(this.codeIncludePatterns, (Collection[])new Collection[]{this.reportMapping.extractFirstList()})));
        triggerBuilder.setTriggerParameter("code-exclude-pattern", ITriggerParameter.of(this.codeExcludePatterns));
        RepositoryConnectorDescriptorBase.setMinimalStartTimestamp(triggerBuilder, triggerCreator);
        this.setRevisionParameter(START_REVISION_PARAMETER_NAME, "start-revision", this.startRevision, triggerBuilder, triggerCreator);
        this.setRevisionParameter(END_REVISION_PARAMETER_NAME, "end-revision", this.endRevision, triggerBuilder, triggerCreator);
        if (this.branchIncludePatterns.isEmpty()) {
            this.branchIncludePatterns.add(".*");
        }
        triggerBuilder.setTriggerParameter("default-branch-name", this.getDefaultBranchName());
        triggerBuilder.setTriggerParameter("branching", this.branchingEnabled);
        triggerBuilder.setTriggerParameter("branch-include-pattern", ITriggerParameter.of(this.branchIncludePatterns));
        this.branchExcludePatterns.addAll(this.branchTransformations.extractSecondList());
        triggerBuilder.setTriggerParameter("branch-exclude-pattern", ITriggerParameter.of(this.branchExcludePatterns));
        triggerBuilder.setTriggerParameter("test-code-include-pattern", ITriggerParameter.of(this.testCodeIncludePatterns));
        triggerBuilder.setTriggerParameter("test-code-exclude-pattern", ITriggerParameter.of(this.testCodeExcludePatterns));
        triggerBuilder.setTriggerParameter("branch-rename-pattern", ITriggerParameter.of(this.branchTransformations));
        triggerBuilder.setTriggerParameter("polling-interval", this.pollingIntervalSeconds);
        triggerBuilder.renameIndex("single-repositorychanges", RepositoryChangeIndex.getIndexName(this.repositoryIdentifier));
        triggerBuilder.renameIndex("branch-pointer-history", BranchPointerHistoryIndex.getIndexName(this.repositoryIdentifier));
    }

    private static void setMinimalStartTimestamp(TriggerBuilder triggerBuilder, ConnectorDescriptorBase.ITriggerCreator triggerCreator) {
        ProjectConfiguration projectConfiguration = triggerCreator.getNewProjectConfiguration();
        if (projectConfiguration.getBranchingConfiguration() == null) {
            return;
        }
        projectConfiguration.getBranchingConfiguration().getMinimalStartTimestamp().ifPresent(minimalStartTimestamp -> triggerBuilder.setTriggerParameter("minimal-start-timestamp", minimalStartTimestamp));
    }

    protected void setRevisionParameter(String descriptorParameterName, String triggerParameterName, String value, TriggerBuilder triggerBuilder, ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        Optional<String> revision = new RevisionParameterProcessor(triggerBuilder, triggerCreator, this.repositoryIdentifier).calculateRevisionValue(descriptorParameterName, triggerParameterName, value);
        revision.ifPresent(revisionValue -> triggerBuilder.setTriggerParameter(triggerParameterName, revisionValue));
    }

    private static void setCodeScopeParameters(TriggerBuilder trigger, List<CodeScope> codeScopes) {
        LinkedHashMap pathIncludesPerCodeScope = new LinkedHashMap();
        LinkedHashMap pathExcludesPerCodeScope = new LinkedHashMap();
        LinkedHashMap contentIncludesPerCodeScope = new LinkedHashMap();
        LinkedHashMap contentExcludesPerCodeScope = new LinkedHashMap();
        codeScopes.forEach(scope -> {
            pathIncludesPerCodeScope.put(scope.getName(), CollectionUtils.parseMultiValueStringToList((List)scope.getPathIncludes(), (boolean)true));
            pathExcludesPerCodeScope.put(scope.getName(), CollectionUtils.parseMultiValueStringToList((List)scope.getPathExcludes(), (boolean)true));
            contentIncludesPerCodeScope.put(scope.getName(), CollectionUtils.parseMultiValueStringToList((List)scope.getContentIncludes(), (boolean)true));
            contentExcludesPerCodeScope.put(scope.getName(), CollectionUtils.parseMultiValueStringToList((List)scope.getContentExcludes(), (boolean)true));
        });
        trigger.setTriggerParameter("code-scope-path-include-patterns", (ITriggerParameter)new CodeScopeAware(pathIncludesPerCodeScope, Collections.emptyList()));
        trigger.setTriggerParameter("code-scope-path-exclude-patterns", (ITriggerParameter)new CodeScopeAware(pathExcludesPerCodeScope, Collections.emptyList()));
        trigger.setTriggerParameter("code-scope-content-include-patterns", (ITriggerParameter)new CodeScopeAware(contentIncludesPerCodeScope, Collections.emptyList()));
        trigger.setTriggerParameter("code-scope-content-exclude-patterns", (ITriggerParameter)new CodeScopeAware(contentExcludesPerCodeScope, Collections.emptyList()));
    }

    public String getCommitTreeName() {
        return RepositoryConnectorDescriptorBase.getCommitTreeName(this.repositoryIdentifier);
    }

    protected static String getCommitTreeName(String repositoryIdentifier) {
        return CommitTreeIndex.getIndexNameForRepository((String)repositoryIdentifier);
    }

    public final String getDefaultBranchName() {
        CCSMAssert.isTrue((!StringUtils.isEmpty((String)this.defaultBranchName) ? 1 : 0) != 0, (String)CONFIGURE_DEFAULT_BRANCH_ERROR_MESSAGE_EMPTY);
        return this.defaultBranchName;
    }

    public String getTransformedDefaultBranchName() {
        return this.getBranchTransformation().apply(this.getDefaultBranchName());
    }

    protected void setChangeRetrieverParameters(TriggerBuilder trigger) throws ProjectConfigurationException {
        this.checkNotEmpty(this.codeIncludePatterns, INCLUDED_FILE_NAMES_PARAMETER_NAME);
        trigger.setTriggerParameter("keep-empty-commits", this.keepEmptyCommits);
        this.checkNonNegative(this.deltaSize, "Delta size");
        trigger.setSchedulingParameter(ESchedulingParameter.MAX_DELTA_SIZE, (Object)this.deltaSize);
        this.checkNonNegative(this.pollingIntervalSeconds, POLLING_INTERVAL_PARAMETER_NAME);
        trigger.setSchedulingParameter(ESchedulingParameter.PERIOD, (Object)Duration.ofSeconds(this.pollingIntervalSeconds));
        trigger.setSchedulingParameter(ESchedulingParameter.RUN_TO_EXHAUSTION, (Object)this.runToExhaustion);
    }

    protected void setContentUpdaterParameters(TriggerBuilder trigger, Collection<ELanguage> configuredLanguages) {
        trigger.setTriggerParameter("prepended-repository-identifier", this.prependRepositoryIdentifier);
        PairList fullPathTransformation = new PairList(this.pathTransformations.size() + this.pathPrefixTransformation.size());
        fullPathTransformation.addAll(this.pathTransformations);
        fullPathTransformation.addAll(this.pathPrefixTransformation.mapFirst(prefix -> "^" + Pattern.quote(prefix)));
        trigger.setTriggerParameter("path-transformation", ITriggerParameter.of((Object)fullPathTransformation));
        trigger.setTriggerParameter("author-transformation", ITriggerParameter.of(this.authorTransformations));
        trigger.setTriggerParameter("text-filter-pattern", ITriggerParameter.of(this.textFilter));
        trigger.setTriggerParameter("content-exclude-pattern", ITriggerParameter.of(this.contentExclude));
        trigger.setTriggerParameter("max-file-size", this.fileSizeExclude);
        if (!StringUtils.isEmpty((String)this.encodingName)) {
            trigger.setTriggerParameter("encoding", this.encodingName.trim());
        }
        trigger.setTriggerParameter("report-mapping", ITriggerParameter.of(this.reportMapping));
        trigger.setTriggerParameter("connector-id", this.repositoryIdentifier);
        trigger.setTriggerParameter("partition-pattern", this.partitionPattern);
        trigger.setTriggerParameter("language-mapping", ITriggerParameter.of(this.languageMapping));
        trigger.setTriggerParameter("configured-language", ITriggerParameter.of(configuredLanguages));
    }

    protected abstract Class<? extends ChangeRetrieverAnalysisStep> getChangeRetrieverBlockName();

    protected abstract Class<? extends ChangeProcessorAnalysisStep> getContentUpdaterBlockName();

    protected String getErrorLocation() {
        return this.repositoryIdentifier;
    }

    public void validate() throws ConnectorValidationException {
        super.validate();
        try {
            this.checkNotEmpty(this.repositoryIdentifier, REPOSITORY_IDENTIFIER_PARAMETER_NAME);
        }
        catch (ProjectConfigurationException e) {
            throw new ConnectorValidationException((Throwable)e);
        }
        if (this.deltaSize <= 0) {
            throw new ConnectorValidationException("Delta size must be greater than 0");
        }
        if (this.pollingIntervalSeconds <= 0) {
            throw new ConnectorValidationException("Polling interval must be greater than 0");
        }
        if (this.codeIncludePatterns.isEmpty() && this.reportMapping.isEmpty()) {
            throw new ConnectorValidationException("You must provide at least one include pattern or report mapping. For example: **.java");
        }
        if (!StringUtils.isEmpty((String)this.encodingName) && !Charset.isSupported(this.encodingName.trim())) {
            throw new ConnectorValidationException("Unsupported charset on this platform: " + this.encodingName);
        }
        this.validateAntPatterns();
        this.validateRegularExpressions();
        this.validateDefaultBranchName();
        this.validateExcludeBranches();
        this.validateRevisionOrDate(this.startRevision, START_REVISION_PARAMETER_NAME);
        this.validateRevisionOrDate(this.endRevision, END_REVISION_PARAMETER_NAME);
        RepositoryConnectorDescriptorBase.validateStartEndDateOrder(this.startRevision, this.endRevision);
        this.validateFileSizeExclude();
        this.validateLanguageMapping();
        this.validateReportMapping();
        ConnectorUtils.validateBranchTransformationTargets(this.branchTransformations, (String)this.defaultBranchName);
    }

    private void validateAntPatterns() throws ConnectorValidationException {
        RepositoryConnectorDescriptorBase.validateAntPattern(INCLUDED_FILE_NAMES_PARAMETER_NAME, this.codeIncludePatterns);
        RepositoryConnectorDescriptorBase.validateAntPattern(EXCLUDED_FILE_NAMES_PARAMETER_NAME, this.codeExcludePatterns);
        RepositoryConnectorDescriptorBase.validateAntPattern(TEST_CODE_INCLUDE_PARAMETER_NAME, this.testCodeIncludePatterns);
        RepositoryConnectorDescriptorBase.validateAntPattern(TEST_CODE_EXCLUDE_PARAMETER_NAME, this.testCodeExcludePatterns);
    }

    private void validateRegularExpressions() throws ConnectorValidationException {
        ConnectorUtils.validateAndReturnPatterns(this.branchIncludePatterns, (String)"branch include");
        ConnectorUtils.validateAndReturnPatterns(this.contentExclude, (String)CONTENT_EXCLUDE_PARAMETER_NAME);
        ConnectorUtils.validateAndReturnPatterns(this.textFilter, (String)TEXT_FILTER_PARAMETER_NAME);
        ConnectorUtils.validateAndReturnPattern((String)this.partitionPattern, (String)PARTITION_PATTERN_PARAMETER_NAME);
        ConnectorUtils.validateAndReturnPatterns((List)this.pathTransformations.extractFirstList(), (String)"Path transformation (first part)");
        ConnectorUtils.validateAndReturnPatterns((List)this.authorTransformations.extractFirstList(), (String)"Author transformation (first part)");
        ConnectorUtils.validateAndReturnPatterns((List)this.branchTransformations.extractFirstList(), (String)"Branch transformation (first part)");
    }

    protected void validateExcludeBranches() throws ConnectorValidationException {
        List excludeBranches = ConnectorUtils.validateAndReturnPatterns(this.branchExcludePatterns, (String)"branch exclude");
        if (ConnectorUtils.isBranchMatchedByAnyPattern((String)this.defaultBranchName, (Collection)excludeBranches)) {
            throw new ConnectorValidationException(CONFIGURE_EXCLUDE_BRANCHES_ERROR_MESSAGE_DEFAULT);
        }
    }

    protected void validateDefaultBranchName() throws ConnectorValidationException {
        if (StringUtils.isEmpty((String)this.defaultBranchName)) {
            throw new ConnectorValidationException(CONFIGURE_DEFAULT_BRANCH_ERROR_MESSAGE_EMPTY);
        }
    }

    private static void validateAntPattern(String parameterName, List<String> patterns) throws ConnectorValidationException {
        for (String pattern : patterns) {
            try {
                AntPatternUtils.convertPattern((String)pattern, (boolean)false);
            }
            catch (PatternSyntaxException e) {
                throw new ConnectorValidationException(String.format("Problem parsing pattern '%s' in parameter '%s': %s", pattern, parameterName, e.getMessage()), (Throwable)e);
            }
        }
    }

    private void validateLanguageMapping() throws ConnectorValidationException {
        RepositoryConnectorDescriptorBase.validateAntPattern("Language mapping (first part)", this.languageMapping.extractFirstList());
        for (String language : this.languageMapping.extractSecondList()) {
            if (EnumUtils.valueOfIgnoreCase(ELanguage.class, (String)language) != null) continue;
            throw new ConnectorValidationException("Unknown language '" + language + "' found in language mapping!");
        }
    }

    private void validateReportMapping() throws ConnectorValidationException {
        RepositoryConnectorDescriptorBase.validateAntPattern("Report mapping (first part)", this.reportMapping.extractFirstList());
        for (String format : this.reportMapping.extractSecondList()) {
            if (EnumUtils.valueOfIgnoreCase(EReportFormat.class, (String)format) != null) continue;
            throw new ConnectorValidationException("Unknown report format '" + format + "' found in report format mapping!");
        }
    }

    private void validateFileSizeExclude() throws ConnectorValidationException {
        if (StringUtils.isEmpty((String)this.fileSizeExclude)) {
            return;
        }
        try {
            FileSystemUtils.parseDataSize((String)this.fileSizeExclude);
        }
        catch (NumberFormatException e) {
            throw new ConnectorValidationException("File-size exclude is not a valid size.");
        }
    }

    protected void validateRevisionOrDate(String revisionOrDate, String displayName) throws ConnectorValidationException {
        if (StringUtils.isEmpty((String)revisionOrDate)) {
            return;
        }
        if (ConnectorUtils.parseDate((String)revisionOrDate).isEmpty() && !this.validateRevision(revisionOrDate)) {
            throw new ConnectorValidationException(displayName + " is not a valid date or revision");
        }
    }

    protected abstract boolean validateRevision(String var1);

    private static void validateStartEndDateOrder(String startDate, String endDate) throws ConnectorValidationException {
        if (StringUtils.isEmpty((String)startDate) || StringUtils.isEmpty((String)endDate)) {
            return;
        }
        Optional start = ConnectorUtils.parseDate((String)startDate);
        Optional end = ConnectorUtils.parseDateGetEndOfDay((String)endDate);
        if (start.isPresent() && end.isPresent() && !((ZonedDateTime)start.get()).isBefore((ChronoZonedDateTime)end.get())) {
            throw new ConnectorValidationException("The start date is not before the end date");
        }
    }

    public void storeConfigurationDataInternal(ProjectStorageSystem projectStorageSystem) throws StorageException, ConnectorValidationException {
        this.storeUrlToTriggerMapping(projectStorageSystem, this.getRepositoryUri().toString());
    }

    protected void storeUrlToTriggerMapping(ProjectStorageSystem projectStorageSystem, String repositoryUrl) throws StorageException {
        RepositoryToTriggerMappingIndex mappingIndex = RepositoryConnectorDescriptorBase.getIndexFromProjectStorageSystem(projectStorageSystem);
        if (!StringUtils.isEmpty((String)repositoryUrl)) {
            this.setChangeRetrieverNameIfEmpty();
            mappingIndex.insertMapping(repositoryUrl, this.changeRetrieverTriggerName);
        }
    }

    public void deleteConfigurationData(ProjectStorageSystem projectStorageSystem, String url) throws StorageException, ConnectorValidationException {
        RepositoryToTriggerMappingIndex mappingIndex = RepositoryConnectorDescriptorBase.getIndexFromProjectStorageSystem(projectStorageSystem);
        if (!StringUtils.isEmpty((String)url)) {
            this.setChangeRetrieverNameIfEmpty();
            mappingIndex.removeMapping(url, this.changeRetrieverTriggerName);
        }
    }

    private void setChangeRetrieverNameIfEmpty() {
        if (StringUtils.isEmpty((String)this.changeRetrieverTriggerName)) {
            this.changeRetrieverTriggerName = TriggerBuilder.buildTriggerName((String)this.repositoryIdentifier, (String)TriggerBuilder.getSimpleTriggerName(this.getChangeRetrieverBlockName()));
        }
    }

    private static RepositoryToTriggerMappingIndex getIndexFromProjectStorageSystem(ProjectStorageSystem projectStorageSystem) throws StorageException {
        return (RepositoryToTriggerMappingIndex)projectStorageSystem.openProjectIndex(RepositoryToTriggerMappingIndex.class, null);
    }

    protected boolean branchingEnabledDefaultValue() {
        return false;
    }

    protected String partitionPatternDefaultValue() {
        return "";
    }

    protected PairList<String, String> reportMappingDefaultValue() {
        return new PairList();
    }

    protected abstract URI getRepositoryUri() throws StorageException, ConnectorValidationException;

    public ERepositoryConnector getRepositoryType() {
        return (ERepositoryConnector)this.connectorEnum;
    }

    public final StringTransformation getBranchTransformation() {
        return new StringTransformation(this.branchTransformations.mapFirst(Pattern::compile));
    }

    public String getRepositoryIdentifier() {
        return this.repositoryIdentifier;
    }

    public String getStartRevision() {
        return this.startRevision;
    }

    public String getEndRevision() {
        return this.endRevision;
    }

    @TestOnly
    public void setRepositoryIdentifier(String repositoryIdentifier) {
        this.repositoryIdentifier = repositoryIdentifier;
    }

    @TestOnly
    public void setStartRevisionForTesting(String startRevision) {
        this.startRevision = startRevision;
    }

    @TestOnly
    public void setEndRevisionForTesting(String endRevision) {
        this.endRevision = endRevision;
    }

    @TestOnly
    public void setDefaultBranchNameForTesting(String defaultBranchName) {
        this.defaultBranchName = defaultBranchName;
    }

    @TestOnly
    public void addBranchTransformationForTesting(String sourceBranch, String targetBranch) {
        this.branchTransformations.add((Object)sourceBranch, (Object)targetBranch);
    }

    @TestOnly
    public void addContentExcludePatternsForTesting(List<String> contentExclude) {
        this.contentExclude.addAll(contentExclude);
    }

    @TestOnly
    public void addTextFilterPatternsForTesting(List<String> textFilter) {
        this.textFilter.addAll(textFilter);
    }

    @TestOnly
    public void addPathTransformationsForTesting(PairList<String, String> pathTransformations) {
        this.pathTransformations.addAll(pathTransformations);
    }

    @TestOnly
    public void addAuthorTransformationsForTesting(PairList<String, String> authorTransformations) {
        this.authorTransformations.addAll(authorTransformations);
    }

    @TestOnly
    public void addBranchTransformationsForTesting(PairList<String, String> branchTransformations) {
        this.branchTransformations.addAll(branchTransformations);
    }

    private String getPreselectedUIBranchNameBeforeBranchTransformation(String preselectedUIBranchName) {
        List<Pair> onlyRelevantTransformations = this.branchTransformations.stream().filter(pair -> preselectedUIBranchName.equals(pair.getSecond())).toList();
        if (!onlyRelevantTransformations.isEmpty()) {
            return (String)onlyRelevantTransformations.getFirst().getFirst();
        }
        return preselectedUIBranchName;
    }

    public boolean hasPreselectedUIBranch(String preselectedUIBranchName) throws ConnectorValidationException {
        if (this.transformsBranch(preselectedUIBranchName)) {
            return false;
        }
        String preselectedUIBranchNameBeforeTransformation = this.getPreselectedUIBranchNameBeforeBranchTransformation(preselectedUIBranchName);
        if (preselectedUIBranchNameBeforeTransformation.equals(this.defaultBranchName)) {
            return true;
        }
        return this.hasPreselectedUIBranchBeforeBranchTransformationUnlikeDefaultBranch(preselectedUIBranchNameBeforeTransformation);
    }

    private boolean transformsBranch(String branchName) {
        return this.branchTransformations.stream().anyMatch(pair -> ((String)pair.getFirst()).equals(branchName));
    }

    protected abstract boolean hasPreselectedUIBranchBeforeBranchTransformationUnlikeDefaultBranch(String var1) throws ConnectorValidationException;

    public List<String> getPartitionsRequiredForSecurityView() {
        return Collections.unmodifiableList(this.partitionsRequiredForSecurityOverview);
    }
}

