/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.repository.git.GitPreviewUtils;
import com.teamscale.index.repository.git.GitRepositoryConnector;
import com.teamscale.index.repository.retrievers.ICommitMessagesRetriever;
import java.net.URI;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

public class GitCommitMessagesRetriever
implements ICommitMessagesRetriever {
    protected final ServerOptionIndex serverOptionIndex;
    protected final Logger interactionLogger;

    public GitCommitMessagesRetriever(GlobalStorageSystem storageSystem, Logger interactionLogger) throws StorageException {
        this.serverOptionIndex = (ServerOptionIndex)storageSystem.openGlobalIndex(ServerOptionIndex.class);
        this.interactionLogger = interactionLogger;
    }

    @Override
    public List<String> fetchCommitMessages(String branchName, boolean projectExists, String username, ExternalCredentials credentials, ConnectorConfiguration connectorConfiguration) throws RepositoryException, ProjectConfigurationException {
        URI location = this.getRepositoryUri(credentials, connectorConfiguration);
        return GitPreviewUtils.retrieveCommitMessagesFromGit(branchName, location, connectorConfiguration, this.serverOptionIndex, credentials, this.isGerrit());
    }

    protected URI getRepositoryUri(ExternalCredentials credentials, ConnectorConfiguration connectorConfiguration) throws ProjectConfigurationException, RepositoryException {
        String pathSuffix = connectorConfiguration.getOptionValue("Path suffix");
        return GitRepositoryConnector.adjustGitUrlAndConvertToUri(credentials.uri, pathSuffix);
    }

    protected boolean isGerrit() {
        return false;
    }
}

