/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.azure_devops;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptor;
import com.teamscale.core.analysis.trigger.AnalysisStepBase;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.analysis.trigger.ChangeRetrieverAnalysisStep;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.BaseUrlOption;
import com.teamscale.core.tfs.ISubscriptionRestClient;
import com.teamscale.core.utils.HttpRequestUtils;
import com.teamscale.index.repository.git.azure_devops.AzureDevOpsGitChangeRetriever;
import com.teamscale.index.repository.git.azure_devops.AzureDevOpsGitClient;
import com.teamscale.index.repository.git.azure_devops.AzureDevOpsGitContentUpdater;
import com.teamscale.index.repository.git.azure_devops.AzureDevOpsGitMergeRequestAnnotationTrigger;
import com.teamscale.index.repository.git.azure_devops.AzureDevOpsGitMergeRequestSynchronizer;
import com.teamscale.index.repository.git.azure_devops.model.AzureDevOpsGitRepositoryDto;
import com.teamscale.index.repository.git.common.CommitVotingTriggerBase;
import com.teamscale.index.repository.git.common.WebHookBasedGitRepositoryConnectorDescriptorBase;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.CommonUtils;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

@ConnectorDescriptor
public class AzureDevOpsGitRepositoryConnectorDescriptor
extends WebHookBasedGitRepositoryConnectorDescriptorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String LEGACY_AZURE_HOOK_END_POINT = "azure-devops-hook";
    public static final String AZURE_HOOK_END_POINT = "api/azure-devops-git/web-hook";
    @VisibleForTesting
    static final Set<String> SERVICE_HOOK_EVENTS = Set.of("git.push", "git.pullrequest.created", "git.pullrequest.updated");

    private AzureDevOpsGitRepositoryConnectorDescriptor() {
        super(ERepositoryConnector.AZURE_DEVOPS_GIT, LOGGER);
        this.autoExpose();
    }

    @VisibleForTesting
    AzureDevOpsGitRepositoryConnectorDescriptor(String repositoryName) {
        this();
        this.repositoryName = repositoryName;
    }

    private AzureDevOpsGitRepositoryDto getRepository() throws ConnectorValidationException {
        AzureDevOpsGitClient client = this.getClient();
        try {
            return client.getRepository(client.getRepositoryName());
        }
        catch (ServiceCallException e) {
            String cleanMessage = HttpRequestUtils.removeHtmlTags((String)StringUtils.emptyIfNull((String)e.getMessage()));
            throw new ConnectorValidationException(cleanMessage, (Throwable)e);
        }
    }

    private AzureDevOpsGitClient getClient() throws ConnectorValidationException {
        ExternalCredentials credentials = this.resolveExternalCredentials();
        return new AzureDevOpsGitClient(super.getRepositoryUri().toString(), credentials.username, credentials.password, this.repositoryName, ConnectorValidationException::new, LOGGER);
    }

    @Override
    protected String getCommitLinkTemplate() throws ConnectorValidationException {
        return AzureDevOpsGitRepositoryConnectorDescriptor.concatenateNonEmptyWithSlash(this.getRepositoryUri().toString(), "commit/{commitId}");
    }

    @Override
    protected String getCommitInMergeRequestLinkTemplate() throws ConnectorValidationException {
        return this.getCommitLinkTemplate();
    }

    @Override
    public URI getRepositoryUri() throws ConnectorValidationException {
        return this.parseUri(this.getRepository().getRemoteUrl());
    }

    @Override
    protected void ensureHookIsConfigured(ServerOptionIndex serverOptionIndex) throws StorageException, ServiceCallException, ConnectorValidationException {
        Set<String> remainingEvents;
        String legacyUrl = BaseUrlOption.getBaseUrl((ServerOptionIndex)serverOptionIndex) + LEGACY_AZURE_HOOK_END_POINT;
        String expectedUrl = BaseUrlOption.getBaseUrl((ServerOptionIndex)serverOptionIndex) + AZURE_HOOK_END_POINT;
        AzureDevOpsGitClient client = this.getClient();
        AzureDevOpsGitRepositoryDto repository = this.getRepository();
        List<ISubscriptionRestClient.Subscription> webHooks = client.getHookSubscriptions();
        List<ISubscriptionRestClient.Subscription> existingLegacyWebHooks = this.filterHooksUsingUrlAndEvents(webHooks, legacyUrl, SERVICE_HOOK_EVENTS);
        if (!existingLegacyWebHooks.isEmpty()) {
            for (ISubscriptionRestClient.Subscription hook : existingLegacyWebHooks) {
                client.replaceRepositoryWebHook(hook.id, repository.getId(), repository.getProjectId(), expectedUrl, hook.eventType);
            }
        }
        if ((remainingEvents = AzureDevOpsGitRepositoryConnectorDescriptor.getEventsNotAvailableInWebHooks(existingLegacyWebHooks, SERVICE_HOOK_EVENTS)).isEmpty()) {
            return;
        }
        List<ISubscriptionRestClient.Subscription> existingWebHooks = this.filterHooksUsingUrlAndEvents(webHooks, expectedUrl, remainingEvents);
        if (existingWebHooks.size() >= remainingEvents.size()) {
            return;
        }
        Set<String> hookEvents = AzureDevOpsGitRepositoryConnectorDescriptor.getEventsNotAvailableInWebHooks(existingWebHooks, remainingEvents);
        client.createRepositoryWebHooks(repository.getId(), repository.getProjectId(), expectedUrl, hookEvents);
    }

    @VisibleForTesting
    List<ISubscriptionRestClient.Subscription> filterHooksUsingUrlAndEvents(List<ISubscriptionRestClient.Subscription> webHooks, String expectedUrl, Collection<String> expectedEvents) throws ConnectorValidationException {
        AzureDevOpsGitRepositoryDto repository = this.getRepository();
        return CollectionUtils.filter(webHooks, hook -> hook.isEnabled() && hook.consumerInputs != null && expectedUrl.equals(hook.consumerInputs.url) && hook.publisherInputs != null && repository.getId().equals(hook.publisherInputs.repositoryId) && repository.getProjectId().equals(hook.publisherInputs.projectId) && CommonUtils.isOneOf((Object)hook.eventType, (Collection)expectedEvents));
    }

    private static Set<String> getEventsNotAvailableInWebHooks(List<ISubscriptionRestClient.Subscription> webHooks, Collection<String> eventList) {
        List existingEvents = CollectionUtils.map(webHooks, subscription -> subscription.eventType);
        return CollectionUtils.subtract(eventList, (Collection)existingEvents);
    }

    @Override
    protected Class<? extends ChangeRetrieverAnalysisStep> getChangeRetrieverBlockName() {
        return AzureDevOpsGitChangeRetriever.class;
    }

    @Override
    public Class<? extends AnalysisStepBase> getPullRequestSynchronizerClass() {
        return AzureDevOpsGitMergeRequestSynchronizer.class;
    }

    @Override
    protected Class<? extends ChangeProcessorAnalysisStep> getContentUpdaterBlockName() {
        return AzureDevOpsGitContentUpdater.class;
    }

    @Override
    public Class<? extends CommitVotingTriggerBase<?>> getMergeRequestAnnotationTriggerClass() {
        return AzureDevOpsGitMergeRequestAnnotationTrigger.class;
    }
}

